
/////////////////////////////////
///// NOA へ問い合わせて得る値 /////

function currentDate(){
    return (parent() && parent().currentDate())
    ? parent().currentDate() : todayAndTime();
}

function editorElement(){
    // ReproductiveHistory を呼んだ NOA の CellEditor を返す
    // Group CELL が編集モードでない場合は null が返される
    return parent().editor_ElementForTag(parent().currentTag());
}

function subject(){
    // NOA の subject 欄のデータを返す
    var elm = editorElement();
    if (elm){
        // NOA の CellEditor が開いている場合
        // valueForTag() を使うと編集結果が反映されない
        return elm.innerHTML;
    } else {
        // NOA の CellEditor が閉じている場合
        var obj = parent().valueForTag("ProgressSection.subject");
        return (obj) ? obj.value : "";
    }
}

function setCalendar(){
    // NOA から起動されていれば妊娠歴を自動設定
    _debug("== setCalendar =="); //##
    
    var year = 0;
    var month = 0;
    var day = 0;
    
    var buff = subject(); // subject 欄の内容を NOA から取得
    _debug("buff->"+buff); //##
    
    if (buff){
        var array = buff.split("lmp:");
        if (array.length > 1){
            var lmpSt = trim(array[1]);
            if (lmpSt.length >= 6){
                year = "20" + lmpSt.substr(0, 2);
                month = lmpSt.substr(2, 2);
                day = lmpSt.substr(4, 2);
            }
        }
    }
    
    setOriginalLmp(year, month, day); // カルテ本体の lmp を記憶
    
    // NOA から起動されたのでなければ何もせずに終了
    if (year * month * day == 0) return;
    
    // 最終月経のポップアップを設定
	var td = document.getElementById("lmpArea");
    td.innerHTML = "";
    newDatePopUp(td, "lmp", "", year*1, month*1, day*1, false, lmpChanged);
    
    // 予定日を計算
    calc();

    // 計算された予定日を NOA の編集フィールドへ書戻す
    var array = buff.split("lmp:");
    var leftSt = array[0];
    
    // "lmp:" から改行までの文字列を予定日変換文字列の対象とするので
    // 最終月経の後ろに文字があっても *** 予定日と置換 *** されてしまう
    var rightSt = array[1];
    rightSt = convertSTRING(rightSt, "<br>", "\n");
    var array2 = rightSt.split("\n");
    // lmp: の次から改行前までを document.getElementById("result").innerHTML と置換
    array2[0] = document.getElementById("result").innerHTML;
    rightSt = array2.join("\n");
    
    var value = leftSt + rightSt;
    value = convertSTRING(value, "\n", "<br>");
    var elm = editorElement(); // Group CELL のエディターが開いている場合
    if (elm){
        // elm が編集モードの場合
        elm.innerHTML = value;
    } else {
        // elm が表示モードの場合
        parent().putValueForTag(value, "ProgressSection.subject");
    }
}

///// NOA へ問い合わせて得る値 /////
/////////////////////////////////

var _originalLmp;
function setOriginalLmp(yyyy, mm, dd){
    // カルテ本体の lmp を記憶
    _debug("setOriginalLmp->"+yyyy+"/"+mm+"/"+dd); //##

    _originalLmp = yyyy + "-" + mm + "-" + dd;
}
function originalLmp(){
    // カルテ本体の lmp
    return _originalLmp;
}

var _calendarObject;
function setCalendarObject(obj){
    _calendarObject = obj;
}
function calendarObject(){
    return _calendarObject;
}

var _term;
function setTermDate(val){
    // 分娩予定日を記憶
    _term = val;
}
function termDate(){
    // 分娩予定日を "2011-08-28" 形式で返す
    return _term;
}

function lmp(){
    _debug("== lmp->"+document.getElementById("lmp")); //##
    
	var lmp = document.getElementById("lmp").value;
    var array = lmp.split("-");
	return new Date(array[0], array[1] - 1, array[2]);
}

function now(){
	var elm = document.getElementById("today");
    if (!elm) return null;
    
	var today = elm.value;
    var array = today.split("-");
	return new Date(array[0], array[1] - 1, array[2]);
}

function term(lmp){
	var date = new Date();
	date.setTime(lmp.getTime() + (40 * 7 * 24 * 3600 * 1000));
    
	return date;
}

var _week;
function setWeek(wk){
    _week = wk;
}
function week(){
    // 妊娠週数を返す
    return _week;
}

function calendar(lmpTime, nowTime){
    var records = new Array();
    
	// title
    var array = [" "," "];
	for (var d=0; d < 7; d++){
        array.push("　" + d + "d");
    }
    records.push(array);
	var tm = lmpTime;
    
	// calendar
    for (w=0; w < 43; w++){
        var array = new Array();
		if (w % 4 == 0)
            array.push((w / 4 + 1) + "m");
		else
            array.push("");
        array.push(w + "w");
		for (d=0; d < 7; d++){
			var mm = new Date(tm).getMonth() + 1;
			var dd = new Date(tm).getDate();
			if (dd == 1)
                array.push(mm + "/" + dd);
			else
                array.push(dd + "");
			tm += (24 * 3600 * 1000);
		}
        records.push(array);
	}
    
    // calendar オブジェクトを記憶
    setCalendarObject(records);
    
    // 作成した records をカレンダーとして表示
	var elm = document.getElementById("calendar");
	elm.innerHTML="";
	var tbl = newTABLE(elm, "calendarTable");
    
    for (row=0,rows=records.length; row < rows; row++){
        var tr = newTR(tbl, "", "");
        var record = records[row];
        for (col=0,cols=record.length; col < cols; col++){
            var td = newTD(tr, "cell", record[col]);
        }
        td.style.paddingRight = "10px";
    }
}

////////////////////////////////////////////////////////
///// DRAG and DROP ////////////////////////////////////

function f_dragstart(event){
    // ドラッグ開始時の処理
    var st = document.getElementById("lmp").value;
    var array = st.split("-");
    var lmp = "最終月経 " + array[0] + "年 " + array[1] + "月 " + array[2] + "日";
    
    var array = termDate().split("-");
    var term = "推定分娩予定日 " + array[0] + "年 " + array[1] + "月 " + array[2] + "日";
    
    var array = gestateWeekDay();
    var gw = "( 妊娠 " + array[0] + "週 " + array[1] + "日 )";
    
    // DataTransferオブジェクトに転送するデータをセット
    event.dataTransfer.setData("text", lmp + "\n" + term + " " + gw + "\n");
}

function f_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

///// DRAG and DROP ////////////////////////////////////
////////////////////////////////////////////////////////

function gestateWeekDay(){
    // 妊娠週数・日数の配列を返す
	var lmpTime = lmp().getTime();
	var nowTime = now().getTime();
	var gw = parseInt((nowTime - lmpTime) / (7 * 24 * 3600 * 1000));
	var gd = parseInt((nowTime - lmpTime) % (7 * 24 * 3600 * 1000));
	gd /= parseInt((24 * 3600 * 1000));
    
    var array = new Array();
    array.push(gw);
    array.push(gd);
    return array;
}

function showGW(gw, gd){
    // 妊娠週数・日数ポップアップを生成
    var span = document.getElementById("weekArea");
    span.innerHTML = "";
    
    var array = [""];
    for (num=0; num < 43; num++) array.push(num + "");
    var pu = newPopupMenu(span, "weekPop1", array, gw);
    pu.setAttribute("onchange", "gwChanged()");
    
    var sp = newSPAN(span, "");
    sp.innerHTML = "週";
    
    var pu = newPopupMenu(span, "weekPop2", ["", "0", "1","2", "3", "4", "5", "6"], gd);
    pu.setAttribute("onchange", "gwChanged()");
    
    var sp = newSPAN(span, "");
    sp.innerHTML = "日";
}

function calc(){
    if (!now()) // あり得ないがエラー回避のため
        return null;
    
    var array = gestateWeekDay();
    var gw = array[0];
    var gd = array[1];
    
    // 分娩予定日を計算
	var tm = term(lmp());
	var yy = tm.getYear();
	if (yy < 2000) { yy += 1900; }
	var mm = tm.getMonth() + 1;
	if (mm * 1 < 10) mm = "0" + mm;
	var dd = tm.getDate();
	if (dd * 1 < 10) dd = "0" + dd;
	var yymmdd =  yy + "-" + mm + "-" + dd;
    
    setTermDate(yymmdd); // 予定日を記憶
    
    // 予定日の文字列をドラッグ・アンド・ドロップできるようにする
    var td = document.getElementById("result");
    if (!td) return; // まだ result が生成されていない
    
    // カルテから月経周期を取り出す
    var menstrualCylce = 28;
    var obj = parent().valueForTag("UniversalSection.menstrualCycle");
    var cycleSt = (obj) ? obj.value : "";
    if (cycleSt.length > 0){
        var ary = cycleSt.split("-"); // 月経周期 "28-35" 型式
        menstrualCylce = ary[0] * 1;
    }
    var days = gw * 7 + gd; // 最終月経からの経過日数
    if (days <= menstrualCylce){
        // 最終月経からの経過日数が月経周期を超えてなければ、経過日数・推定排卵日を表示
        var date = lmp();
        var sec = lmp().getTime();
        var d = menstrualCylce - 14; // 月経周期で排卵期タイミングを調整
        date.setTime(sec + 60 * 60 * 24 * d * 1000); // lmp から 14日後の日付
        var ovulationDay = stringWithDate(date, "noTime");
        if (countFromOne() * 1 > 0) days = days + 1;
        td.innerHTML = "lmp:"+lmpString()+" ("+days+"d) 推定排卵日:"+ovulationDay;
    } else {
        // 最終月経からの経過日数が月経周期を超えていれば通常表示
        td.innerHTML = "lmp:"+lmpString()+" ("+gw+"w"+gd+"d) Term:"+yymmdd;
    }
    td.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
    td.setAttribute("ondragstart", "f_dragstart(event)");
    td.setAttribute("ondragover", "f_dragover(event)");
    
    // 妊娠週数ポップアップを更新
    showGW(gw, gd);
    
    // 予定日ポップアップを更新
    var span = document.getElementById("termArea");
    span.innerHTML = "";
    newDatePopUp(span, "term", "", yy, mm, dd, false, termChanged);
    
    // 妊娠暦を表示
	var lmpTime = lmp().getTime();
	var nowTime = now().getTime();
	calendar(lmpTime, nowTime);
    
	
	function lmpString(){
		var lmp = document.getElementById("lmp").value;
        var array = lmp.split("-");
        var yyyy = array[0];
		var mm = array[1] * 1;
		if (mm < 10) mm = "0" + mm;
		var dd = array[2] * 1;
		if (dd < 10) dd = "0" + dd;
		return yyyy.substr(2,2) + mm + dd;
	}
}

function print(){
    // 妊娠歴を印刷
	var lmp = document.getElementById("lmp").value;
    var buff = "";
    var records = calendarObject();
    for (row in records){
        var record = records[row];
        var ln = record.join(",");
        buff += ln + ";";
    }
    buff += "分娩予定日は " + termDate() + " と推定されます。;";
    buff += "ただし、これは大体の「めやす」です。;";
    buff += "前後２週間ほどの巾があるとお考えください。;";
    
    //alert(buff); //##
	var url = "./print.php?value="+encodeSTRING(buff);
	var win = window.open(url, "GC", "scrollbars=yes");
	win.document.title = "PRINT GC"; // window title に表示
	win.focus();
}

function lmpChanged(){
    // 最終月経ポップアップが変更された
    calc(); // 最終月経から本日の妊娠週数・予定日を再計算
    
    // lmp が変更された場合のみ書き戻しボタンを表示
	var lmp = document.getElementById("lmp").value;
    if (! originalLmp() || isSameDate(lmp, originalLmp())){
        showSendButton(false);
    } else {
        showSendButton(true);
    }
}

function sendBack(){
    // カルテへ lmp gw term を書き戻す
    // NOA から起動されたのでなければ何もせずに終了
    if (!parent()){
        alert("親としての NOA がありません");
        return;
    }
    
    // subject 欄の内容を NOA から取得
    var buff = subject();

    // 計算された予定日を NOA の編集フィールドへ書戻す
    var array = buff.split("lmp:");
    var leftSt = array[0];
    
    // "lmp:" から改行までの文字列を予定日変換文字列の対象とするので
    // 最終月経の後ろに文字があっても *** 予定日と置換 *** されてしまう
    var rightSt = array[1];
    rightSt = convertSTRING(rightSt, "<br>", "\n");
    var array2 = rightSt.split("\n");
    array2[0] = document.getElementById("result").innerHTML;
    rightSt = array2.join("\n");
    
    var value = leftSt + rightSt;
    value = convertSTRING(value, "\n", "<br>");
    var elm = editorElement(); // Group CELL のエディターが開いている場合
//    alert("sendBack elm->"+elm); //##
    
    if (elm){ // elm が編集モードの場合
        elm.innerHTML = value;
    } else { // elm が表示モードの場合
        parent().putValueForTag(value, "ProgressSection.subject");
    }
}
function showSendButton(status){
    // status が true なら書き戻しボタンを表示
    if (! originalLmp()) return; // NOA から起動したものではない
    
	var elm = document.getElementById("sendButtonArea");
    if (!elm) return;
    
    elm.innerHTML = "";
    if (status){
        var bt = newDIV(elm, "/whiteButton");
        bt.innerHTML = "カルテへ変更結果を書戻す";
        bt.setAttribute("onclick", "sendBack()");
        bt.style.marginLeft = "70px";
    }
}

function changeLmpTo(lmp){
    // 最終月経ポップアップを修正：これに伴い週数・日数・予定日も修正される
    var elm = document.getElementById("lmpArea");
    elm.innerHTML = "";
    
    var ary = dateTimeArray(lmp); // lib.js
    newDatePopUp(elm, "lmp", "", ary[0], ary[1], ary[2], false, lmpChanged);
}

function dateChanged(){
    // 本日ポップアップが変更された
//    var sp = document.getElementById("printButtonArea");
//    if (sp) sp.innerHTML = "";
    calc(); // 最終月経から本日の妊娠週数・予定日を再計算
}

function gwChanged(){
    // 妊娠週数か日数ポップアップが変更された：最終月経と不整合あれば最終月経を修正
	var lmp = document.getElementById("lmp").value;
    var gw = document.getElementById("weekPop1").value * 1;
    var gd = document.getElementById("weekPop2").value * 1;

    // now(), gw, gd から 最終月経を "yyyy-mmm-dd" 型式で算出
    if (!now()){ // あり得ないがエラー回避のため
        alert("本日が未指定"); return null;
    }
    var nowTime = now().getTime();
    var lmpTime = parseInt(nowTime - ((gw * 7 + gd) * 24 * 3600 * 1000));
    var lmpDate = new Date();
    lmpDate.setTime(lmpTime);
    var lmp = stringWithDate(lmpDate); // lib.js
    
    // 変更された予定日に対し最終月経が不整合なら最終月経を修正
    var correctLmp = lmp.substr(0, 10); // "yyyy-mm-dd" 型式にする
    if (lmp != correctLmp){
        changeLmpTo(correctLmp);
    
        showSendButton(true);
    } else {
        showSendButton(false);
    }
}

function termChanged(){
    // 予定日ポップアップが変更された：最終月経と不整合あれば最終月経を修正
//    var sp = document.getElementById("printButtonArea");
//    if (sp) sp.innerHTML = "";
    
    // lmp, term の関係に不整合あれば lmp, gw, gd を修正
	var lmp = document.getElementById("lmp").value;
    lmp = lmp.substr(0, 10); // "yyyy-mm-dd" 型式にする
    
	var term = document.getElementById("term").value;
    // term を "yyyy-mm-dd" 型式から Date() 型式に変換
    var array = term.split("-");
    var termDate = new Date(array[0], array[1] - 1, array[2]);
    // termDate から lmpDate を算出
    var lmpDate = new Date();
    lmpDate.setTime(termDate.getTime() - (40 * 7 * 24 * 3600 * 1000));
    // lmpDate を "yyyy-mm-dd hh:mm::ss" の文字列にする
    var newLmp = stringWithDate(lmpDate); // lib.js
    
    // 変更された予定日に対し最終月経が不整合なら最終月経を修正
    var correctLmp = newLmp.substr(0, 10); // "yyyy-mm-dd" 型式にする
    
    //_initDebug(true); //##
    //_debug("lmp->"+lmp+" correctLmp->"+correctLmp); //##
    
    if (lmp != correctLmp){
        changeLmpTo(correctLmp);
    
        showSendButton(true);
    } else {
        showSendButton(false);
    }
}

function openPreference(){
    // 初期設定ペーンを開く
    var elm = document.getElementById("preferenceArea");
    if (elm.innerHTML.length){
        elm.innerHTML = "";
        return;
    }
    elm.innerHTML = "";
    var div = newDIV(elm, "");
    div.style.marginTop = "10px";
    div.style.marginLeft = "10px";
    div.style.fontSize = "9pt";
    
    // 月経周期未満の場合の経過日数を１からカウント開始するか否か
    var cb = newCHECKBOX(div, "", "月経周期未満の場合の経過日数を１からカウント", countFromOne());
    cb.setAttribute("onchange", "setCountFromOne(this)"); // localStorage.js
}

function rhHelp(){
	window.open("./rhHelp.html","Help"
				,"width=500,height=700,scrollbars=yes,resizable=yes");
}

function init(){
    _initDebug(false); //##

	var elm = document.getElementById("base");
    elm.style.fontSize = "10pt";
    
    // === HEADER ==================
    var div = newDIV(elm, "/tool-header");
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = "妊娠歴";
    var dv = newDIV(div, "/right-side");
	var im = newIMAGE(dv, "", "./help.png", "?");
	im.setAttribute("onclick", "rhHelp()");
	im.style.height = "17px";
	im.style.position = "relative";
	im.style.top = "2px";
    
    // === 最終月経 =================
    var div = newDIV(elm, "");
    div.style.paddingTop = "10px";
    var sp = newSPAN(div, "");
    sp.innerHTML = "最終月経";
    sp.style.padding = "0 5px";
    var sp = newSPAN(div, "lmpArea");
	var date = new Date();
	date.setTime(date.getTime() - (5 * 7 * 24 * 3600 * 1000));
	var yy = date.getYear();
	var mm = date.getMonth() + 1;
	var dd = date.getDate();
	if (yy < 2000) { yy += 1900; }
    newDatePopUp(sp, "lmp", "", yy, mm, dd, false, lmpChanged);
    
    // === 本日 ====================
    var div = newDIV(elm, "");
    div.style.paddingBottom = "10px";
    var sp = newSPAN(div, "");
    sp.innerHTML = "本日　　";
    sp.style.padding = "0 5px";
    var sp = newSPAN(div, "");
    var dateTime = currentDate();
    var ary = dateTime.split(" ");
    var ary2 = ary[0].split("-");
	var yy = ary2[0];
	var mm = ary2[1];
	var dd = ary2[2];
    newDatePopUp(sp, "today", "", yy, mm, dd, false, dateChanged);
    
    // === 週数 ====================
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "週数　　";
    sp.style.padding = "0 5px";
    var sp = newSPAN(div, "weekArea");
    
    // === 予定日 ====================
    var div = newDIV(elm, "");
    div.style.paddingBottom = "0px";
    var sp = newSPAN(div, "");
    sp.innerHTML = "予定日　";
    sp.style.padding = "0 5px";
    var sp = newSPAN(div, "termArea");
    
    // === 書き戻しボタン ===============
    var div = newDIV(elm, "sendButtonArea");
    
    // === 週数：予定日 ===============
    var div = newDIV(elm, "/clearfix");
    div.style.margin = "10px 0";
    var sp = newSPAN(div, "result", "");
    sp.style.paddingLeft = "65px";

    // === FOOTER ====================
    var div = newDIV(elm, "/tool-footer");
    // LEFT-SIDE ---------------------
    var dv = newDIV(div, "/left-side");
	dv.style.position = "relative";
	dv.style.top = "3px";
	dv.style.width = "60%";
    var sp = newSPAN(dv, "");
    var img = newIMAGE(sp, "", "./hammer.png", "X");
    img.style.height = "13px";
    img.setAttribute("onclick", "openPreference()");
    img.setAttribute("class", "expandIcon");
    var sp = newSPAN(dv, "");
    sp.innerHTML = version();
    sp.style.paddingLeft= "5px";
    // RIGHT-SIDE --------------------
    var dv = newDIV(div, "/right-side");
    var sp = newSPAN(dv, "printButtonArea");
    var bt = newDIV(sp, "/whiteButton");
    bt.innerHTML = "印刷";
    bt.setAttribute("onclick", "print()");
    bt.style.padding = "5px 16px 2px 16px";
    bt.style.position = "relative";
    bt.style.top = "4px";
    
    // === 初期設定エリア =========
    var dv = newDIV(elm, "preferenceArea");

    // === カレンダー表示エリア =========
    var dv = newDIV(elm, "calendar");
    
    // NOA から起動されていれば妊娠歴を自動設定
    if (parent()){
        // NOA から起動されていれば妊娠歴を自動設定
        setCalendar();
    } else {
        // 最終月経のポップアップを設定：週数日数や予定日ポップアップの設定で変更されてしまうため
        var elm = document.getElementById("lmpArea");
        elm.innerHTML = "";
        var dateTime = dateWthDiff(todayAndTime(), -6 * 7 * 60 * 24); // ６週前
        var ary = dateTime.split(" ");
        var ary2 = ary[0].split("-");
        var yy = ary2[0];
        var mm = ary2[1];
        var dd = ary2[2];
        newDatePopUp(elm, "lmp", "", yy, mm, dd, false, lmpChanged);
    }
}

function version(){
    return "Ver.140801";
}
