
function kinds(){
    // 筋腫の配列を返す
    return [1, 5, 10, 50, 100, 500, 1000, 5000, 10000];
}

function beginningId(){
    return "0";
}
function endingId(){
    return "1";
}

var _history;
function setHistory(array){
    _history = array;
}
function history(){
    return _history;
}

var _staffList;
function setStaffList(array){
    // 職員リストをセット
    //alert("setStaffList->"+encodeObject(array)); //##
    var staffs = new Array();
    // チェックのため、リストから空の氏名を取り除く
    for (num in array){
        var name = trim(array[num]);
        if (name.length) staffs.push(name);
    }
    if (staffs.length == 0){
        alert("職員名が登録されていませんので登録が必要です");
        openPreference();
        return;
    }
    
    staffs.splice(0,0,""); // 最初に空アイテムを挿入
    _staffList = staffs;
}
function staffList(){
    return _staffList;
}

var _record;
function setRecord(obj){
    _record = obj;
    
    setPayArray(obj.payment);
    setIncomeArray(obj.income);
}
function record(){
    return _record;
}

var _currentDate;
function setCurrentDate(date){
    _currentDate = date;
}
function currentDate(){
    // 始業点検を行った時刻を返す
    if (!_currentDate) alert("currentDate がセットされていません"); //##
    return _currentDate;
}

/////////////////////////////////////////////////////////
///// Ajax //////////////////////////////////////////////

function checkedDB(answer){
    if (answer && (answer.length > 0)){
        console.log("checkedDB", answer); //##
        
        var msg = "--- MoneyTable が生成されました ---";
        showFadeoutInfo("_message", msg, 1000); // dom.js
    }
    getHistory();
}
function checkDB(){
	// データベースをチェック
    _callServer("CREATE_TABLE_IF_NEEDED", "monyServer.php", null, checkedDB);
}

function gotHistory(answer){
    //alert("gotHistory->"+answer); //##
    
    if (answer && (answer.length > 0)){
        var obj = eval('(' + answer + ')');
        setHistory(obj.history);
        setStaffList( obj.staffs);
        showHistory();
    }
}
function getHistory(){
	// データベースをチェック
    _callServer("GET_HISTORY", "monyServer.php", null, gotHistory);
}

function saved(answer){
    //alert("saved->"+answer); //##
    
    if (answer && (answer.length > 0)){
        showFadeoutInfo("_message", answer, 1000); // dom.js
    }
}
function save(id){
    // id のペーンを保存
    var obj = new Object();
    var array = kinds();
    for (num in array){
        var kind = array[num];
        var cid = kind + "." + id;
        var val = document.getElementById(cid).value;
        if ((val.length > 0) && (val * 1 > 0)){
            // 枚数があるなら obj に金種ごとの枚数を記憶
            obj[kind] = val;
        }
    }
    var args = new Array();
    var staff1 = trim(document.getElementById("user." + beginningId()).value);
    var staff2 = trim(document.getElementById("user." + endingId()).value);
    if (id == beginningId()){
        args['val1'] = encodeObject(obj);
        args['staff1'] = staff1;
        if (staff1.length == 0){
            alert("始業点検の取扱者氏名を入力してください");
            return;
        }
    } else {
        args['val2'] = encodeObject(obj);
        args['staff2'] = staff2;
        if (staff1.length == 0){
            alert("始業点検の取扱者氏名を入力してください");
            return;
        }
        if (staff2.length == 0){
            alert("終業点検の取扱者氏名を入力してください");
            return;
        }
    }
    args['memo'] = document.getElementById("memoF").value;
    args['entryDate'] = currentDate();
    
    args['income'] = encodeObject(incomeArray());
    args['payment'] = encodeObject(payArray());
    
    //alert("save: PUT_MONY"); //##
    
    _callServer("PUT_MONY", "monyServer.php", args, saved);
}

function gotMoney(answer){
    //alert("gotMoney->"+answer); //##
    
    if (answer && (answer.length > 0)){
        var obj = eval("(" + answer + ")");
        //alert("gotMoney ===\n"+encodeObject(obj)); //###
        
        setRecord(obj);
        makePanes(record());
    }
}
function getMoney(entryDate){
    // entryDate の点検レコードをサーバへリクエスト
    // スタッフリストから空行を削除
    var args = new Array();
    args['entryDate'] = entryDate;
    
    _callServer("GET_MONY", "monyServer.php", args, gotMoney);
}

function savedStaffs(answer){
    //alert("savedStaffs->"+answer); //##
    
    if (answer && (answer.length > 0)){
        var array = answer.split(",");
        setStaffList(array);
        closeFloatPanel();
    }
}
function saveStaffs(){
    // 職員リストをサーバへ保存
    // スタッフリストから空行を削除
    var staffs = new Array();
    var buff = document.getElementById("staffF").value;
    var array = buff.split("\n");
    for (num in array){
        var name = trim(array[num]);
        if (name.length) staffs.push(name);
    }
    
    var args = new Object();
    args['staffs'] = staffs.join(",");
    
    _callServer("PUT_STAFFS", "monyServer.php", args, savedStaffs, true);
}

///// Ajax //////////////////////////////////////////////
/////////////////////////////////////////////////////////

function getWindowSize(){
    // DocMaker のウインドー位置とサイズを localStorage から取り出す
    var windowStatus = window.localStorage["moneyCheckSize"];
    if (windowStatus){
        var array = windowStatus.split(",");
        var x = array[0];
        var y = array[1];
        var w = array[2];
        var h = array[3];
        // resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
        // としてもウインドー境界の制限で移動できない場合がある
        window.resizeTo(w, h); // resizeTo を先に実行すること
        window.moveTo(x, y);
    }
}

function selectedHistory(elm){
    // ログのポップアップが選択された
    var dateTime = trim(elm.value);
    
    if (dateTime.length > 0){
        setCurrentDate(dateTime);
        getMoney(dateTime);
    } else {
        firstMessage();
    }
}
function showHistory(){
    // 過去ログを表示
    var array = history();
    array.splice(0,0,"");
    
    var elm = document.getElementById("datePopArea");
    elm.innerHTML = "";
	var pm = newPopupMenu(elm, "", array, "");
    pm.setAttribute("onchange", "selectedHistory(this)");
    pm.style.fontSize = "10pt";
}

function endingCashTotal(){
    // 終業時現金計を返す
    var total = 0;
    var id = "1";
    
    // 元金を計算
    var array = kinds();
    for (num in array){
        var kind = array[num];
        var cid = kind + "." + id;
        var val = document.getElementById(cid).value;
        if ((val.length > 0) && (val * 1 > 0)){
            total += val * kind;
        }
    }
    return total;
}

function calc(id, doSave){
    // 合計を算出

    // Booking のウインドー位置とサイズをサーバへ記憶
    // ### 古いブラウザーではコケるのでとりあえず省略 ########
    //put_windowSize(0, -22, "moneyCheckSize");
    
	var user = document.getElementById("user." + id).value;
    if (doSave && (user.length == 0)){
        alert("取扱者の氏名を入力してください ");
        return;
    }

    if (id == endingId()){
        // 収支差額を算出
        calcPane(beginningId());
        calcPane(endingId());
        showTotalDatail();
        
    } else {
        calcPane(beginningId());
        var firstCost = document.getElementById("total.0").innerHTML * 1;
        var elm = document.getElementById("firstCost");
        if (elm) elm.innerHTML = firstCost;
    }
    if (doSave) save(id);
    
    
    function calcPane(id){
        // id の元金を計算
        var total = 0;
        var array = kinds();
        for (num in array){
            var kind = array[num];
            var cid = kind + "." + id;
            var val = document.getElementById(cid).value;
            if ((val.length > 0) && (val * 1 > 0)){
                total += val * kind;
                var mid = kind + "_" + id;
                document.getElementById(mid).innerHTML = "= "+ val * kind + " 円";
            }
        }
        var elm = document.getElementById("total."+id);
        if (elm) elm.innerHTML = total;
        
        // 収支計算エリアが存在すれば収支計算を実行
        var elm = document.getElementById("totalDetailArea");
        if (elm) showTotalDatail();
    }
    
    function showTotalDatail(){
        // 総計明細を表示
        var elm = document.getElementById("totalDetailArea");
        elm.innerHTML = "";
        var tbl2 = newTABLE(elm, "baseTable");
        
        // 臨時収入明細 ////////////////////////
        var tr = newTR(tbl2, "", "");
        var td = newTD(tr, "", "");
        td.style.padding = "0px 10px";
        td.style.textAlign = "right";
        var bt = newBUTTON(td, "", "収入欄を追加");
        bt.setAttribute("onclick", "addNewIncome()");
        // 収入適用・金額エリア
        var td = newTD(tr, "incomeArea", "");
        td.setAttribute("colspan","2");
        var income = showIncome() * 1;
        
        // セパレータ
        var tr = newTR(tbl2, "", "");
        var td = newTD(tr, "", "");
        td.setAttribute("colspan","2");
        var hr = newHR(td);
        
       // 支出明細 /////////////////////////////
        var tr = newTR(tbl2, "", "");
        var td = newTD(tr, "", "");
        td.style.padding = "0px 10px";
        td.style.textAlign = "right";
        var bt = newBUTTON(td, "", "支出欄を追加");
        bt.setAttribute("onclick", "addNewPayment()");
        // 支出適用・金額エリア
        var td = newTD(tr, "payArea", "");
        td.setAttribute("colspan","2");
        var payment = showPayments() * 1;

        // セパレータ
        var tr = newTR(tbl2, "", "");
        var td = newTD(tr, "", "");
        td.setAttribute("colspan","2");
        var hr = newHR(td);
        
        // 収支計算ボタン ///////////////////////
        var tr = newTR(tbl2, "", "");
        var td = newTD(tr, "label", "");
        td.style.padding = "0px 5px";
        var bt = newBUTTON(td, "", "収支計算");
        bt.setAttribute("onclick", "calc('"+id+"',true)");
        var td = newTD(tr, "", "");
        var tbl3 = newTABLE(td, "baseTable");
        
        var firstCost = document.getElementById("total.0").innerHTML * 1;
        var lastCost = endingCashTotal() * 1;
        
        // 始業点検
        var tr = newTR(tbl3, "", "");
        var td = newTD(tr, "sumLabel", "始業時現金");
        var td = newTD(tr, "cost", "");
        var sp = newSPAN(td, "firstCost");
        sp.innerHTML = firstCost;
        var sp = newSPAN(td, "");
        sp.innerHTML = " 円";
        var td = newTD(tr, "mark", "+");
        
        // 外来収入
        var tr = newTR(tbl3, "", "");
        var td = newTD(tr, "sumLabel", "外来収入");
        var medicalIncome = lastCost + payment - firstCost - income;
        var td = newTD(tr, "cost", medicalIncome + " 円");
        var td = newTD(tr, "mark", "+");
        
        // 臨時収入
        var tr = newTR(tbl3, "", "");
        var td = newTD(tr, "sumLabel", "臨時収入");
        var td = newTD(tr, "cost", income + " 円");
        var td = newTD(tr, "mark", "+");
       
        // 支出
        var tr = newTR(tbl3, "", "");
        var td = newTD(tr, "sumLabel", "支出");
        var td = newTD(tr, "cost", "");
        var sp = newSPAN(td, "payment");
        sp.innerHTML = payment;
        var sp = newSPAN(td, "");
        sp.innerHTML = " 円";
        var td = newTD(tr, "mark", "-");
/*
        // セパレータ
        var tr = newTR(tbl3, "", "");
        var td = newTD(tr, "", "");
        td.setAttribute("colspan","3");
        var hr = newHR(td);

        // 収支合計
        var total = firstCost + medicalIncome + income - payment;
        var tr = newTR(tbl3, "", "");
        var td = newTD(tr, "sumLabel", "収支合計");
        var td = newTD(tr, "cost", "");
        var sp = newSPAN(td, "payment");
        sp.innerHTML = total;
        var sp = newSPAN(td, "");
        sp.innerHTML = " 円";
*/        
        // 終業
        var tr = newTR(tbl3, "", "");
        var td = newTD(tr, "sumLabel", "終業時現金");
        var td = newTD(tr, "cost", "");
        var sp = newSPAN(td, "lastCost");
        sp.innerHTML = lastCost;
        var sp = newSPAN(td, "");
        sp.innerHTML = " 円";
        var td = newTD(tr, "mark", "");
 /*       
        // セパレータ
        var tr = newTR(tbl3, "", "");
        var td = newTD(tr, "", "");
        td.setAttribute("colspan","3");
        var hr = newHR(td);
        
        // 現金過不足
        var balance = lastCost - total;
        var tr = newTR(tbl3, "", "");
        var td = newTD(tr, "sumLabel", "過不足");
        var td = newTD(tr, "cost", "");
        var sp = newSPAN(td, "");
        sp.innerHTML = balance;
        var sp = newSPAN(td, "");
        sp.innerHTML = " 円";
  */
    }
}

function userSelected(elm, id){
    // 選択されたユーザ名をフィールドへ転記
    var name = elm.value;
    document.getElementById("user." + id).value = name;
}

//////////////////////////////////////////////
// 収入 ///////////////////////////////////////

var _incomeObj;
function setIncomeArray(json){
    // load された JSON から payArray を抽出
    _incomeObj = new Array();
    if (json.length == 0) return;

    var array = decodeObject(json);
    
    // 直接 _incomeObj = eval('(' + json + ')') 形式だと、どういう訳か
    // 後で addIncomeArray(title, cost) がうまくいかないので _incomeObj へ追加する
    for (num in array){
        var obj = array[num];
        addIncomeArray(obj.title, obj.cost);
    }
}

function addIncomeArray(title, cost){
    if (!_incomeObj) _incomeObj = new Array();
    var obj = new Object();
    obj.title = title;
    obj.cost = cost;
    _incomeObj.push(obj);
}

function incomeArray(){
    // 収入オブジェクトを返す
    return _incomeObj;
}

function addNewIncome(){
    // 新しい収入入力欄を追加
    addIncomeArray("", "");
    showIncome();
}

function incomeTitleChanged(num){
    // num 番目のタイトルが更新された
    var obj = incomeArray()[num];
    obj.title = document.getElementById("inTitle." + num).value;
}

function incomeChanged(num){
    // num 番目の金額が更新された
    var obj = incomeArray()[num];
    obj.cost = document.getElementById("inCost." + num).value;
    
    // 収入合計を再計算し支出ペーンを再表示
    var income = showIncome();
    document.getElementById("incomeTotal").innerHTML = income;
}

function removeIncome(num){
    // 収入欄の num 行目を削除
	var array = incomeArray();
    delete array[num];
    showIncome();
}

function showIncome(){
    // 収入欄を表示
    var income = 0;
	var elm = document.getElementById("incomeArea");
    elm.innerHTML = "";
	var tbl = newTABLE(elm, "baseTable");
    
	var array = incomeArray(); //---
    for (num in array){
        var obj = array[num];
        if (!obj) continue; 
        
        var tr = newTR(tbl, "", "");
        tr.style.fontSize = "10pt";
        var td = newTD(tr, "", "");
        var fd = newFIELD(td, "inTitle." + num, "摘要", 25, obj.title);
        fd.setAttribute("onchange", "incomeTitleChanged('" + num + "')");
        fd.focus();
        var fd = newFIELD(td, "inCost." + num, "", 6, obj.cost);
        fd.setAttribute("onchange", "incomeChanged('" + num + "')");
        var tx = newTEXT(td, "円 ");
        var img = newIMAGE(td, "", "./remove-field.png", "remove");
        img.style.height = "12px";
        img.setAttribute("onclick", "removeIncome('" + num + "')");

        income += obj.cost * 1;
    }

    // 収入合計
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "incomeTotal", "臨時収入合計 " + income + " 円");
    td.style.fontSize = "14pt";
    
    return income;
}

// 収入 ///////////////////////////////////////
//////////////////////////////////////////////

//////////////////////////////////////////////
// 支出 ///////////////////////////////////////

var _payObj;
function setPayArray(json){
    // load された JSON から payArray を抽出
    _payObj = new Array();
    if (json.length == 0) return;

    var array = decodeObject(json);
    
    // 直接 _payObj = eval('(' + json + ')') 形式だと、どういう訳か
    // 後で addPayArray(title, cost) がうまくいかないので _payObj へ追加する
    for (num in array){
        var obj = array[num];
        addPayArray(obj.title, obj.cost);
    }
}
function addPayArray(title, cost){
    if (!_payObj) _payObj = new Array();
    var obj = new Object();
    obj.title = title;
    obj.cost = cost;
    _payObj.push(obj);
}
function payArray(){
    // 支出オブジェクトを返す
    return _payObj;
}

function addNewPayment(){
    // 新しい支出入力欄を追加
    addPayArray("", "");
    showPayments();
}

function titleChanged(num){
    // num 番目のタイトルが更新された
    var obj = payArray()[num];
    obj.title = document.getElementById("title." + num).value;
}

function costChanged(num){
    // num 番目の金額が更新された
    var obj = payArray()[num];
    obj.cost = document.getElementById("cost." + num).value;
    
    // 支出合計を再計算し支出ペーンを再表示
    var payment = showPayments();
    document.getElementById("payment").innerHTML = payment;
}

function removePay(num){
    // 支出欄の num 行目を削除
	var array = payArray();
    delete array[num];
    showPayments();
}

function showPayments(){
    // 支出欄を表示
    var payment = 0;
	var elm = document.getElementById("payArea");
    elm.innerHTML = "";
	var tbl = newTABLE(elm, "baseTable");
    
//    _initDebug(true); //##
    
	var array = payArray();
    for (num in array){
        var obj = array[num];
        if (!obj) continue; 
        
//        _debug(num+"->"+obj.title); //##
        
        var tr = newTR(tbl, "", "");
        tr.style.fontSize = "10pt";
        var td = newTD(tr, "", "");
        var fd = newFIELD(td, "title." + num, "摘要", 25, obj.title);
        fd.setAttribute("onchange", "titleChanged('" + num + "')");
        fd.focus();
        var fd = newFIELD(td, "cost." + num, "", 6, obj.cost);
        fd.setAttribute("onchange", "costChanged('" + num + "')");
        var tx = newTEXT(td, "円 ");
        var img = newIMAGE(td, "", "./remove-field.png", "remove");
        img.style.height = "12px";
        img.setAttribute("onclick", "removePay('" + num + "')");
        
        payment += obj.cost * 1;
    }
    
    // 支出合計
    var tr = newTR(tbl, "", "");
    var td = newTD(tr, "payTotal", "支出合計 " + payment + " 円");
    td.style.fontSize = "14pt";
    
    return payment;
}

// 支出 ///////////////////////////////////////
//////////////////////////////////////////////

function makePane(id, record){
    // 始業点検または就業点検ペーンを生成
    var isBegin = (id == beginningId()) ? true : false;
	var elm = document.getElementById(id);
    elm.innerHTML = "";
    
	var tbl = newTABLE(elm, "baseTable");
	
	// header
    var date = (currentDate()) ? currentDate() : "";
    var title = (isBegin) ? date + "　始業点検" : "終業点検";
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "paneHeader", title);
	
	// contents
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	var tbl2 = newTABLE(td, "baseTable");
   
    // 取扱者
    var tr = newTR(tbl2, "", "");
    var td = newTD(tr, "label", "取扱者");
    var td = newTD(tr, "", "");
    var staffs = staffList();
	var pm = newPopupMenu(td, "", staffs, "");
    pm.setAttribute("onchange", "userSelected(this, '" + id + "')");
    var staff1 = (record) ? record.staff1 : "";
    var staff2 = (record) ? record.staff2 : "";
    var staff = (isBegin) ? staff1 : staff2;
    var fd = newFIELD(td, "user." + id, "", 20, staff);
    
    //alert(encodeObject(record)); //##
    
    // 金種ごとの枚数
    var st = "";
    var kindObj = null;
    if (record){
        st = (isBegin) ? record.value1 : record.value2;
        kindObj = decodeObject(st);
    }
    
    var array = kinds();
    for (num in array){
        var kind = array[num];
        makeLine(tbl2, kindObj, kind, id);
    }

    // 収支差額
    if (id != endingId()){ // 始業点検        
        // 合計
        var tr = newTR(tbl2, "", "");
        var td = newTD(tr, "label", "");
        var bt = newBUTTON(td, "", "現金合計");
        var action = (isBegin) ? "calc('"+id+"',true)" : "calc('"+id+"',true)";
        bt.setAttribute("onclick", action);
        var td = newTD(tr, "", "");
        td.style.padding = "0px 10px";
        var sp = newSPAN(td, "total." + id); 
        var tx = newTEXT(td, "円");
        
        // セパレータ
        var tr = newTR(tbl2, "", "");
        var td = newTD(tr, "", "");
        td.setAttribute("colspan","2");
        var hr = newHR(td);
        
        // メモ
        var tr = newTR(tbl2, "", "");
        var td = newTD(tr, "label", "メモ");
        var td = newTD(tr, "", "");
        var memo = (record) ? record.memo : "";
        var fd = newTEXTAREA(td, "memoF", 30, 5, memo);
    } else { // 終業点検
        // 合計
        var tr = newTR(tbl2, "", "");
        var td = newTD(tr, "label", "現金合計");
        var td = newTD(tr, "", "");
        td.style.padding = "0px 10px";
        var sp = newSPAN(td, "total." + id); 
        var tx = newTEXT(td, "円");
        
        // セパレータ
        var tr = newTR(tbl2, "", "");
        var td = newTD(tr, "", "");
        td.setAttribute("colspan","2");
        var hr = newHR(td);
        
        // 収入欄・支出欄の表示は calc() で行う

        // 総計明細表示エリア
        var tr = newTR(tbl2, "", "");
        var td = newTD(tr, "totalDetailArea", "");
        td.setAttribute("colspan","2");
    }

    // もしレコードがあるなら合計を計算
    if (record) calc(id);

    function makeLine(tbl, obj, kind, id){
        var val = "";
        if (obj && obj[kind]) val = obj[kind];

        var tr = newTR(tbl, "", "");
        var td = newTD(tr, "label", kind + "円");
        var td = newTD(tr, "", "");
        var fd = newFIELD(td, kind+"."+id, "", 2, val);
        fd.style.fontSize = "14pt";
        var tx = newTEXT(td, "枚 ");
        var sp = newSPAN(td, kind+"_"+id);
    }
}

function makePanes(record){
    // 新規始業点検ページを生成
	var elm = document.getElementById("panesArea");
    elm.innerHTML = "";

    var tbl = newTABLE(elm, "frameTable");
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "pane", "");
    var dv = newDIV(td, beginningId());
	var td = newTD(tr, "pane", "");
    var dv = newDIV(td, endingId());
    
    if (!record) setCurrentDate(todayAndTime());
    
    makePane(beginningId(), record);
    makePane(endingId(), record);
}

function openPreference(){
    // 初期設定パネルを開く
	var elm = document.getElementById("_floatPanel");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "");
	tbl.style.fontSize = "9pt";
	tbl.style.textAlign = "right";
    
    // スタッフリストから空行を削除
    var staffs = new Array();
    var array = staffList();
    for (num in array){
        var name = trim(array[num]);
        if (name.length) staffs.push(name);
    }
	
	// staff 編集エリア
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
    var fd = newTEXTAREA(td, "staffF", 20, 10, staffs.join("\n"));
 	var td = newTD(tr, "", "");
    td.style.textAlign = "left";
    td.style.verticalAlign = "top";
    td.style.color = "#a63"; // brown
    td.innerHTML = "職員リストを編集してください<br>職員名は一行ずつ登録します";
   
    // 全ページ印刷ボタン
    var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");
	var td = newTD(tr, "", "");
	var bt = newBUTTON(td, "", "登録");
    bt.setAttribute("onclick", "saveStaffs()");
    
	openFloatPanel(tbl, 50, 0, "職員リスト編集パネル");
}

function help(){
	var win = window.open("./help.html","Help"
						  ,"width=450,height=700,scrollbars=yes,resizable=yes");
	win.focus();
}

function firstMessage(){
    // 初期のメッセージ画面を生成
	var elm = document.getElementById("panesArea");
    elm.innerHTML = "";
    var div = newDIV(elm, "");
    div.style.padding = "10px 20px";
    
    var dv = newDIV(div, "");
    var st = "　午前・午後・夜間などの診療時間帯ごとに始業・終業点検を行う場合は、診療時間帯が異なるごとに、新規の始業点検から開始します";
    dv.innerHTML = st;
    dv.style.color = "#a63";
    
    var dv = newDIV(div, "");
    var st = "　すでに今回の始業点検の記録がある場合は、上のポップアップメニューから始業点検を行った年月日を選択してください。始業点検記録がない場合は新規に ";
    dv.innerHTML = st;
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "始業点検";
    bt.setAttribute("onclick", "makePanes()");
}

function initMoneyCheck(){
	var elm = document.getElementById("base");
    
    // HEADER =====================================
    var div = newDIV(elm, "/tool-header");
    var dv = newDIV(div, "/left-side");
    dv.style.width = "400px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = "点検履歴";
    var sp = newSPAN(dv, "datePopArea");
    var dv = newDIV(div, "/right-side");
    // HELP
    var sp = newSPAN(dv, "");
    var img = newIMAGE(sp, "", "./help.png", "map");
    img.style.height = "17px";
    img.setAttribute("onclick", "help()");
    
    // CONTENTS ===================================
    var div = newDIV(elm, "panesArea");
    firstMessage();
    
    // FOOTER =====================================
    var div = newDIV(elm, "/tool-footer");
    var dv = newDIV(div, "/left-side");
    dv.style.width = "400px";
    var sp = newSPAN(dv, "");
    sp.innerHTML = version();
    var dv = newDIV(div, "/right-side");
    
    // preference icon
    var sp = newSPAN(dv, "");
    sp.style.padding = "relative";
    sp.style.bottom = "8px";
    var img = newIMAGE(sp, "", "./hammer.png", "map");
    img.style.height = "15px";
    img.setAttribute("onclick", "openPreference()");
    
    checkDB();
    
    // ##### 古いブラウザーではコケる #####
    // getWindowSize();
}

function version(){
    return "Ver.150217";
}