

////////////////////////////////////////////////////////////
///// USE LOGIC ////////////////////////////////////////////

function gotHospitalId(answer){
	// neron.js からの返答を実行
    answer = trim(answer);
    
	if (answer.length > 0){
		answer = decodeSTRING(answer);
        //console.log("gotHospitalId->("+answer+")"); //##
        
        document.getElementById("alert").innerHTML = "";
		if (answer.indexOf("ERROR:") >= 0){
			document.getElementById("alert").innerHTML = answer;
			document.getElementById("userName").focus();
		} else {
            // obj: gotHospitalId->userCode(all)sectionCode(23)groupCode(doctor)loginName(ohashi)kanjiName(大橋 克洋)identifier(c44f9b64052f12c4e9229fd899c7113b)hospitalId(1304000000077)memo()entryDate(2010-04-29 15:49:06)updateTime(2013-06-23 19:04:20)owner(ohashi)rowid(38)hospitalTable(大橋医院(1304000000077)SEA SIDE CLINIC(03234200))
			var obj = JSON.parse(answer);
            
			// hospitalName と hospitalId のテーブルを記憶
            // NOA へ受け渡す際 neuron.js 経由では記憶されていないので localStorage へ
			setHospitalTable(obj); // localStorage.js
            
			var array = hospitalIdArray();
			selectHospital(array);
		}
	} else {
        // password がサーバに設定されていないので新たに設定させる
		document.getElementById("passwd").value == ""; // うまく機能しない
		//alert("passwd を設定してください");
		setPasswd();
	}
}
function getHospitalId(){
	// ログイン処理を実行
	var name = document.getElementById("userName").value;
	var pwd = document.getElementById("passwd").value;
    
    //console.log("getHospitalId", name, pwd); //##
    
    var args = new Object();
    args["loginName"] = name;
    args["passwd"] = pwd;
    NRCall("LOGIN", args, gotHospitalId);
}

///// USE LOGIC ////////////////////////////////////////////
////////////////////////////////////////////////////////////

function hospitalIdArray(){
    var array = new Array();
    var hospTbl = hospitalTable(); // localStorage.js
    //_debug("hospTbl->"+encodeObject(hospTbl)); //##
    
    var obj = hospTbl.hospitalTable;
    for (hospName in obj){
        array.push(obj[hospName]);
    }
	return array;
}
function hospitalNameForId(id){
    var hospTbl = hospitalTable(); // neuron.js
    var obj = hospTbl.hospitalTable;
	for (name in obj){
		if (id == obj[name])
			return name;
	}
	return "??";
}


function logined(answer){
	// neron.js からの返答を実行
    console.log("logined", answer); //##
    
	if (answer.length){
		answer = decodeSTRING(answer);
		if (answer.indexOf("ERROR:") >= 0){
			document.getElementById("alert").innerHTML = answer;
			document.getElementById("userName").focus();
		} else {
            // カルテ画面を開く
            window.location.replace("top.php");
        }
	} else {
		document.getElementById("passwd").value == ""; // うまく機能しない
		alert("passwd を設定してください");
		setPasswd();
	}
}
function login(){
	// ログイン処理を実行
	var name = document.getElementById("userName").value;
	var pwd = document.getElementById("passwd").value;
    
    // ここで施設名が決まるので hospitalObject() に記憶
    var obj = hospitalTable();
    obj.hospitalId = _hospitalId;
    obj.hospitalName = _hospitalName;
    setHospitalTable(obj);

    var args = new Object();
    args["loginName"] = name;
    args["passwd"] = pwd;
    NRCall("LOGIN", args, logined);
}

var _pwd;
function reportPassword(answer){
	// パスワードが設定された
	if (answer.length && (answer.indexOf("ERROR") >= 0))
		alert("ERROR: パスワードの設定ができませんでした"); // ERROR
}
function setPasswd(){
	// パスワードを設定
	var pwd = prompt("パスワードを設定してください");
	if (pwd.length){
		_pwd = pwd;
		pwd = prompt("確認のためパスワードをもう一度入力してください");
		if (_pwd != pwd)
			alert("パスワードが違っています");
		else {
            var args = new Object();
            args["loginName"] = document.getElementById("userName").value;
            args["passwd"] = pwd;
            NRCall("PUT_PASSWD", args, reportPassword);
		}
	}
}

function clickedHospital(elm){
	// 施設名ポップアップが選択された
	showHospitalName(elm.value);
}

var _hospitalId;
var _hospitalName;
function showHospitalName(label){
	// 施設名を表示し login ボタンを表示
	var obj = hospitalTable().hospitalTable;
    _debug("== showHospitalName->"+label+"->"+encodeObject(obj)) //##
    
	var hid = "??";
	for (name in obj){
		if (name == label){
			hid = obj[name];
            _hospitalId = hid; // hospitalId を記憶
        }
	}
    _debug("hospitalId->"+hid) //##
    
    _hospitalName = label;
    _debug("_hospitalName->"+elm) //##

	var elm = document.getElementById("hospitalNameArea");
	elm.innerHTML = "";
    _debug("elm->"+elm) //##
    
    var dv = newDIV(elm, "/clearfix");
    var labelDiv = newDIV(dv, "left-side");
    labelDiv.setAttribute("class", "labelDiv");
    labelDiv.innerHTML = "施設 ID";
    var valDiv = newDIV(dv, "right-side");
    var sp = newSPAN(valDiv, "");
    sp.innerHTML = hid;
    sp.style.paddingRight = "10px";

	var bt = newBUTTON(valDiv, "", "NOA を開く");
	bt.setAttribute("onclick", "login()");
    bt.style.position = "relative";
    bt.style.bottom = "3px";
	bt.focus(); // ログイン・ボタンに fucus
	
    var div = newDIV(elm, "/clearfix");
    var dv = newDIV(div, "/labelDiv");
    dv.innerHTML = "　";
    var dv = newDIV(div, "right-side");
    dv.style.fontSize = "10pt";
    dv.style.marginTop = "10px";
	var a = newA(dv, "passwd 変更", "#", "");
	a.setAttribute("onclick", "setPasswd()");
}

function selectHospital(array){
	// ユーザの所属する施設名を選択
    //console.log("selectHospital->"+ encodeObject(array)); //##
	// 所属施設が複数ある場合はポップアップメニューで選択
	var dv = document.getElementById("hospitalPopupArea");
	dv.innerHTML = "";
    
	var obj = hospitalTable().hospitalTable;
    console.log("obj->"+ encodeObject(obj)); //##
    
	if (array.length == 1){
		for (name in obj){
			var hid = obj[name];
			if (hid == array[0]){
                _hospitalId = hid; // hospitalId を記憶
                dv.innerHTML = name;
				showHospitalName(name);
			}
		}
	} else {
		// popup を表示
		var names = allKeys(obj);
		var pu = newPopupMenu(dv, "hospitalNamePop", names, "");
		pu.setAttribute("onchange", "clickedHospital(this)");
        
        showHospitalName(names[0]);
	}
}

function showToolMenu(){
    // ツール・メニューを生成
    var elm = elmFor("toolMenuArea");

    var bt = newDIV(elm, "/listMember");
    bt.innerHTML = "年齢計算";
    bt.setAttribute("onclick", "openLoginTool()");
    bt.setAttribute("onclick", "window.open('../AGE')");
    
    var bt = newDIV(elm, "/listMember");
    bt.innerHTML = "妊娠歴";
    bt.setAttribute("onclick", "openLoginTool()");
    bt.setAttribute("onclick", "window.open('../ReproductiveHistory')");

    var bt = newDIV(elm, "/listMember");
    bt.innerHTML = "周産期管理";
    bt.setAttribute("onclick", "openLoginTool()");
    bt.setAttribute("onclick", "window.open('../PerinatalManager')");
    
    var bt = newDIV(elm, "/listMember");
    bt.innerHTML = "診療予約";
    bt.setAttribute("onclick", "openLoginTool()");
    bt.setAttribute("onclick", "window.open('../Booking')");
    
    var bt = newDIV(elm, "/listMember");
    bt.innerHTML = "診療統計";
    bt.setAttribute("onclick", "openLoginTool()");
    bt.setAttribute("onclick", "window.open('../Statistics')");
    
    var bt = newDIV(elm, "/listMember");
    bt.innerHTML = "InfoSack";
    bt.setAttribute("onclick", "window.open('../InfoSack')");
}

function initLogin(){
	// login パネルを生成

    // BACKGROUND
	var elm = document.getElementById("base");
    var div = newDIV(elm, "loginBase");
    
    // LOGO
    var dv = newDIV(div, "/loginDIV");
    dv.style.width = "200px";
    var img = newIMAGE(dv, "", "abdomen.png", "abdomen");
    
    // MESSAGE
    var dv = newDIV(div, "loginMessageArea");
    var sp = newSPAN(dv, "");
    sp.innerHTML = "Welcome to the ";
    var sp = newSPAN(dv, "", "");
    sp.innerHTML = "NOA";
    sp.style.fontWeight = "bold";
    sp.style.fontFamily = "arial, Helvetica";
    var sp = newSPAN(dv, "");
    sp.innerHTML = " world.";
    
    var pdiv = newDIV(div, "/loginDIV");

    // USER NAME
    var dv = newDIV(pdiv, "/clearfix");
    var labelDiv = newDIV(dv, "left-side");
    labelDiv.setAttribute("class", "labelDiv");
    labelDiv.innerHTML = "userName";
    var fieldDiv = newDIV(dv, "right-side");
    var fd = newFIELD(fieldDiv, "userName", "", 25, "");
    fd.style.marginRight = "10px";
    fd.focus();

    // PASSWORD
    var dv = newDIV(pdiv, "/clearfix");
    dv.style.clear = "both";
    var labelDiv = newDIV(dv, "left-side");
    labelDiv.setAttribute("class", "labelDiv");
    labelDiv.innerHTML = "password";
    var fieldDiv = newDIV(dv, "right-side");
    var fd = newFIELD(fieldDiv, "passwd", "", 25, "");
    fd.setAttribute("TYPE", "password");
    fd.setAttribute("onchange", "getHospitalId()");
    var bt = newBUTTON(fieldDiv, "", "login");
    bt.setAttribute("onclick", "getHospitalId()");

    // HOSPITAL POPUP AREA
    var pdiv = newDIV(div, "/loginDIV");
    var dv = newDIV(pdiv, "/clearfix");
    dv.style.clear = "both";
    var labelDiv = newDIV(dv, "left-side");
    labelDiv.setAttribute("class", "labelDiv");
    labelDiv.innerHTML = "施設名";
    var fieldDiv = newDIV(dv, "hospitalPopupArea");

    // HOSPITAL NAME AREA
    var dv = newDIV(div, "hospitalNameArea/loginDIV");
    dv.style.clear = "both";
    
	// NAVIGATOR INFORMATIONS
	var dv = newDIV(elm, "/loginDIV");
    dv.style.width = "500px";
    dv.style.paddingTop = "10px";
    dv.style.fontSize = "9pt";
    dv.style.color = "#888";
	dv.innerHTML = window.navigator.userAgent;	// Web Browser 種類とバージョン
    
    // ALERT AREA
	var dv = newDIV(elm, "alert");
    dv.style.textAlign = "center";
    dv.innerHTML = "";
    
    // TOOL MENU AREA
    var dv = newDIV(elm, "toolMenuArea/loginDIV");
    dv.innerHTML = "";
    //dv.style.border = "thin solid #00f";
    dv.style.width = "500px";
    dv.style.paddingTop = "10px";
    dv.style.fontSize = "9pt";
    showToolMenu();
}


