<?php
    
    /////////////////////////////
    // print FOLDER with FPDF  //
    /////////////////////////////
    
    require_once '../TCPDF/tcpdf.php';
    require_once 'printLib.php';
    
    $count = $_GET['count']; $count = htmlspecialchars($count); // 印刷枚数
    $slip = $_GET['slip']; $slip = htmlspecialchars($slip); // 伝票内容
    $slip = decodeSTRING($slip);
    $array = explode("<br>", $slip); // <br> を改行に変換
    $slip = implode("\n", $array);
    
    // ページ・サイズ
    $pdf=new TCPDF('P', 'mm', array(180, 256)); // B5
    
    // 印刷文字のサイズ
    $pdf->SetFont('kozminproregular', '', 8);
    
    // default でヘッダー罫線がでることを防止: AddPage() より前に実行
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
    
    $pdf->Open();
    $pdf->AddPage();
    
    $space = 3;
    $w = 80;
    $h = 5; 			// 行間隔
    $x = 2;             // 画面左端から左カラムまでのマージン
    $y = $space;        // 画面上端からのマージン
    $pdf->setLineWidth(0.1);
    $pdf->SetXY($x, $y);

    for ($num=0; $num < $count; $num++){
        // 内容印刷
        $pdf->SetXY($x, $y);
        $pdf->MultiCell($w, $h, $slip, 0, 'L');
        
        // 罫線
        $y = $pdf->GetY() + $space;
        $pdf->Line($x, $y, $x + $w, $y);
        $y += $space;
        $pdf->SetXY($x, $y);
    }

    $pdf->Output();
    
?>