#ifndef __NASKFUNC_H__
#define __NASKFUNC_H__

namespace naskfunc {
extern "C" {

	// naskfunc.nas
	void io_hlt();
	void io_cli();
	void io_sti();
	void io_stihlt();
	unsigned int io_in8(unsigned int port);
	unsigned int io_in16(unsigned int port);
	unsigned int io_in32(unsigned int port);
	void io_out8(unsigned int port, unsigned int data);
	void io_out16(unsigned int port, unsigned int data);
	void io_out32(unsigned int port, unsigned int data);
	unsigned int io_load_eflags();
	void io_store_eflags(unsigned int eflags);
	unsigned int load_cr0();
	void store_cr0(unsigned int cr0);
	void load_gdtr(unsigned int limit, unsigned int base);
	void load_idtr(unsigned int limit, unsigned int base);
	void load_tr(unsigned int tr);
	void farjmp(unsigned int eip, unsigned int cs);
	void farcall(unsigned int eip, unsigned int cs);
	void asm_nos_api();
	void start_app(int eip, int cs, int esp, int ds, int *tss_esp0);
	void asm_end_app();
	void asm_inthandler0c();
	void asm_inthandler0d();
	void asm_inthandler20();
	void asm_inthandler21();
	void asm_inthandler23();
	void asm_inthandler24();
	void asm_inthandler27();
	void asm_inthandler2c();

	// FPU֌W
	void clts(void);
	void fnsave(int *addr);
	void frstor(int *addr);
	void asm_inthandler07(void);

}
}


#endif
