/*
 * Decompiled with CFR 0.152.
 */
package twitter.action;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import twitter.action.TweetGetter;
import twitter.manage.TweetManager;
import twitter4j.Status;
import twitter4j.TwitterException;

public class TweetUserTimelineGetter
implements TweetGetter {
    private TweetManager tweetManager;
    private long userID;
    private long sinceID;

    public TweetUserTimelineGetter(TweetManager tweetManager, long userID2) {
        this.tweetManager = tweetManager;
        this.userID = userID2;
    }

    @Override
    public List<Status> getTweetData(int num) {
        int lastnum;
        List<Status> status = null;
        try {
            status = this.tweetManager.getUserTimeline(num, this.userID);
        }
        catch (TwitterException ex) {
            Logger.getLogger(TweetUserTimelineGetter.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (status != null && (lastnum = status.size()) > 0) {
            this.sinceID = status.get(lastnum - 1).getId();
        }
        return status;
    }

    @Override
    public List<Status> getNewTweetData() {
        int lastnum;
        List<Status> status = null;
        try {
            status = this.tweetManager.getNewUserTimeline(this.userID, this.sinceID);
        }
        catch (TwitterException ex) {
            Logger.getLogger(TweetUserTimelineGetter.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (status != null && (lastnum = status.size()) > 0) {
            this.sinceID = status.get(lastnum - 1).getId();
        }
        return status;
    }
}

