/*
 * Decompiled with CFR 0.152.
 */
package twitter.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ImageIcon;

public class TwitterImageCache {
    private static final String CACHE_DIRECTORY = "cache";
    private Set<String> existImageList = new TreeSet<String>();
    private static TwitterImageCache cache = new TwitterImageCache();

    private TwitterImageCache() {
        File logDir = new File("./cache");
        if (!logDir.exists() && !logDir.mkdir()) {
            System.err.println("cache\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        this.loadExistImageList();
    }

    public void loadExistImageList() {
        File[] fileList;
        String path = "./cache";
        File directory = new File(path);
        File[] fileArray = fileList = directory.listFiles();
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String filename = f.getName();
            this.existImageList.add(filename);
            ++n2;
        }
    }

    public static TwitterImageCache getInstance() {
        return cache;
    }

    public ImageIcon getProfileImage(String imageURL) {
        String cacheFilename = this.getCacheFilenameFromURL(imageURL);
        if (cacheFilename == null) {
            return null;
        }
        ImageIcon icon = null;
        String path = "./cache/" + cacheFilename;
        if (!this.existImageList.contains(cacheFilename)) {
            try {
                int len;
                URL url = new URL(imageURL);
                URLConnection connection = url.openConnection();
                InputStream inputStream = connection.getInputStream();
                File file = new File(path);
                FileOutputStream outputStream = new FileOutputStream(file, false);
                byte[] buf = new byte[512];
                while ((len = inputStream.read(buf)) != -1) {
                    outputStream.write(buf, 0, len);
                }
                outputStream.close();
                inputStream.close();
                this.existImageList.add(cacheFilename);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.existImageList.contains(cacheFilename)) {
            icon = new ImageIcon(path);
        }
        return icon;
    }

    public String getCacheFilenameFromURL(String url) {
        String[] urlSplit = url.split("/");
        int len = urlSplit.length;
        String filename = null;
        if (urlSplit.length >= 2) {
            filename = String.valueOf(urlSplit[len - 2]) + "_" + urlSplit[len - 1];
        }
        return filename;
    }
}

