/*
 * Decompiled with CFR 0.152.
 */
package twitter.gui.action;

import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import twitter.manage.TweetManager;
import twitter4j.TwitterException;

public class DirectMessageAction {
    private TweetManager tweetManager = this.tweetManager;
    private JLabel userNameLabel = null;
    private JLabel userImageLabel = null;
    private JTextPane statusTextBox = null;
    private JLabel tweetMessageCountLabel = null;

    public DirectMessageAction(JLabel userNameLabel, JLabel userImageLabel, JLabel tweetMessageCountLabel, JTextPane statusTextBox) {
        this.userNameLabel = userNameLabel;
        this.userImageLabel = userImageLabel;
        this.tweetMessageCountLabel = tweetMessageCountLabel;
        this.statusTextBox = statusTextBox;
    }

    public void setTweetManager(TweetManager tweetManager) {
        this.tweetManager = tweetManager;
    }

    public void setUserInformation(String username, URL userImageURL) {
        this.userNameLabel.setText(username);
        this.userImageLabel.setIcon(new ImageIcon(userImageURL));
    }

    public void sendDirectMessage() throws TwitterException {
        this.tweetManager.sendDirectMessage(this.userNameLabel.getText(), this.statusTextBox.getText());
        this.statusTextBox.setText("");
    }

    public void actionUpdateTweetMessageCount() {
        int len = 140 - this.statusTextBox.getText().length();
        if (len < 0) {
            len = 0;
        }
        this.tweetMessageCountLabel.setText(String.valueOf(len));
    }
}

