/*
 * Decompiled with CFR 0.152.
 */
package twitter.gui.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import twitter.action.TweetGetter;
import twitter.action.list.ListGetterSelection;
import twitter.gui.action.TweetMainAction;
import twitter.gui.component.TweetCommentRenderer;
import twitter.gui.component.TweetTableModel;
import twitter.gui.component.UserImageRenderer;
import twitter.manage.TweetManager;
import twitter4j.Status;
import twitter4j.TwitterException;

public class TweetTabbedTable {
    private JTable table;
    private TweetTableModel model;
    private int uncheckedTweet;
    private TweetGetter tweetGetter;
    private String title;
    private JTabbedPane tabbedPane;
    private JScrollPane scrollPane;
    private TweetManager tweetManager;
    private TweetMainAction mainAction;
    private int tableElementHeight;
    private Color newTableColor = null;
    private int tableElementMaxSize = 200;
    private String timerID;

    public TweetTabbedTable(TweetGetter tweetGetter, String title, JTabbedPane tabbedPane, int tableElementHeight, TweetManager tweetManager, TweetMainAction mainAction, Color newTableColor, int tableElementMaxSize, String timerID) {
        this.tweetGetter = tweetGetter;
        this.title = title;
        this.tabbedPane = tabbedPane;
        this.tweetManager = tweetManager;
        this.mainAction = mainAction;
        this.tableElementHeight = tableElementHeight;
        this.newTableColor = newTableColor;
        this.tableElementMaxSize = tableElementMaxSize;
        this.timerID = timerID;
        this.table = new JTable();
        this.model = new TweetTableModel();
        this.uncheckedTweet = 0;
        this.scrollPane = new JScrollPane();
    }

    public void addTableToTab() {
        this.getTable().setModel(this.model);
        this.getTable().getTableHeader().setReorderingAllowed(false);
        this.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                TweetTabbedTable.this.jTableMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                TweetTabbedTable.this.jTableMouseReleased(evt);
            }
        });
        this.createTweetTable(this.getTable());
        this.scrollPane.setViewportView(this.getTable());
        this.tabbedPane.addTab(this.title, this.scrollPane);
    }

    private void createTweetTable(final JTable table) {
        table.setAutoResizeMode(1);
        table.setShowVerticalLines(false);
        table.setShowHorizontalLines(true);
        TableColumnModel mdl = table.getColumnModel();
        TableColumn col = mdl.getColumn(1);
        TweetCommentRenderer commentRenderer = new TweetCommentRenderer();
        col.setCellRenderer(commentRenderer);
        TweetCommentRenderer infoRenderer = new TweetCommentRenderer();
        col = mdl.getColumn(2);
        col.setCellRenderer(infoRenderer);
        col.setMaxWidth(200);
        col.setMinWidth(150);
        col = mdl.getColumn(0);
        col.setCellRenderer(new UserImageRenderer());
        col.setMinWidth(50);
        col.setMaxWidth(50);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                table.clearSelection();
                Point p = e.getPoint();
                int col = table.columnAtPoint(p);
                int row = table.rowAtPoint(p);
                table.changeSelection(row, col, false, false);
                TweetTabbedTable.this.mainAction.setDetailInformationFromTable(table);
            }
        });
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                TweetTabbedTable.this.mainAction.setDetailInformationFromTable(table);
            }
        });
        table.addMouseListener(commentRenderer);
        table.addMouseListener(infoRenderer);
    }

    public void updateTweetTable() {
        try {
            int remainingHits = this.tweetManager.getRateLimitStatus().getRemainingHits();
            if (remainingHits <= 0) {
                return;
            }
            List<Status> tweet = this.tweetGetter.getNewTweetData();
            this.setUncheckedTweet(this.getUncheckedTweet() + tweet.size());
            if (this.getUncheckedTweet() > 0) {
                this.tabbedPane.setTitleAt(this.getTabSetNum(), String.valueOf(this.title) + "(" + this.getUncheckedTweet() + ")");
            }
            this.getModel().insertTweet(tweet);
            int tableHeight = this.getTableElementHeight();
            int i = 0;
            while (i < tweet.size()) {
                this.getTable().setRowHeight(i, tableHeight);
                ++i;
            }
            TableCellRenderer renderer = this.getTable().getCellRenderer(0, 2);
            if (renderer instanceof TweetCommentRenderer) {
                if (this.getUncheckedTweet() - 1 >= 0) {
                    ((TweetCommentRenderer)renderer).updateNewCellRow(this.getUncheckedTweet(), this.newTableColor);
                } else {
                    ((TweetCommentRenderer)renderer).updateNewCellRow(-1, this.newTableColor);
                }
            }
            this.getModel().removeOldTweet(this.getTableElementMaxSize());
            this.getModel().refreshTime();
            int newNum = 0;
            if (tweet != null) {
                newNum = tweet.size();
            }
            this.mainAction.information(String.valueOf(this.getTitle()) + "\u30bf\u30d6\u306e\u30c4\u30a4\u30fc\u30c8\u3092" + newNum + "\u4ef6\u53d6\u5f97\u3057\u307e\u3057\u305f. (API\u30ea\u30af\u30a8\u30b9\u30c8\u6b8b\u6570\u306f" + remainingHits + "\u56de\u3067\u3059)");
            this.mainAction.saveProperties();
        }
        catch (TwitterException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jTableMousePressed(MouseEvent evt) {
        this.showPopup(evt);
        this.setUncheckedTweet(0);
        this.setTitle(this.getTitle());
    }

    private void jTableMouseReleased(MouseEvent evt) {
        this.showPopup(evt);
    }

    private void showPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.getRightClickPopup().show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private JPopupMenu getRightClickPopup() {
        JPopupMenu rightClickPopup = new JPopupMenu();
        JMenuItem replyMenuItem = new JMenuItem("\u3053\u306e\u767a\u8a00\u306b\u8fd4\u4fe1(Reply)");
        replyMenuItem.setMnemonic('R');
        replyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TweetTabbedTable.this.mainAction.actionSetReplyStatusToTweetBoxPane();
            }
        });
        JMenuItem replyAllMenuItem = new JMenuItem("\u3053\u306e\u767a\u8a00\u306b\u8fd4\u4fe1(Reply All)");
        replyAllMenuItem.setMnemonic('A');
        replyAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TweetTabbedTable.this.mainAction.actionSetReplyAllStatusToTweetBoxPane();
            }
        });
        JMenuItem retweetMenuItem = new JMenuItem("\u767a\u8a00\u3092\u516c\u5f0f\u30ea\u30c4\u30a4\u30fc\u30c8(RT)");
        retweetMenuItem.setMnemonic('R');
        retweetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TweetTabbedTable.this.mainAction.actionRetweet();
            }
        });
        JMenuItem quoteMenuItem = new JMenuItem("\u767a\u8a00\u3092\u5f15\u7528\u30c4\u30a4\u30fc\u30c8(QT)");
        quoteMenuItem.setMnemonic('Q');
        quoteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TweetTabbedTable.this.mainAction.actionSetQuoteStatusToTweetBoxPane();
            }
        });
        JMenuItem unofficialRetweetMenuItem = new JMenuItem("\u767a\u8a00\u3092\u30b3\u30e1\u30f3\u30c8\u4ed8\u304d\u30ea\u30c4\u30a4\u30fc\u30c8(\u975e\u516c\u5f0fRT)");
        unofficialRetweetMenuItem.setMnemonic('T');
        unofficialRetweetMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TweetTabbedTable.this.mainAction.actionCopySelectedStatusToTweetBoxPane();
            }
        });
        JMenuItem directMessageMenuItem = new JMenuItem("\u30c0\u30a4\u30ec\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u9001\u4fe1(D)");
        directMessageMenuItem.setMnemonic('D');
        directMessageMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TweetTabbedTable.this.mainAction.actionShowDirectMessageDialog();
            }
        });
        JMenuItem statusBrowserMenuItem = new JMenuItem("\u3053\u306e\u767a\u8a00\u3092\u30d6\u30e9\u30a6\u30b6\u3067\u958b\u304f(O)");
        statusBrowserMenuItem.setMnemonic('O');
        statusBrowserMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TweetTabbedTable.this.mainAction.actionOpenStatusURL();
            }
        });
        JMenuItem userMenuItem = new JMenuItem("\u3053\u306e\u4eba\u306e\u767a\u8a00\u3092\u5225\u30bf\u30d6\u3067\u958b\u304f(U)");
        userMenuItem.setMnemonic('U');
        userMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TweetTabbedTable.this.mainAction.actionSelectedUserTimeline();
            }
        });
        JMenuItem createFavMenuItem = new JMenuItem("\u3053\u306e\u767a\u8a00\u3092\u304a\u6c17\u306b\u5165\u308a\u306b\u8ffd\u52a0(F)");
        createFavMenuItem.setMnemonic('F');
        createFavMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TweetTabbedTable.this.mainAction.actionCreateFavorite();
            }
        });
        JMenuItem destroyFavMenuItem = new JMenuItem("\u3053\u306e\u767a\u8a00\u3092\u304a\u6c17\u306b\u5165\u308a\u304b\u3089\u524a\u9664");
        destroyFavMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TweetTabbedTable.this.mainAction.actionDestroyFavorite();
            }
        });
        JMenuItem createdListMenuItem = new JMenuItem("\u3053\u306e\u30e6\u30fc\u30b6\u304c\u4f5c\u6210\u3057\u305f\u30ea\u30b9\u30c8\u4e00\u89a7");
        createdListMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TweetTabbedTable.this.mainAction.actionShowSelectedUserList(ListGetterSelection.CREATED);
            }
        });
        JMenuItem subscriptionListMenuItem = new JMenuItem("\u3053\u306e\u30e6\u30fc\u30b6\u304c\u8cfc\u8aad\u3057\u3066\u3044\u308b\u30ea\u30b9\u30c8\u4e00\u89a7");
        subscriptionListMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TweetTabbedTable.this.mainAction.actionShowSelectedUserList(ListGetterSelection.SUBSCRIPTION);
            }
        });
        JMenuItem membershipsListMenuItem = new JMenuItem("\u3053\u306e\u30e6\u30fc\u30b6\u304c\u30d5\u30a9\u30ed\u30fc\u3055\u308c\u3066\u3044\u308b\u30ea\u30b9\u30c8\u4e00\u89a7");
        membershipsListMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TweetTabbedTable.this.mainAction.actionShowSelectedUserList(ListGetterSelection.MEMBERSHIPS);
            }
        });
        int sc = this.table.getSelectedRowCount();
        if (sc == 1 && this.table != null) {
            Status st = this.mainAction.getTweetTableInformation(this.table, this.table.getModel());
            JMenuItem openBrowserUserInformationMenuItem = new JMenuItem("\u3053\u306e\u4eba\u306e\u767a\u8a00\u3092\u30d6\u30e9\u30a6\u30b6\u3067\u958b\u304f(B)");
            openBrowserUserInformationMenuItem.setMnemonic('B');
            openBrowserUserInformationMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TweetTabbedTable.this.mainAction.actionOpenUserURL();
                }
            });
            JMenuItem openFavMenuItem = new JMenuItem("\u3053\u306e\u4eba\u306e\u304a\u6c17\u306b\u5165\u308a\u3092\u958b\u304f");
            openFavMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TweetTabbedTable.this.mainAction.actionOpenUserFav();
                }
            });
            rightClickPopup.add(replyMenuItem);
            rightClickPopup.add(replyAllMenuItem);
            rightClickPopup.add(retweetMenuItem);
            rightClickPopup.add(unofficialRetweetMenuItem);
            rightClickPopup.add(quoteMenuItem);
            rightClickPopup.add(directMessageMenuItem);
            rightClickPopup.add(statusBrowserMenuItem);
            rightClickPopup.add(userMenuItem);
            rightClickPopup.add(openBrowserUserInformationMenuItem);
            rightClickPopup.add(openFavMenuItem);
            rightClickPopup.add(createdListMenuItem);
            rightClickPopup.add(subscriptionListMenuItem);
            rightClickPopup.add(membershipsListMenuItem);
            try {
                st.isRetweet();
                if (st.isFavorited()) {
                    rightClickPopup.add(destroyFavMenuItem);
                } else {
                    rightClickPopup.add(createFavMenuItem);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rightClickPopup;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.tabbedPane.setTitleAt(this.getTabSetNum(), title);
    }

    public int getTabSetNum() {
        int tabCount = this.tabbedPane.getTabCount();
        int i = 0;
        while (i < tabCount) {
            Component c = this.tabbedPane.getComponentAt(i);
            if (c instanceof JScrollPane && c == this.scrollPane) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public int getTableElementHeight() {
        return this.tableElementHeight;
    }

    public void setTableElementHeight(int tableElementHeight) {
        this.tableElementHeight = tableElementHeight;
    }

    public int getTableElementMaxSize() {
        return this.tableElementMaxSize;
    }

    public void setTableElementMaxSize(int tableElementMaxSize) {
        this.tableElementMaxSize = tableElementMaxSize;
    }

    public TweetTableModel getModel() {
        return this.model;
    }

    public void setModel(TweetTableModel model) {
        this.model = model;
    }

    public int getUncheckedTweet() {
        return this.uncheckedTweet;
    }

    public void setUncheckedTweet(int uncheckedTweet) {
        this.uncheckedTweet = uncheckedTweet;
    }

    public String getTimerID() {
        return this.timerID;
    }

    public JTable getTable() {
        return this.table;
    }
}

