/*
 * Decompiled with CFR 0.152.
 */
package twitter.gui.component;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;
import twitter.cache.TwitterImageCache;
import twitter.util.HTMLEncode;
import twitter4j.Status;

public class TweetTableModel
extends DefaultTableModel {
    private static final ColumnContext[] columnArray = new ColumnContext[]{new ColumnContext("User", ImageIcon.class, false), new ColumnContext("Comment", String.class, false), new ColumnContext("Info", String.class, false)};
    private final SimpleDateFormat tweetDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private List<Status> tweetStatus = new ArrayList<Status>();

    public void clearStatus() {
        this.tweetStatus.clear();
    }

    private long differenceTime(Date date1, Date date2) {
        long datetime1 = date1.getTime();
        long datetime2 = date2.getTime();
        return datetime1 - datetime2;
    }

    private long differenceTime(String strDate1, String strDate2) throws ParseException {
        Date date1 = DateFormat.getDateInstance().parse(strDate1);
        Date date2 = DateFormat.getDateInstance().parse(strDate2);
        return this.differenceTime(date1, date2);
    }

    @Override
    public Class<?> getColumnClass(int modelIndex) {
        return TweetTableModel.columnArray[modelIndex].columnClass;
    }

    @Override
    public int getColumnCount() {
        return columnArray.length;
    }

    @Override
    public String getColumnName(int modelIndex) {
        return TweetTableModel.columnArray[modelIndex].columnName;
    }

    public Status getTweetStatus(int row) {
        Status s = null;
        try {
            s = this.tweetStatus.get(row);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    public void insertTweet(Status t) {
        TwitterImageCache imageCache = TwitterImageCache.getInstance();
        Object[] obj = new Object[]{imageCache.getProfileImage(t.getUser().getProfileImageURL().toString()), "<b>" + t.getUser().getScreenName() + "</b> " + HTMLEncode.encode(t.getText()), String.valueOf(this.tweetDateFormat.format(t.getCreatedAt())) + "<br> " + t.getSource() + "\u304b\u3089"};
        try {
            super.insertRow(0, obj);
            this.tweetStatus.add(0, t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertTweet(List<Status> list) {
        TwitterImageCache imageCache = TwitterImageCache.getInstance();
        ImageIcon[] icons = new ImageIcon[list.size()];
        int i = 0;
        for (Status t : list) {
            icons[i] = imageCache.getProfileImage(t.getUser().getProfileImageURL().toString());
            ++i;
        }
        int j = 0;
        for (Status t : list) {
            Object[] obj = new Object[]{icons[j], "<b>" + t.getUser().getScreenName() + "</b> " + HTMLEncode.encode(t.getText()), String.valueOf(this.tweetDateFormat.format(t.getCreatedAt())) + "<br> " + t.getSource() + "\u304b\u3089"};
            try {
                super.insertRow(0, obj);
                this.tweetStatus.add(0, t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++j;
        }
    }

    public int getTweetTableSize() {
        return this.tweetStatus.size();
    }

    public void removeOldTweet(int num) {
        if (this.tweetStatus.size() < num) {
            return;
        }
        try {
            int deleteNum = this.tweetStatus.size() - num;
            int i = 0;
            while (i < deleteNum) {
                this.tweetStatus.remove(this.tweetStatus.size() - 1);
                super.removeRow(this.tweetStatus.size());
                ++i;
            }
            if (this.tweetStatus.size() != super.getRowCount()) {
                System.err.println("Tweet Table List Size and Table Size are different.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void refreshTime() {
        Date currentTime = new Date();
        String info = "";
        int numOfRow = super.getRowCount();
        int i = 0;
        while (i < numOfRow) {
            Status st = this.getTweetStatus(i);
            long diffTime = this.differenceTime(currentTime, st.getCreatedAt());
            boolean updateTime = true;
            String timeInfo = "";
            if (diffTime <= 60000L) {
                timeInfo = "\uff11\u5206\u524d";
            } else if (diffTime <= 3600000L) {
                timeInfo = String.valueOf(diffTime / 60000L) + "\u5206\u524d";
            } else if (diffTime <= 86400000L) {
                timeInfo = String.valueOf(diffTime / 3600000L) + "\u6642\u9593\u524d";
            } else {
                updateTime = false;
            }
            if (updateTime) {
                info = String.valueOf(timeInfo) + "<br> " + st.getSource() + "\u304b\u3089";
                super.setValueAt(info, i, 2);
            }
            ++i;
        }
    }

    private static class ColumnContext {
        public final Class columnClass;
        public final String columnName;
        public final boolean isEditable;

        public ColumnContext(String columnName, Class columnClass, boolean isEditable) {
            this.columnName = columnName;
            this.columnClass = columnClass;
            this.isEditable = isEditable;
        }
    }
}

