/*
 * Decompiled with CFR 0.152.
 */
package twitter.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.xml.sax.SAXParseException;
import twitter.manage.StatusXMLConverter;
import twitter.util.CurrentTime;
import twitter4j.Status;

public class TwitterLogManager {
    private static final String LOG_DIRECTORY = "log";
    private static final String TIMELINE_DIRECTORY = "timeline";
    private static final String CHARACTER_ENCODING = "utf-8";

    public void add(Status s) throws IOException {
        File logDir = new File("./log");
        if (!logDir.exists() && !logDir.mkdir()) {
            throw new IOException("log\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e");
        }
        String timelineDirName = "./log/timeline";
        File timelineDir = new File(timelineDirName);
        if (!timelineDir.exists() && !timelineDir.mkdir()) {
            throw new IOException("timeline\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e");
        }
        String filename = String.valueOf(timelineDirName) + "/" + CurrentTime.getCurrentYear() + "_" + CurrentTime.getCurrentMonth() + "_" + CurrentTime.getCurrentDay() + ".log";
        FileOutputStream fos = new FileOutputStream(filename, true);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, CHARACTER_ENCODING);
        BufferedWriter bw = new BufferedWriter(osw);
        StringBuffer writeData = new StringBuffer("");
        writeData.append(String.valueOf(StatusXMLConverter.convertStatusToXML(s)) + "\n");
        bw.write(writeData.toString());
        bw.close();
        osw.close();
        fos.close();
    }

    public void add(List<Status> statuses) throws IOException {
        File logDir = new File("./log");
        if (!logDir.exists() && !logDir.mkdir()) {
            throw new IOException("log\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e");
        }
        String timelineDirName = "./log/timeline";
        File timelineDir = new File(timelineDirName);
        if (!timelineDir.exists() && !timelineDir.mkdir()) {
            throw new IOException("timeline\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e");
        }
        String filename = String.valueOf(timelineDirName) + "/" + CurrentTime.getCurrentYear() + "_" + CurrentTime.getCurrentMonth() + "_" + CurrentTime.getCurrentDay() + ".log";
        FileOutputStream fos = new FileOutputStream(filename, true);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, CHARACTER_ENCODING);
        BufferedWriter bw = new BufferedWriter(osw);
        StringBuffer writeData = new StringBuffer("");
        for (Status s : statuses) {
            writeData.append(String.valueOf(StatusXMLConverter.convertStatusToXML(s)) + "\n");
        }
        bw.write(writeData.toString());
        bw.close();
        osw.close();
        fos.close();
    }

    public List<Status> get(int num, int year, int month, int day) throws IOException, SAXParseException {
        String timelineDirName = "./log/timeline";
        String filename = String.valueOf(timelineDirName) + "/" + year + "_" + month + "_" + day + ".log";
        List<Status> tweetData = null;
        if (num < 0) {
            throw new IndexOutOfBoundsException();
        }
        try {
            File f = new File(filename);
            byte[] b = new byte[(int)f.length()];
            FileInputStream fi = new FileInputStream(f);
            fi.read(b);
            String data = new String(b, CHARACTER_ENCODING);
            fi.close();
            data = "<root>" + data + "</root>";
            tweetData = StatusXMLConverter.XMLToStatus(data);
        }
        catch (NullPointerException e) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f.");
        }
        catch (FileNotFoundException e) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f.");
        }
        int from = tweetData.size() - num;
        int to = tweetData.size();
        if (from < 0) {
            from = 0;
        }
        return tweetData.subList(from, to);
    }

    public List<Status> get(int num) throws SAXParseException, IOException {
        int year = CurrentTime.getCurrentYear();
        int month = CurrentTime.getCurrentMonth();
        int day = CurrentTime.getCurrentDay();
        return this.get(num, year, month, day);
    }
}

