/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.IOException;
import java.io.InputStream;
import twitter4j.DirectMessage;
import twitter4j.DirectMessageJSONImpl;
import twitter4j.StatusStreamImpl;
import twitter4j.StreamListener;
import twitter4j.TwitterException;
import twitter4j.UserStream;
import twitter4j.UserStreamListener;
import twitter4j.conf.Configuration;
import twitter4j.internal.async.Dispatcher;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

class UserStreamImpl
extends StatusStreamImpl
implements UserStream {
    UserStreamImpl(Dispatcher dispatcher, InputStream stream, Configuration conf) throws IOException {
        super(dispatcher, stream, conf);
    }

    UserStreamImpl(Dispatcher dispatcher, HttpResponse response, Configuration conf) throws IOException {
        super(dispatcher, response, conf);
    }

    public void next(UserStreamListener listener) throws TwitterException {
        StreamListener[] list = new StreamListener[]{listener};
        this.listeners = list;
        this.handleNextElement();
    }

    public void next(StreamListener[] listeners) throws TwitterException {
        this.listeners = listeners;
        this.handleNextElement();
    }

    protected String parseLine(String line) {
        this.line = line;
        return line;
    }

    protected void onSender(JSONObject json) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onDirectMessage((DirectMessage)new DirectMessageJSONImpl(json));
        }
    }

    protected void onDirectMessage(JSONObject json) throws TwitterException, JSONException {
        DirectMessage directMessage = this.asDirectMessage(json);
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onDirectMessage(directMessage);
        }
    }

    protected void onScrubGeo(JSONObject json) throws TwitterException {
        logger.info("Geo-tagging deletion notice (not implemented yet): " + this.line);
    }

    protected void onFriends(JSONObject json) throws TwitterException, JSONException {
        long[] friendIds = this.asFriendList(json);
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onFriendList(friendIds);
        }
    }

    protected void onFavorite(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onFavorite(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
        }
    }

    protected void onUnfavorite(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUnfavorite(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
        }
    }

    protected void onRetweet(JSONObject source, JSONObject target, JSONObject targetObject) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onRetweet(this.asUser(source), this.asUser(target), this.asStatus(targetObject));
        }
    }

    protected void onFollow(JSONObject source, JSONObject target) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onFollow(this.asUser(source), this.asUser(target));
        }
    }

    protected void onUserListMemberAddition(JSONObject addedMember, JSONObject owner, JSONObject target) throws TwitterException, JSONException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUserListMemberAddition(this.asUser(addedMember), this.asUser(owner), this.asUserList(target));
        }
    }

    protected void onUserListMemberDeletion(JSONObject deletedMember, JSONObject owner, JSONObject target) throws TwitterException, JSONException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUserListMemberDeletion(this.asUser(deletedMember), this.asUser(owner), this.asUserList(target));
        }
    }

    protected void onUserListSubscription(JSONObject source, JSONObject owner, JSONObject target) throws TwitterException, JSONException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUserListSubscription(this.asUser(source), this.asUser(owner), this.asUserList(target));
        }
    }

    protected void onUserListUnsubscription(JSONObject source, JSONObject owner, JSONObject target) throws TwitterException, JSONException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUserListUnsubscription(this.asUser(source), this.asUser(owner), this.asUserList(target));
        }
    }

    protected void onUserListCreation(JSONObject source, JSONObject target) throws TwitterException, JSONException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUserListCreation(this.asUser(source), this.asUserList(target));
        }
    }

    protected void onUserListUpdated(JSONObject source, JSONObject target) throws TwitterException, JSONException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUserListUpdate(this.asUser(source), this.asUserList(target));
        }
    }

    protected void onUserListDestroyed(JSONObject source, JSONObject target) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUserListDeletion(this.asUser(source), this.asUserList(target));
        }
    }

    protected void onUserUpdate(JSONObject source, JSONObject target) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUserProfileUpdate(this.asUser(source));
        }
    }

    protected void onBlock(JSONObject source, JSONObject target) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onBlock(this.asUser(source), this.asUser(target));
        }
    }

    protected void onUnblock(JSONObject source, JSONObject target) throws TwitterException {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            ((UserStreamListener)listener).onUnblock(this.asUser(source), this.asUser(target));
        }
    }

    public void onException(Exception e) {
        StreamListener[] arr$ = this.listeners;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            StreamListener listener = arr$[i$];
            listener.onException(e);
        }
    }
}

