/*
 * Decompiled with CFR 0.152.
 */
package twitter.gui.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class TweetCommentRenderer
extends JEditorPane
implements TableCellRenderer,
MouseListener,
MouseMotionListener {
    private int row = -1;
    private int col = -1;
    private final Color currentTableColor = Color.WHITE;
    private Color newTableColor = new Color(224, 255, 255);
    private int newTableRow = -1;

    public TweetCommentRenderer() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        super.setEditable(false);
        this.setContentType("text/html");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.newTableRow >= 0 && row < this.newTableRow) {
            this.setBackground(this.newTableColor);
        } else {
            this.setBackground(this.currentTableColor);
        }
        this.setFont(table.getFont());
        try {
            HTMLDocument doc = (HTMLDocument)this.getDocument();
            StyleSheet[] style = doc.getStyleSheet().getStyleSheets();
            int i = style.length - 1;
            while (i >= 0) {
                Style body = style[i].getStyle("body");
                if (body != null) {
                    StyleConstants.setFontFamily(body, table.getFont().getFontName());
                    StyleConstants.setFontSize(body, table.getFont().getSize());
                }
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setText(value == null ? "" : value.toString());
        if (!table.isEditing() && this.row == row && this.col == column) {
            this.setText("<html><u><font color='blue'>" + value.toString());
        } else if (hasFocus) {
            this.setText("<html><font color='blue'>" + value.toString());
        } else {
            this.setText(value.toString());
        }
        return this;
    }

    public void updateNewCellRow(int row, Color newTableColor) {
        this.newTableRow = row;
        this.newTableColor = newTableColor;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        this.row = -1;
        this.col = -1;
        table.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JTable table = (JTable)e.getSource();
        Point pt = e.getPoint();
        int crow = table.rowAtPoint(pt);
        int ccol = table.columnAtPoint(pt);
        if (table.getColumnClass(ccol).equals(URL.class)) {
            URL url = (URL)table.getValueAt(crow, ccol);
            System.out.println(url);
            try {
                Desktop.getDesktop().browse(url.toURI());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseClicked(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

