/*
 * Decompiled with CFR 0.152.
 */
package twitter.task;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import twitter.task.TweetTaskException;
import twitter.task.TweetUpdateTask;

public class TweetTaskManager {
    private List<TimerData> timerList = new ArrayList<TimerData>();

    public void addTask(String timerID, TweetUpdateTask task) throws TweetTaskException {
        if (this.timerList.contains(new TimerData(null, timerID))) {
            throw new TweetTaskException("\u3059\u3067\u306b\u30bf\u30b9\u30af\u304c\u5b58\u5728\u3057\u3066\u3044\u307e\u3059");
        }
        TimerData t = new TimerData(task, timerID);
        this.timerList.add(t);
    }

    public boolean startTask(String timerID, long period) throws TweetTaskException {
        boolean found = false;
        for (TimerData t : this.timerList) {
            if (!t.getTimerID().equals(timerID)) continue;
            t.start(period);
            found = true;
            break;
        }
        return found;
    }

    public boolean shutdownTask(String timerID) {
        boolean found = false;
        TimerData removeData = null;
        for (TimerData t : this.timerList) {
            if (!t.getTimerID().equals(timerID)) continue;
            t.stop();
            t.shutdown();
            found = true;
            removeData = t;
            break;
        }
        if (removeData != null) {
            this.timerList.remove(removeData);
        }
        return found;
    }

    public boolean resetTask(String timerID, boolean immediatelyUpdate) {
        boolean found = false;
        for (TimerData t : this.timerList) {
            if (!t.getTimerID().equals(timerID)) continue;
            t.reset(immediatelyUpdate);
            found = true;
            break;
        }
        return found;
    }

    public boolean updateTaskPeriod(String timerID, int period, boolean immediatelyUpdate) {
        boolean found = false;
        for (TimerData t : this.timerList) {
            if (!t.getTimerID().equals(timerID)) continue;
            t.setPeriod(period * 1000);
            t.reset(immediatelyUpdate);
            found = true;
            break;
        }
        return found;
    }

    private class TimerData {
        private ScheduledFuture<?> future;
        private ScheduledExecutorService scheduler;
        private final Runnable task;
        private long period = 0L;
        private String timerID = null;

        public TimerData(TweetUpdateTask task, String timerID) {
            this.task = new TweetTaskTimerTask(task);
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            if (timerID == null) {
                throw new NullPointerException("TimerID\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            this.timerID = timerID;
        }

        public void reset(boolean immediatelyUpdate) {
            this.stop();
            if (this.future != null) {
                this.future = immediatelyUpdate ? this.scheduler.scheduleAtFixedRate(this.task, 0L, this.getPeriod(), TimeUnit.MILLISECONDS) : this.scheduler.scheduleAtFixedRate(this.task, this.getPeriod(), this.getPeriod(), TimeUnit.MILLISECONDS);
            }
        }

        public void shutdown() {
            this.scheduler.shutdown();
        }

        public void start(long period) {
            this.future = this.scheduler.scheduleAtFixedRate(this.task, 0L, period, TimeUnit.MILLISECONDS);
            this.setPeriod(period);
        }

        public void stop() {
            if (this.future != null) {
                this.future.cancel(true);
            }
        }

        public String getTimerID() {
            return this.timerID;
        }

        public void setTimerID(String timerID) {
            this.timerID = timerID;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimerData other = (TimerData)obj;
            return !(this.timerID == null ? other.timerID != null : !this.timerID.equals(other.timerID));
        }

        public int hashCode() {
            int hash = 3;
            hash = 23 * hash + (this.timerID != null ? this.timerID.hashCode() : 0);
            return hash;
        }

        public long getPeriod() {
            return this.period;
        }

        public void setPeriod(long period) {
            this.period = period;
        }
    }

    private class TweetTaskTimerTask
    implements Runnable {
        private TweetUpdateTask task;

        public TweetTaskTimerTask(TweetUpdateTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            try {
                this.task.runTask();
            }
            catch (TweetTaskException ex) {
                Logger.getLogger(TweetTaskManager.class.getName()).log(Level.SEVERE, "TimerTask\u5185\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", ex);
            }
        }
    }
}

