/*
 * Decompiled with CFR 0.152.
 */
package twitter.action;

import java.util.List;
import twitter.action.TweetGetter;
import twitter.manage.TweetManager;
import twitter4j.Status;

public class TweetListGetter
implements TweetGetter {
    private TweetManager tweetManager;
    private int listID;
    private String username = null;
    private long sinceID;

    public TweetListGetter(TweetManager tweetManager, String username, int listID) {
        this.tweetManager = tweetManager;
        this.username = username;
        this.listID = listID;
    }

    @Override
    public List<Status> getTweetData(int num) {
        int lastnum;
        List<Status> status = this.tweetManager.getUserListStatuses(this.username, this.listID, num);
        if (status != null && (lastnum = status.size()) > 0) {
            this.sinceID = status.get(lastnum - 1).getId();
        }
        return status;
    }

    @Override
    public List<Status> getNewTweetData() {
        int lastnum;
        List<Status> status = this.tweetManager.getNewUserListStatuses(this.username, this.listID, this.sinceID);
        if (status != null && (lastnum = status.size()) > 0) {
            this.sinceID = status.get(lastnum - 1).getId();
        }
        return status;
    }
}

