/*
 * Decompiled with CFR 0.152.
 */
package twitter.action;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import twitter.action.TweetGetter;
import twitter.manage.TweetManager;
import twitter4j.Status;
import twitter4j.TwitterException;

public class TweetUserTimelineGetter
implements TweetGetter {
    private TweetManager tweetManager;
    private String screenName;
    private long sinceID;

    public TweetUserTimelineGetter(TweetManager tweetManager, String screenName) {
        this.tweetManager = tweetManager;
        this.screenName = screenName;
    }

    @Override
    public List<Status> getTweetData(int num) {
        int lastnum;
        List<Status> status = null;
        try {
            status = this.tweetManager.getUserTimeline(num, this.screenName);
        }
        catch (TwitterException ex) {
            Logger.getLogger(TweetUserTimelineGetter.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (status != null && (lastnum = status.size()) > 0) {
            this.sinceID = status.get(lastnum - 1).getId();
        }
        return status;
    }

    @Override
    public List<Status> getNewTweetData() {
        int lastnum;
        List<Status> status = null;
        try {
            status = this.tweetManager.getNewUserTimeline(this.screenName, this.sinceID);
        }
        catch (TwitterException ex) {
            Logger.getLogger(TweetUserTimelineGetter.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (status != null && (lastnum = status.size()) > 0) {
            this.sinceID = status.get(lastnum - 1).getId();
        }
        return status;
    }
}

