/*
 * Decompiled with CFR 0.152.
 */
package twitter.log;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.List;
import org.xml.sax.SAXParseException;
import twitter.manage.StatusXMLConverter;
import twitter.util.CurrentTime;
import twitter4j.Status;

public class TwitterLogManager {
    private static final String LOG_DIRECTORY = "log";
    private static final String TIMELINE_DIRECTORY = "timeline";
    private static final String CHARACTER_ENCODING = "utf-8";

    public void add(Status s) throws IOException {
        File logDir = new File("./log");
        if (!logDir.exists() && !logDir.mkdir()) {
            throw new IOException("log\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e");
        }
        String timelineDirName = "./log/timeline";
        File timelineDir = new File(timelineDirName);
        if (!timelineDir.exists() && !timelineDir.mkdir()) {
            throw new IOException("timeline\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e");
        }
        String filename = String.valueOf(timelineDirName) + "/" + CurrentTime.getCurrentYear() + "_" + CurrentTime.getCurrentMonth() + "_" + CurrentTime.getCurrentDay() + ".log";
        FileOutputStream fos = new FileOutputStream(filename, true);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, CHARACTER_ENCODING);
        BufferedWriter bw = new BufferedWriter(osw);
        StringBuffer writeData = new StringBuffer("");
        writeData.append(String.valueOf(StatusXMLConverter.convertStatusToXML(s)) + "\n");
        bw.write(writeData.toString());
        bw.close();
        osw.close();
        fos.close();
    }

    public void add(List<Status> statuses) throws IOException {
        File logDir = new File("./log");
        if (!logDir.exists() && !logDir.mkdir()) {
            throw new IOException("log\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e");
        }
        String timelineDirName = "./log/timeline";
        File timelineDir = new File(timelineDirName);
        if (!timelineDir.exists() && !timelineDir.mkdir()) {
            throw new IOException("timeline\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e");
        }
        String filename = String.valueOf(timelineDirName) + "/" + CurrentTime.getCurrentYear() + "_" + CurrentTime.getCurrentMonth() + "_" + CurrentTime.getCurrentDay() + ".log";
        FileOutputStream fos = new FileOutputStream(filename, true);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, CHARACTER_ENCODING);
        BufferedWriter bw = new BufferedWriter(osw);
        StringBuffer writeData = new StringBuffer("");
        for (Status s : statuses) {
            writeData.append(String.valueOf(StatusXMLConverter.convertStatusToXML(s)) + "\n");
        }
        bw.write(writeData.toString());
        bw.close();
        osw.close();
        fos.close();
    }

    public List<Status> get(int num, int year, int month, int day) throws IOException, SAXParseException {
        String timelineDirName = "./log/timeline";
        String filename = String.valueOf(timelineDirName) + "/" + year + "_" + month + "_" + day + ".log";
        return this.get(num, filename);
    }

    public List<Status> get(int year, int month, int day) throws IOException, SAXParseException {
        String timelineDirName = "./log/timeline";
        String filename = String.valueOf(timelineDirName) + "/" + year + "_" + month + "_" + day + ".log";
        return this.get(filename);
    }

    public List<Status> get(int num, String path) throws IOException, SAXParseException {
        String filename = path;
        List<Status> tweetData = this.get(path);
        int from = tweetData.size() - num;
        int to = tweetData.size();
        if (from < 0) {
            from = 0;
        }
        return tweetData.subList(from, to);
    }

    public List<Status> get(String path) throws IOException, SAXParseException {
        String filename = path;
        List<Status> tweetData = null;
        try {
            File f = new File(filename);
            byte[] b = new byte[(int)f.length()];
            FileInputStream fi = new FileInputStream(f);
            fi.read(b);
            String data = new String(b, CHARACTER_ENCODING);
            fi.close();
            data = "<root>" + data + "</root>";
            tweetData = StatusXMLConverter.XMLToStatus(data);
        }
        catch (NullPointerException e) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f.");
        }
        catch (FileNotFoundException e) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f.");
        }
        return tweetData;
    }

    public List<Status> get(int num) throws SAXParseException, IOException {
        int year = CurrentTime.getCurrentYear();
        int month = CurrentTime.getCurrentMonth();
        int day = CurrentTime.getCurrentDay();
        return this.get(num, year, month, day);
    }

    public List<Status> get() throws SAXParseException, IOException {
        int year = CurrentTime.getCurrentYear();
        int month = CurrentTime.getCurrentMonth();
        int day = CurrentTime.getCurrentDay();
        return this.get(year, month, day);
    }

    public void outputCSVLog(String filepath, List<Status> status, boolean showUsername, boolean showScreenName, boolean showText, boolean showUpdateTime, boolean showClient, boolean showUserDescription, boolean showFollowing, boolean showFollower, boolean showUpdateCount, boolean showUserURL, boolean showProfileImageURL) throws IOException {
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(filepath));
        int col = 0;
        String[] title = new String[11];
        if (showUsername) {
            title[col++] = "Username";
        }
        if (showScreenName) {
            title[col++] = "ScreenName";
        }
        if (showText) {
            title[col++] = "Tweet";
        }
        if (showUpdateTime) {
            title[col++] = "UpdateTime";
        }
        if (showClient) {
            title[col++] = "Source";
        }
        if (showUserDescription) {
            title[col++] = "UserDescription";
        }
        if (showFollowing) {
            title[col++] = "Following";
        }
        if (showFollower) {
            title[col++] = "Follower";
        }
        if (showUpdateCount) {
            title[col++] = "UpdateCount";
        }
        if (showUserURL) {
            title[col++] = "URL";
        }
        if (showProfileImageURL) {
            title[col++] = "UserImageURL";
        }
        writer.writeNext(title);
        for (Status s : status) {
            if (s.isRetweet()) {
                s = s.getRetweetedStatus();
            }
            String username = s.getUser().getName();
            String screenName = s.getUser().getScreenName();
            String text = s.getText();
            String updateTime = DateFormat.getInstance().format(s.getCreatedAt());
            String client = s.getSource();
            String userDescription = s.getUser().getDescription();
            int following = s.getUser().getFriendsCount();
            int follower = s.getUser().getFollowersCount();
            int updateCount = s.getUser().getStatusesCount();
            String userURL = "";
            try {
                userURL = s.getUser().getURL().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String profileImageURL = s.getUser().getProfileImageURL().toString();
            col = 0;
            String[] data = new String[11];
            if (showUsername) {
                data[col++] = username;
            }
            if (showScreenName) {
                data[col++] = screenName;
            }
            if (showText) {
                data[col++] = text;
            }
            if (showUpdateTime) {
                data[col++] = updateTime;
            }
            if (showClient) {
                data[col++] = client;
            }
            if (showUserDescription) {
                data[col++] = userDescription;
            }
            if (showFollowing) {
                data[col++] = String.valueOf(following);
            }
            if (showFollower) {
                data[col++] = String.valueOf(follower);
            }
            if (showUpdateCount) {
                data[col++] = String.valueOf(updateCount);
            }
            if (showUserURL) {
                data[col++] = userURL;
            }
            if (showProfileImageURL) {
                data[col++] = profileImageURL;
            }
            writer.writeNext(data);
        }
        writer.close();
    }
}

