#include <stdio.h>
#include <string.h>
#include <unistd.h>

char* trim(char* source)
{
	size_t len;
	len = strlen(source);
	if(len <= 0)
		return source;
	
	if(source[len - 1] == '\n')
		source[len - 1] = '\0';
	return source;
}

int main(int argc, char* argv[])
{
	char buf[1024];
	FILE *in_fp;

	if(argc < 2){
		printf("You must always specify the source file name.\n");
		return(1);
	}

	in_fp = fopen(argv[1], "r");
	if(!in_fp){
		printf("Failed to open the file.\n");
		return(1);
	}

	printf("/*\n");
	printf(" * This file is generated by the help_gen auto source file generator.\n");
	printf(" */\n\n");

	printf("#include <stdio.h>\n\n");
	printf("void print_help()\n{\n");

	while(fgets(buf,sizeof(buf)-1, in_fp)){
		if(0 == strlen(buf))
			printf(" \n");
		else
			printf("\tprintf(\"%s\\n\");\n", trim(buf));
	}

	printf("\n}\n");

	fclose(in_fp);
}
