;; site-start.el -*- coding: iso-2022-7bit -*-

;; $B8@8l4D6-$N@_Dj(B

(when (string-match current-language-environment "Japanese")
  (set-keyboard-coding-system             'sjis)
  (set-clipboard-coding-system            'sjis)
  (setq file-name-coding-system 'japanese-shift-jis))

;; $BEyI}%U%)%s%H@_Dj(B

(when (and (featurep 'dos-w32) (locate-library "ntemacs-font"))
  (require 'ntemacs-font)
  (setq initial-frame-alist
	(append
	 (list
	  '(height . 50)
	  '(line-spacing . 2)) 
	 initial-frame-alist))
  (setq fontname
        (cond
         ((x-list-fonts "*$B#M#S(B $B%4%7%C%/(B*")
          "-*-*-normal-r-normal-normal-12-*-*-*-*-*-fontset-msgothic")
         ((x-list-fonts "*Lucida Console*")
          "-*-*-normal-r-normal-normal-12-*-*-*-*-*-fontset-lucida")
         (t "fontset-default")))
  (setq default-frame-alist
	(append
	 (list
	  '(height . 47)
 	  `(font . ,fontname)
	  '(line-spacing . 2)) 
	 default-frame-alist)))

;; Info-path $B$NDI2C(B
(let ((info1 (concat (getenv "EMACSPATH") "/../info"))
      (info2 (concat (getenv "EMACSPATH") "/../../info"))
      (infopath (getenv "INFOPATH")))
  (nconc Info-default-directory-list `(,info1 ,info2))
  (setenv "INFOPATH" (concat infopath ";" info1 ";" info2)))

;; cygwin $B$N%^%&%s%H$r!"DI$($k$h$&$K(B

(when (and (featurep 'dos-w32)
           (executable-find "mount.exe")
           (locate-library "cygwin-mount"))
  (require 'cygwin-mount)
  (cygwin-mount-activate))

;; windows $B$N!"%7%g!<%H%+%C%H$rDI$&(B

(when (and (featurep 'dos-w32) (locate-library "w32-symlinks"))
  (setq w32-symlinks-handle-shortcuts t)
  (require 'w32-symlinks)

  ;; http://www.bookshelf.jp/soft/meadow_25.html#SEC279 $B$h$j(B
  ;;  25.3.8.1 $B%U%!%$%k$r3+$/;~$K%7%g!<%H%+%C%H$rC)$k(B (2005/02/17)
  ;; URL="http://www.bookshelf.jp/cgi-bin/goto.cgi?file=meadow&node=findfile%20symlink"
  ;; "MeadowMemo/$B%U%!%$%k$r3+$/;~$K%7%g!<%H%+%C%H$rC)$k(B"$B$X$N%3%a%s%H(B($BL5$7(B)
  ;; $B8!:wA4J8(BElisp
  ;; $BMWLs(B
  ;; $B?<$$%G%#%l%/%H%j$dJL%I%i%$%V$N%G%#%l%/%H%j$N%U%!%$%k$r3+$/:]!$(B Windows $B$N%7%g!<%H%+%C%H$rMxMQ$7$F4JC1$K3+$/$3$H$,$G$-$^$9!%(B
  ;; $B>pJs8;(B
  ;; Wiki $B$G$N%j%/%(%9%H$r$b$H$K=q$$$?$b$N!%(B
  ;; $B2?$,LdBj$J$N$+(B?
  ;; C-x C-f$B$GJL%I%i%$%V$N?<$$%G%#%l%/%H%j$K0\F0$9$k$N$OLLE]$J$b$N$G$9!%(B
  ;; $B2?$,$G$-$k$N$+(B?
  ;; $BNc$($P!$(BG$B%I%i%$%V$X$N%7%g!<%H%+%C%H$r:n$C$F$*$1$P!$(BC-x C-f g-drive.lnk TAB $B$G(B G $B%I%i%$%V$X0\F0$G$-$^$9!%(B
  ;; $B@_DjJ}K!(B
  ;; $B0J2<$r(B.emacs $B$KDI2C$7$^$9!%(B

  (defadvice minibuffer-complete
    (before expand-symlinks activate)
    (let ((file (expand-file-name
                 (buffer-substring-no-properties
                  (line-beginning-position)
                  (line-end-position)))))
      (when (string-match ".lnk$" file)
        (delete-region
         (line-beginning-position)
         (line-end-position))
        (if (file-directory-p
             (w32-symlinks-parse-symlink file))
            (insert
             (concat
              (w32-symlinks-parse-symlink file) "/"))
          (insert (w32-symlinks-parse-symlink file)))))))

;;

(setq list-faces-sample-text
      (concat
       "(roman)            Hello, ,A!(BHola!, Guten Tag, Gr,A|_(B Gott\n"
       "($BF|K\8l(B,$B$K$[$s$4(B)  $B$3$s$K$A$O(B, (I:]FAJ(B,        $B855$(B $B3+H/(B\n"
       "($AVPND(B,$AFUM(;0(B,$A::So(B) $ADc:C(B,                     $AT*Fx(B $A?*7"(B\n"
       "($(0GnM$(B,$(0N]0*Hd(B)      $(0*/=((B, $(0+$)p(B,               $(0&x86(B $(0DeBv(B\n"
       "($(CGQ1[(B)             $(C>H3gGO<<?d(B, $(C>H3gGO=J4O1n(B, $(Cj*Q((B $(CKR[!(B"))

