<?php

require_once(NUE_CONSTANTS);
require_once('CEntity.php');
require_once(NUE_LIB_ROOT . '/dao/CUser.php');
require_once(NUE_LIB_ROOT . '/state/scene/error/CSceneSimpleError.php');
require_once(NUE_LIB_ROOT . '/state/scene/error/CSceneDBFailed.php');

/**
 *	ԂIuWFNgB
 */
class CScene
	extends CEntity
{

	/**	݃ZbVǂB */
	private static $inSession = false;

	/**
	 *	RXgN^B
	 *
	 *	@param $firstState ŏ̏ԁBłnullB
	 */
	public function __construct(IState $firstState = null)
	{
		parent::__construct($firstState);
	}

	/**
	 *	f[^x[Xɐڑ܂B
	 *
	 *	sꍇAIɃG[bZ[W\V[ւƃWv܂B
	 *	V[̃R~bg͍sȂ߁AIɍsȀ݂Ԃ1[vsKv܂B
	 *
	 *	@return boolean ڑɐꍇAtrueB
	 */
	public function connectDatabase()
	{
		$db = CDBManager::getInstance();
		$result = $db->connect();
		if(!$result)
		{
			$this->setNextState(CSceneDBFailed::getInstance());
		}
		return $result;
	}

	/**
	 *	ZbVJn܂B
	 *
	 *	sꍇAIɃG[bZ[W\V[ւƃWv܂B
	 *	V[̃R~bg͍sȂ߁AIɍsȀ݂Ԃ1[vsKv܂B
	 *
	 *	@param $name ZbVB
	 *	@return boolean ZbVJnɐꍇAtrueB
	 */
	public function startSession($name = CConstants::SESSION_CORE)
	{
		if(!self::$inSession)
		{
			self::$inSession = true;
			try
			{
				session_name($name);
				session_start();
			}
			catch(Exception $e)
			{
				error_log($e);
				unset($_SESSION['user']);
			}
		}
	}

	public function endSession()
	{
		session_write_close();
		self::$inSession = false;
	}

	/**
	 *	[UZbVɊi[܂B
	 *
	 *	: ZbV̕ۑƃN[Y͎ōs܂B
	 *
	 *	@param CUser $value [UBnullݒ肷ƎIɃZbV폜܂B
	 */
	public function setUser(CUser $value = null)
	{
		if($value === null)
		{
			unset($_SESSION['user']);
		}
		else
		{
			$_SESSION['user'] = $value;
		}
	}

	/**
	 *	ZbVɕۑꂽ[U擾܂B
	 *
	 *	@param IState $stateOnFailed s̏ԁB
	 *	@return CUser [UB
	 */
	public function getUser(IState $stateOnFailed = null)
	{
		$result = null;
		if(isset($_SESSION['user']) && $_SESSION['user'] instanceof CUser)
		{
			$result = $_SESSION['user'];
		}
		else
		{
			$this->setNextState($stateOnFailed);
		}
		return $result;
	}
}

?>
