/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARLabel;
import jp.nyatla.nyartoolkit.core.NyARLabelHolder;
import jp.nyatla.nyartoolkit.core.NyARLabeling;
import jp.nyatla.nyartoolkit.core.NyARWorkHolder;
import jp.nyatla.nyartoolkit.core.raster.NyARRaster;

class NyARLabeling_O2
implements NyARLabeling {
    private static final int WORK_SIZE = 32768;
    private final int[][] glabel_img;
    private final NyARWorkHolder work_holder = new NyARWorkHolder(32768);
    private final NyARLabelHolder label_holder = new NyARLabelHolder(32768);
    private int label_num;
    private final int width;
    private final int height;
    private int[] wk_reservLineBuffer_buf = null;

    public NyARLabeling_O2(int i_width, int i_height) {
        int i;
        this.width = i_width;
        this.height = i_height;
        this.glabel_img = new int[this.height][this.width];
        this.wk_reservLineBuffer_buf = new int[this.width];
        this.label_num = 0;
        int[][] label_img = this.glabel_img;
        for (i = 0; i < i_width; ++i) {
            label_img[0][i] = 0;
            label_img[i_height - 1][i] = 0;
        }
        for (i = 0; i < i_height; ++i) {
            label_img[i][0] = 0;
            label_img[i][i_width - 1] = 0;
        }
    }

    @Override
    public int getLabelNum() {
        return this.label_num;
    }

    @Override
    public NyARLabel[] getLabel() throws NyARException {
        if (this.label_num < 1) {
            throw new NyARException();
        }
        return this.label_holder.labels;
    }

    @Override
    public int[] getLabelRef() throws NyARException {
        if (this.label_num < 1) {
            throw new NyARException();
        }
        return this.work_holder.work;
    }

    @Override
    public int[][] getLabelImg() throws NyARException {
        return this.glabel_img;
    }

    @Override
    public void labeling(NyARRaster image, int thresh) throws NyARException {
        NyARLabel label_pt;
        int[] work2_pt;
        int i;
        int j;
        int thresht3 = thresh * 3;
        int lxsize = image.getWidth();
        int lysize = image.getHeight();
        if (lxsize != this.width || lysize != this.height) {
            throw new NyARException();
        }
        this.label_num = 0;
        int[][] label_img = this.glabel_img;
        int wk_max = 0;
        int[] work = this.work_holder.work;
        int[][] work2 = this.work_holder.work2;
        int[] line_bufferr = this.wk_reservLineBuffer_buf;
        for (j = 1; j < lysize - 1; ++j) {
            int[] label_img_pt0 = label_img[j];
            int[] label_img_pt1 = label_img[j - 1];
            image.getPixelTotalRowLine(j, line_bufferr);
            for (i = 1; i < lxsize - 1; ++i) {
                if (line_bufferr[i] <= thresht3) {
                    int label_pixel;
                    if (label_img_pt1[i] > 0) {
                        label_pixel = label_img_pt1[i];
                        work2_pt = work2[label_pixel - 1];
                        work2_pt[0] = work2_pt[0] + 1;
                        work2_pt[1] = work2_pt[1] + i;
                        work2_pt[2] = work2_pt[2] + j;
                        work2_pt[6] = j;
                    } else if (label_img_pt1[i + 1] > 0) {
                        int k;
                        int n;
                        int m;
                        if (label_img_pt1[i - 1] > 0) {
                            m = work[label_img_pt1[i + 1] - 1];
                            n = work[label_img_pt1[i - 1] - 1];
                            if (m > n) {
                                label_pixel = n;
                                for (k = 0; k < wk_max; ++k) {
                                    if (work[k] != m) continue;
                                    work[k] = n;
                                }
                            } else if (m < n) {
                                label_pixel = m;
                                for (k = 0; k < wk_max; ++k) {
                                    if (work[k] != n) continue;
                                    work[k] = m;
                                }
                            } else {
                                label_pixel = m;
                            }
                            work2_pt = work2[label_pixel - 1];
                            work2_pt[0] = work2_pt[0] + 1;
                            work2_pt[1] = work2_pt[1] + i;
                            work2_pt[2] = work2_pt[2] + j;
                            work2_pt[6] = j;
                        } else if (label_img_pt0[i - 1] > 0) {
                            m = work[label_img_pt1[i + 1] - 1];
                            n = work[label_img_pt0[i - 1] - 1];
                            if (m > n) {
                                label_pixel = n;
                                for (k = 0; k < wk_max; ++k) {
                                    if (work[k] != m) continue;
                                    work[k] = n;
                                }
                            } else if (m < n) {
                                label_pixel = m;
                                for (k = 0; k < wk_max; ++k) {
                                    if (work[k] != n) continue;
                                    work[k] = m;
                                }
                            } else {
                                label_pixel = m;
                            }
                            work2_pt = work2[label_pixel - 1];
                            work2_pt[0] = work2_pt[0] + 1;
                            work2_pt[1] = work2_pt[1] + i;
                            work2_pt[2] = work2_pt[2] + j;
                        } else {
                            label_pixel = label_img_pt1[i + 1];
                            work2_pt = work2[label_pixel - 1];
                            work2_pt[0] = work2_pt[0] + 1;
                            work2_pt[1] = work2_pt[1] + i;
                            work2_pt[2] = work2_pt[2] + j;
                            if (work2_pt[3] > i) {
                                work2_pt[3] = i;
                            }
                            work2_pt[6] = j;
                        }
                    } else if (label_img_pt1[i - 1] > 0) {
                        label_pixel = label_img_pt1[i - 1];
                        work2_pt = work2[label_pixel - 1];
                        work2_pt[0] = work2_pt[0] + 1;
                        work2_pt[1] = work2_pt[1] + i;
                        work2_pt[2] = work2_pt[2] + j;
                        if (work2_pt[4] < i) {
                            work2_pt[4] = i;
                        }
                        work2_pt[6] = j;
                    } else if (label_img_pt0[i - 1] > 0) {
                        label_pixel = label_img_pt0[i - 1];
                        work2_pt = work2[label_pixel - 1];
                        work2_pt[0] = work2_pt[0] + 1;
                        work2_pt[1] = work2_pt[1] + i;
                        work2_pt[2] = work2_pt[2] + j;
                        if (work2_pt[4] < i) {
                            work2_pt[4] = i;
                        }
                    } else {
                        this.work_holder.reserv(wk_max);
                        work[++wk_max - 1] = wk_max;
                        label_pixel = wk_max;
                        work2_pt = work2[wk_max - 1];
                        work2_pt[0] = 1;
                        work2_pt[1] = i;
                        work2_pt[2] = j;
                        work2_pt[3] = i;
                        work2_pt[4] = i;
                        work2_pt[5] = j;
                        work2_pt[6] = j;
                    }
                    label_img_pt0[i] = label_pixel;
                    continue;
                }
                label_img_pt0[i] = 0;
            }
        }
        j = 1;
        for (i = 0; i < wk_max; ++i) {
            work[i] = work[i] == i + 1 ? j++ : work[work[i] - 1];
        }
        int wlabel_num = j - 1;
        if (wlabel_num == 0) {
            return;
        }
        this.label_holder.init(wlabel_num, lxsize, lysize);
        NyARLabel[] labels = this.label_holder.labels;
        for (i = 0; i < wk_max; ++i) {
            label_pt = labels[work[i] - 1];
            work2_pt = work2[i];
            label_pt.area += work2_pt[0];
            label_pt.pos_x += (double)work2_pt[1];
            label_pt.pos_y += (double)work2_pt[2];
            if (label_pt.clip0 > work2_pt[3]) {
                label_pt.clip0 = work2_pt[3];
            }
            if (label_pt.clip1 < work2_pt[4]) {
                label_pt.clip1 = work2_pt[4];
            }
            if (label_pt.clip2 > work2_pt[5]) {
                label_pt.clip2 = work2_pt[5];
            }
            if (label_pt.clip3 >= work2_pt[6]) continue;
            label_pt.clip3 = work2_pt[6];
        }
        for (i = 0; i < wlabel_num; ++i) {
            label_pt = labels[i];
            label_pt.pos_x /= (double)label_pt.area;
            label_pt.pos_y /= (double)label_pt.area;
        }
        this.label_num = wlabel_num;
    }
}

