/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.NyARParam;
import jp.nyatla.nyartoolkit.core.NyARSquare;
import jp.nyatla.nyartoolkit.core.NyARTransMat;
import jp.nyatla.nyartoolkit.core.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.NyARTransRot;
import jp.nyatla.nyartoolkit.core.NyARTransRot_O3;

public class NyARTransMat_O2
implements NyARTransMat {
    private static final int AR_FITTING_TO_IDEAL = 0;
    private static final int AR_FITTING_TO_INPUT = 1;
    private static final int arFittingMode = 1;
    private static final int AR_GET_TRANS_MAT_MAX_LOOP_COUNT = 5;
    private static final double AR_GET_TRANS_MAT_MAX_FIT_ERROR = 1.0;
    private static final double AR_GET_TRANS_CONT_MAT_MAX_FIT_ERROR = 1.0;
    private static final int P_MAX = 10;
    private static final int NUMBER_OF_VERTEX = 4;
    private final NyARTransRot transrot;
    private final double[] center = new double[]{0.0, 0.0};
    private final NyARParam param;
    private final NyARMat result_mat = new NyARMat(3, 4);
    private final double[][] wk_transMat_pos3d = new double[10][3];
    private final double[][] wk_transMat_ppos2d = new double[4][2];
    private final double[][] wk_transMat_ppos3d = new double[4][2];
    private final double[] wk_transMat_off = new double[3];
    private final double[][] wk_transMat_pos2d = new double[10][2];
    private final NyARMat wk_transMat_mat_b = new NyARMat(3, 8);
    private final NyARMat wk_transMat_mat_d = new NyARMat(3, 3);
    private final double[] wk_transMat_mat_trans = new double[3];
    private final NyARTransMatResult wk_transMatContinue_result = new NyARTransMatResult();
    private final NyARMat wk_arGetTransMat3_mat_a = new NyARMat(8, 3);
    private final NyARMat wk_arGetTransMatSub_mat_c = new NyARMat(8, 1);
    private final NyARMat wk_arGetTransMatSub_mat_e = new NyARMat(3, 1);
    private final NyARMat wk_arGetTransMatSub_mat_f = new NyARMat(3, 1);

    public NyARTransMat_O2(NyARParam i_param) throws NyARException {
        this.param = i_param;
        this.transrot = new NyARTransRot_O3(i_param, 4);
    }

    @Override
    public void setCenter(double i_x, double i_y) {
        this.center[0] = i_x;
        this.center[1] = i_x;
    }

    public NyARMat getTransformationMatrix() {
        return this.result_mat;
    }

    private final void init_transMat_ppos(NyARSquare square, int i_direction, double i_width, double[][] o_ppos2d, double[][] o_ppos3d) {
        o_ppos2d[0][0] = square.sqvertex[(4 - i_direction) % 4][0];
        o_ppos2d[0][1] = square.sqvertex[(4 - i_direction) % 4][1];
        o_ppos2d[1][0] = square.sqvertex[(5 - i_direction) % 4][0];
        o_ppos2d[1][1] = square.sqvertex[(5 - i_direction) % 4][1];
        o_ppos2d[2][0] = square.sqvertex[(6 - i_direction) % 4][0];
        o_ppos2d[2][1] = square.sqvertex[(6 - i_direction) % 4][1];
        o_ppos2d[3][0] = square.sqvertex[(7 - i_direction) % 4][0];
        o_ppos2d[3][1] = square.sqvertex[(7 - i_direction) % 4][1];
        double c0 = this.center[0];
        double c1 = this.center[1];
        double w_2 = i_width / 2.0;
        o_ppos3d[0][0] = c0 - w_2;
        o_ppos3d[0][1] = c1 + w_2;
        o_ppos3d[1][0] = c0 + w_2;
        o_ppos3d[1][1] = c1 + w_2;
        o_ppos3d[2][0] = c0 + w_2;
        o_ppos3d[2][1] = c1 - w_2;
        o_ppos3d[3][0] = c0 - w_2;
        o_ppos3d[3][1] = c1 - w_2;
    }

    @Override
    public double transMat(NyARSquare square, int i_direction, double width, NyARTransMatResult o_result_conv) throws NyARException {
        double[][] ppos2d = this.wk_transMat_ppos2d;
        double[][] ppos3d = this.wk_transMat_ppos3d;
        double[] off = this.wk_transMat_off;
        double[][] pos3d = this.wk_transMat_pos3d;
        this.transrot.initRot(square, i_direction);
        this.init_transMat_ppos(square, i_direction, width, ppos2d, ppos3d);
        double[][] pos2d = this.wk_transMat_pos2d;
        NyARMat mat_b = this.wk_transMat_mat_b;
        NyARMat mat_d = this.wk_transMat_mat_d;
        this.arGetTransMat3_initTransMat(ppos3d, ppos2d, pos2d, pos3d, off, mat_b, mat_d);
        double err = -1.0;
        double[] trans = this.wk_transMat_mat_trans;
        for (int i = 0; i < 5 && !((err = this.arGetTransMatSub(pos2d, pos3d, mat_b, mat_d, trans)) < 1.0); ++i) {
        }
        o_result_conv.updateMatrixValue(this.transrot, off, trans);
        return err;
    }

    @Override
    public double transMatContinue(NyARSquare i_square, int i_direction, double i_width, NyARTransMatResult io_result_conv) throws NyARException {
        if (!io_result_conv.hasValue()) {
            return this.transMat(i_square, i_direction, i_width, io_result_conv);
        }
        double[][] ppos2d = this.wk_transMat_ppos2d;
        double[][] ppos3d = this.wk_transMat_ppos3d;
        double[] off = this.wk_transMat_off;
        double[][] pos3d = this.wk_transMat_pos3d;
        this.transrot.initRotByPrevResult(io_result_conv);
        this.init_transMat_ppos(i_square, i_direction, i_width, ppos2d, ppos3d);
        double[][] pos2d = this.wk_transMat_pos2d;
        NyARMat mat_b = this.wk_transMat_mat_b;
        NyARMat mat_d = this.wk_transMat_mat_d;
        this.arGetTransMat3_initTransMat(ppos3d, ppos2d, pos2d, pos3d, off, mat_b, mat_d);
        double err2 = -1.0;
        double err1 = -1.0;
        double[] trans = this.wk_transMat_mat_trans;
        for (int i = 0; i < 5 && !((err1 = this.arGetTransMatSub(pos2d, pos3d, mat_b, mat_d, trans)) < 1.0); ++i) {
        }
        io_result_conv.updateMatrixValue(this.transrot, off, trans);
        if (err1 > 1.0) {
            NyARTransMatResult result2 = this.wk_transMatContinue_result;
            this.transrot.initRot(i_square, i_direction);
            err2 = this.transMat(i_square, i_direction, i_width, result2);
            if (err2 < err1) {
                io_result_conv.copyFrom(result2);
                err1 = err2;
            }
        }
        return err1;
    }

    private final void arGetTransMat3_initTransMat(double[][] i_ppos3d, double[][] i_ppos2d, double[][] o_pos2d, double[][] o_pos3d, double[] o_off, NyARMat o_mat_b, NyARMat o_mat_d) throws NyARException {
        int i;
        double pmax2 = -1.0E10;
        double pmax1 = -1.0E10;
        double pmax0 = -1.0E10;
        double pmin2 = 1.0E10;
        double pmin1 = 1.0E10;
        double pmin0 = 1.0E10;
        for (i = 0; i < 4; ++i) {
            if (i_ppos3d[i][0] > pmax0) {
                pmax0 = i_ppos3d[i][0];
            }
            if (i_ppos3d[i][0] < pmin0) {
                pmin0 = i_ppos3d[i][0];
            }
            if (i_ppos3d[i][1] > pmax1) {
                pmax1 = i_ppos3d[i][1];
            }
            if (!(i_ppos3d[i][1] < pmin1)) continue;
            pmin1 = i_ppos3d[i][1];
        }
        o_off[0] = -(pmax0 + pmin0) / 2.0;
        o_off[1] = -(pmax1 + pmin1) / 2.0;
        o_off[2] = -(pmax2 + pmin2) / 2.0;
        for (i = 0; i < 4; ++i) {
            double[] o_pos3d_pt = o_pos3d[i];
            double[] i_pos_pd_pt = i_ppos3d[i];
            o_pos3d_pt[0] = i_pos_pd_pt[0] + o_off[0];
            o_pos3d_pt[1] = i_pos_pd_pt[1] + o_off[1];
            o_pos3d_pt[2] = 0.0;
        }
        this.param.ideal2ObservBatch(i_ppos2d, o_pos2d, 4);
        double[] cpara = this.param.get34Array();
        NyARMat mat_a = this.wk_arGetTransMat3_mat_a;
        double[][] a_array = mat_a.getArray();
        double[][] b_array = o_mat_b.getArray();
        for (i = 0; i < 4; ++i) {
            int x2 = i * 2;
            double d = cpara[0];
            b_array[0][x2] = d;
            a_array[x2][0] = d;
            double d2 = cpara[1];
            b_array[1][x2] = d2;
            a_array[x2][1] = d2;
            double d3 = cpara[2] - o_pos2d[i][0];
            b_array[2][x2] = d3;
            a_array[x2][2] = d3;
            b_array[0][x2 + 1] = 0.0;
            a_array[x2 + 1][0] = 0.0;
            double d4 = cpara[5];
            b_array[1][x2 + 1] = d4;
            a_array[x2 + 1][1] = d4;
            double d5 = cpara[6] - o_pos2d[i][1];
            b_array[2][x2 + 1] = d5;
            a_array[x2 + 1][2] = d5;
        }
        o_mat_d.matrixMul(o_mat_b, mat_a);
        o_mat_d.matrixSelfInv();
    }

    private final double arGetTransMatSub(double[][] i_ppos2d, double[][] i_pos3d, NyARMat i_mat_b, NyARMat i_mat_d, double[] o_trans) throws NyARException {
        double wz;
        double wy;
        double wx;
        double[] i_pos3d_pt;
        int x2;
        int i;
        double[] cpara = this.param.get34Array();
        NyARMat mat_c = this.wk_arGetTransMatSub_mat_c;
        double[][] c_array = mat_c.getArray();
        double[] rot = this.transrot.getArray();
        for (i = 0; i < 4; ++i) {
            x2 = i * 2;
            i_pos3d_pt = i_pos3d[i];
            wx = rot[0] * i_pos3d_pt[0] + rot[1] * i_pos3d_pt[1] + rot[2] * i_pos3d_pt[2];
            wy = rot[3] * i_pos3d_pt[0] + rot[4] * i_pos3d_pt[1] + rot[5] * i_pos3d_pt[2];
            wz = rot[6] * i_pos3d_pt[0] + rot[7] * i_pos3d_pt[1] + rot[8] * i_pos3d_pt[2];
            c_array[x2][0] = wz * i_ppos2d[i][0] - cpara[0] * wx - cpara[1] * wy - cpara[2] * wz;
            c_array[x2 + 1][0] = wz * i_ppos2d[i][1] - cpara[5] * wy - cpara[6] * wz;
        }
        NyARMat mat_e = this.wk_arGetTransMatSub_mat_e;
        NyARMat mat_f = this.wk_arGetTransMatSub_mat_f;
        double[][] f_array = mat_f.getArray();
        mat_e.matrixMul(i_mat_b, mat_c);
        mat_f.matrixMul(i_mat_d, mat_e);
        o_trans[0] = f_array[0][0];
        o_trans[1] = f_array[1][0];
        o_trans[2] = f_array[2][0];
        double ret = this.transrot.modifyMatrix(o_trans, i_pos3d, i_ppos2d);
        for (i = 0; i < 4; ++i) {
            x2 = i * 2;
            i_pos3d_pt = i_pos3d[i];
            wx = rot[0] * i_pos3d_pt[0] + rot[1] * i_pos3d_pt[1] + rot[2] * i_pos3d_pt[2];
            wy = rot[3] * i_pos3d_pt[0] + rot[4] * i_pos3d_pt[1] + rot[5] * i_pos3d_pt[2];
            wz = rot[6] * i_pos3d_pt[0] + rot[7] * i_pos3d_pt[1] + rot[8] * i_pos3d_pt[2];
            c_array[x2][0] = wz * i_ppos2d[i][0] - cpara[0] * wx - cpara[1] * wy - cpara[2] * wz;
            c_array[x2 + 1][0] = wz * i_ppos2d[i][1] - cpara[5] * wy - cpara[6] * wz;
        }
        mat_e.matrixMul(i_mat_b, mat_c);
        mat_f.matrixMul(i_mat_d, mat_e);
        o_trans[0] = f_array[0][0];
        o_trans[1] = f_array[1][0];
        o_trans[2] = f_array[2][0];
        ret = this.transrot.modifyMatrix(o_trans, i_pos3d, i_ppos2d);
        return ret;
    }
}

