/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable.LibInstaller;
import jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable.Misc;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LibInstallerImpl
implements LibInstaller {
    private List<File> installed;
    private File installDir;

    public void deleteAll(File file) {
        if (file.isDirectory()) {
            File[] fs;
            for (File file2 : fs = file.listFiles()) {
                this.deleteAll(file2);
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean installLibs(File dir, Class<?> c) throws IOException {
        File[] dllFiles;
        this.deleteAll(dir);
        boolean flag = true;
        this.installed = new ArrayList<File>();
        ArrayList<File> dlls = new ArrayList<File>();
        this.installDir = new File(dir, UUID.randomUUID().toString());
        this.installDir.mkdirs();
        System.out.println(this.installDir.getAbsolutePath());
        File rootDir = Misc.getRootDirAccess(c, this.installDir);
        if (rootDir == null) {
            throw new FileNotFoundException();
        }
        System.out.println("Root Dir is : " + rootDir);
        File osXml = new File(rootDir, "os.xml");
        File nativeDir = new File(rootDir, "native");
        if (osXml.exists()) {
            System.out.println("os.xml is found at : " + osXml);
            String osName = System.getProperty("os.name");
            String osArch = System.getProperty("os.arch");
            Document doc = null;
            try {
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(osXml);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            NodeList nl = doc.getElementsByTagName("library");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (!(n instanceof Element)) continue;
                Element e = (Element)n;
                if (!osName.trim().startsWith(e.getAttribute("name").trim()) || !osArch.trim().startsWith(e.getAttribute("arch").trim())) continue;
                nativeDir = new File(rootDir, e.getAttribute("path").trim());
            }
        }
        if ((dllFiles = nativeDir.listFiles()) == null) {
            return false;
        }
        for (File file : dllFiles) {
            System.out.println("Copying DLL: " + file.getAbsolutePath());
            File outFile = new File(this.installDir, file.getName());
            outFile.deleteOnExit();
            if (!outFile.exists()) {
                try {
                    FileOutputStream os = new FileOutputStream(outFile);
                    try {
                        FileInputStream is = new FileInputStream(file);
                        try {
                            int rdsz;
                            byte[] buf = new byte[4096];
                            while ((rdsz = ((InputStream)is).read(buf)) >= 0) {
                                ((OutputStream)os).write(buf, 0, rdsz);
                            }
                        }
                        finally {
                            ((InputStream)is).close();
                        }
                    }
                    finally {
                        os.flush();
                        ((OutputStream)os).close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    outFile = null;
                }
            }
            System.out.println("Writing File Succeed: " + outFile.getAbsolutePath());
            dlls.add(outFile);
            this.installed.add(outFile);
        }
        ArrayList<String> loadseq = new ArrayList<String>();
        ArrayList<File> loaded = new ArrayList<File>();
        while (dlls.size() > 0) {
            for (File file : dlls) {
                try {
                    System.out.println("Loading Library: " + file.getName());
                    System.load(file.getAbsolutePath());
                    System.out.println("Load Library: " + file.getName());
                    loaded.add(file);
                    loadseq.add(file.getName());
                }
                catch (UnsatisfiedLinkError e) {
                    System.out.println(e);
                }
            }
            if (loaded.size() <= 0) {
                System.out.println("ERROR: some dll instration have been failed.");
                System.out.println(dlls);
                flag = false;
                break;
            }
            dlls.removeAll(loaded);
            loaded.clear();
        }
        System.out.println("--------dll load sequence---------");
        for (String n : loadseq) {
            System.out.println(n);
        }
        return flag;
    }

    @Override
    public File getInstallDir() {
        return this.installDir;
    }
}

