/*
 * ̃vOnyar_NyARTransmat̑gݍݗłB̂܂܃RpC
 * ܂B
 */
/*
 *  simpleLite.c
 *
 *  Some code to demonstrate use of gsub_lite's argl*() functions.
 *  Shows the correct GLUT usage to read a video frame (in the idle callback)
 *  and to draw it (in the display callback).
 *
 *  Press '?' while running for help on available key commands.
 *
 *  Copyright (c) 2001-2006 Philip Lamb (PRL) phil@eden.net.nz. All rights reserved.
 *
 *	Rev		Date		Who		Changes
 *	1.0.0	20040302	PRL		Initial version, simple test animation using GLUT.
 *	1.0.1	20040721	PRL		Correctly sets window size; supports arVideoDispOption().
 *
 * 
 * This file is part of ARToolKit.
 * 
 * ARToolKit is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * ARToolKit is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with ARToolKit; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */



// ============================================================================
//	Includes
// ============================================================================

#include <stdio.h>
#include <stdlib.h>					// malloc(), free()
#ifdef __APPLE__
#  include <GLUT/glut.h>
#else
#  include <GL/glut.h>
#endif
#include <AR/config.h>
#include <AR/video.h>
#include <AR/param.h>			// arParamDisp()
#include <AR/ar.h>
#include <AR/gsub_lite.h>

/**********ǉ**********/
#include "AR/nyar_NyARTransMat.h"
// ============================================================================
//	Constants
// ============================================================================

#define VIEW_SCALEFACTOR		0.025		// 1.0 ARToolKit unit becomes 0.025 of my OpenGL units.
#define VIEW_DISTANCE_MIN		0.1			// Objects closer to the camera than this will not be displayed.
#define VIEW_DISTANCE_MAX		100.0		// Objects further away from the camera than this will not be displayed.

// ============================================================================
//	Global variables
// ============================================================================

// Preferences.
static int prefWindowed = TRUE;
static int prefWidth = 320;					// Fullscreen mode width.
static int prefHeight = 240;				// Fullscreen mode height.
static int prefDepth = 32;					// Fullscreen mode bit depth.
static int prefRefresh = 0;					// Fullscreen mode refresh rate. Set to 0 to use default rate.

// Image acquisition.
static ARUint8		*gARTImage = NULL;

// Marker detection.
static int			gARTThreshhold = 100;
static long			gCallCountMarkerDetect = 0;

// Transformation matrix retrieval.
static double		gPatt_width     = 80.0;	// Per-marker, but we are using only 1 marker.
static double		gPatt_centre[2] = {0.0, 0.0}; // Per-marker, but we are using only 1 marker.
static double		gPatt_trans[3][4];		// Per-marker, but we are using only 1 marker.
static int			gPatt_found = FALSE;	// Per-marker, but we are using only 1 marker.
static int			gPatt_id;				// Per-marker, but we are using only 1 marker.

// Drawing.
static ARParam		gARTCparam;
static ARGL_CONTEXT_SETTINGS_REF gArglSettings = NULL;
static int gDrawRotate = FALSE;
static float gDrawRotateAngle = 0;			// For use in drawing.
static char* raw_img_buffer;
// ============================================================================
//	Functions
// ============================================================================
#include "stdio.h"

/**********ǉ**********/
nyar_NyARTransMat_O2_t* nya;

int main()
{
	ARMarkerInfo    *marker_info;					// Pointer to array holding the details of detected markers.
    int             marker_num;						// Count of number of markers detected.
	FILE* fp;
	int i;
	int a,b;
	const char *patt_name  = "..\\Data\\patt.hiro";
	{
		char* v;
		int int_ver;
		int_ver=arGetVersion(&v);
		printf("%d:%s",int_ver,v);
	}
	{
		ARParam p,p2;
		arLoadPatt("..\\Data\\patt.hiro");
		arParamLoad("..\\Data\\camera_para.dat",1,&p);
		arParamChangeSize(&p,320,240,&p2);
		arInitCparam(&p2);
		/**********ǉ**********/
		nya=nyar_NyARTransMat_O2_create(&p2);
	};
	raw_img_buffer=malloc(400*1024);
	fp=fopen("..\\Data\\320x240ABGR.raw","rb");
	fread(raw_img_buffer,1,400*1024,fp);
	fclose(fp);
	if (arDetectMarkerLite(raw_img_buffer, 100, &marker_info, &marker_num) < 0) {
		exit(-1);
	}
	a=GetTickCount();
	for(i=0;i<600;i++){
	if (arDetectMarkerLite(raw_img_buffer, 100, &marker_info, &marker_num) < 0) {
		exit(-1);
	}
		/********************/
		nyar_NyARTransMat_O2_transMat(nya,&(marker_info[0]), gPatt_centre, gPatt_width, gPatt_trans);
//		arGetTransMat(&(marker_info[0]), gPatt_centre, gPatt_width, gPatt_trans);
	}



	printf(">>%d",GetTickCount()-a);
	scanf("%u",&a);
	/**********ǉ**********/
	nyar_NyARTransMat_O2_free(nya);
	return 0;
}

