/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.utils.j2se;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.labeling.NyARLabelingImage;
import jp.nyatla.nyartoolkit.core.labeling.NyARLabelingLabel;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.types.NyARIntPoint;
import jp.nyatla.nyartoolkit.core.types.NyARIntRect;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;
import jp.nyatla.nyartoolkit.core.types.stack.NyARIntPointStack;
import jp.nyatla.nyartoolkit.core.types.stack.NyARIntRectStack;

public class LabelingBufferdImage
extends BufferedImage {
    public static final int COLOR_125_COLOR = 0;
    public static final int COLOR_256_MONO = 1;
    public static final int COLOR_64_MONO = 2;
    public static final int COLOR_32_MONO = 3;
    public static final int COLOR_16_MONO = 4;
    public static final int COLOR_8_MONO = 5;
    private int[] _rgb_table_125 = new int[125];

    public LabelingBufferdImage(int i_width, int i_height) {
        super(i_width, i_height, 5);
        int i = 0;
        while (i < 5) {
            int i2 = 0;
            while (i2 < 5) {
                int i3 = 0;
                while (i3 < 5) {
                    this._rgb_table_125[(i * 5 + i2) * 5 + i3] = (i * 63 << 8 | i2 * 63) << 8 | i3 * 63;
                    ++i3;
                }
                ++i2;
            }
            ++i;
        }
    }

    public void drawImage(NyARGrayscaleRaster i_raster) throws NyARException {
        assert (i_raster.getBufferReader().getBufferType() == 262145);
        int w = this.getWidth();
        int h = this.getHeight();
        NyARIntSize size = i_raster.getSize();
        if (size.h > h || size.w > w) {
            throw new NyARException();
        }
        int[] limg = (int[])i_raster.getBufferReader().getBuffer();
        int i = 0;
        while (i < h) {
            int i2 = 0;
            while (i2 < w) {
                this.setRGB(i2, i, limg[i * w + i2]);
                ++i2;
            }
            ++i;
        }
    }

    public void drawImage(NyARBinRaster i_raster) throws NyARException {
        assert (i_raster.getBufferReader().getBufferType() == 262146);
        int w = this.getWidth();
        int h = this.getHeight();
        NyARIntSize size = i_raster.getSize();
        if (size.h > h || size.w > w) {
            throw new NyARException();
        }
        int[] limg = (int[])i_raster.getBufferReader().getBuffer();
        int i = 0;
        while (i < h) {
            int i2 = 0;
            while (i2 < w) {
                this.setRGB(i2, i, limg[i * w + i2] > 0 ? 255 : 0);
                ++i2;
            }
            ++i;
        }
    }

    public void drawLabel(NyARLabelingImage i_image) throws NyARException {
        int w = this.getWidth();
        int h = this.getHeight();
        NyARIntSize size = i_image.getSize();
        if (size.h > h || size.w > w) {
            throw new NyARException();
        }
        int[] index_array = i_image.getIndexArray();
        int[] limg = (int[])i_image.getBufferReader().getBuffer();
        int i = 0;
        while (i < h) {
            int i2 = 0;
            while (i2 < w) {
                int t = limg[i * w + i2] - 1;
                t = t < 0 ? 0 : index_array[t];
                this.setRGB(i2, i, this._rgb_table_125[t % this._rgb_table_125.length]);
                ++i2;
            }
            ++i;
        }
    }

    public void overlayData(NyARLabelingLabel i_label) {
        Graphics g = this.getGraphics();
        g.setColor(Color.red);
        g.drawRect(i_label.clip_l, i_label.clip_t, i_label.clip_r - i_label.clip_l, i_label.clip_b - i_label.clip_t);
    }

    public void overlayData(NyARIntPointStack i_stack) {
        int count = i_stack.getLength();
        NyARIntPoint[] items = (NyARIntPoint[])i_stack.getArray();
        Graphics g = this.getGraphics();
        int i = 0;
        while (i < count) {
            int x = items[i].x;
            int y = items[i].y;
            g.setColor(Color.red);
            g.drawLine(x - 5, y, x + 5, y);
            g.drawLine(x, y + 5, x, y - 5);
            ++i;
        }
    }

    public void overlayData(NyARIntRectStack i_stack) {
        Color[] c = new Color[]{Color.cyan, Color.red, Color.green};
        int count = i_stack.getLength();
        NyARIntRect[] items = (NyARIntRect[])i_stack.getArray();
        Graphics g = this.getGraphics();
        int i = 0;
        while (i < count) {
            int x = items[i].x;
            int y = items[i].y;
            g.setColor(c[i % 1]);
            g.drawRect(x, y, items[i].w, items[i].h);
            ++i;
        }
    }
}

