/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core.transmat.rotmatrix;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.param.NyARPerspectiveProjectionMatrix;
import jp.nyatla.nyartoolkit.core.transmat.NyARTransMatResult;
import jp.nyatla.nyartoolkit.core.transmat.rotmatrix.NyARRotMatrix;
import jp.nyatla.nyartoolkit.core.transmat.rotmatrix.NyARRotVector;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint2d;
import jp.nyatla.nyartoolkit.core.types.NyARDoublePoint3d;
import jp.nyatla.nyartoolkit.core.types.NyARLinear;

public class NyARRotMatrix_ARToolKit
extends NyARRotMatrix {
    private final NyARRotVector __initRot_vec1;
    private final NyARRotVector __initRot_vec2;
    protected final NyARDoublePoint3d _angle;

    public NyARRotMatrix_ARToolKit(NyARPerspectiveProjectionMatrix i_matrix) throws NyARException {
        this.__initRot_vec1 = new NyARRotVector(i_matrix);
        this.__initRot_vec2 = new NyARRotVector(i_matrix);
        this._angle = new NyARDoublePoint3d();
    }

    public final void initRotByPrevResult(NyARTransMatResult i_prev_result) {
        this.m00 = i_prev_result.m00;
        this.m01 = i_prev_result.m01;
        this.m02 = i_prev_result.m02;
        this.m10 = i_prev_result.m10;
        this.m11 = i_prev_result.m11;
        this.m12 = i_prev_result.m12;
        this.m20 = i_prev_result.m20;
        this.m21 = i_prev_result.m21;
        this.m22 = i_prev_result.m22;
    }

    public final void initRotBySquare(NyARLinear[] i_linear, NyARDoublePoint2d[] i_sqvertex) throws NyARException {
        NyARRotVector vec1 = this.__initRot_vec1;
        NyARRotVector vec2 = this.__initRot_vec2;
        vec1.exteriorProductFromLinear(i_linear[0], i_linear[2]);
        vec1.checkVectorByVertex(i_sqvertex[0], i_sqvertex[1]);
        vec2.exteriorProductFromLinear(i_linear[1], i_linear[3]);
        vec2.checkVectorByVertex(i_sqvertex[3], i_sqvertex[0]);
        NyARRotVector.checkRotation(vec1, vec2);
        this.m00 = vec1.v1;
        this.m10 = vec1.v2;
        this.m20 = vec1.v3;
        this.m01 = vec2.v1;
        this.m11 = vec2.v2;
        this.m21 = vec2.v3;
        double w02 = vec1.v2 * vec2.v3 - vec1.v3 * vec2.v2;
        double w12 = vec1.v3 * vec2.v1 - vec1.v1 * vec2.v3;
        double w22 = vec1.v1 * vec2.v2 - vec1.v2 * vec2.v1;
        double w = Math.sqrt(w02 * w02 + w12 * w12 + w22 * w22);
        this.m02 = w02 / w;
        this.m12 = w12 / w;
        this.m22 = w22 / w;
        this.updateAngleFromMatrix();
    }

    public final NyARDoublePoint3d refAngle() {
        return this._angle;
    }

    public void setAngle(double i_x, double i_y, double i_z) {
        double sina = Math.sin(i_x);
        double cosa = Math.cos(i_x);
        double sinb = Math.sin(i_y);
        double cosb = Math.cos(i_y);
        double sinc = Math.sin(i_z);
        double cosc = Math.cos(i_z);
        double CACA = cosa * cosa;
        double SASA = sina * sina;
        double SACA = sina * cosa;
        double SASB = sina * sinb;
        double CASB = cosa * sinb;
        double SACACB = SACA * cosb;
        this.m00 = CACA * cosb * cosc + SASA * cosc + SACACB * sinc - SACA * sinc;
        this.m01 = -CACA * cosb * sinc - SASA * sinc + SACACB * cosc - SACA * cosc;
        this.m02 = CASB;
        this.m10 = SACACB * cosc - SACA * cosc + SASA * cosb * sinc + CACA * sinc;
        this.m11 = -SACACB * sinc + SACA * sinc + SASA * cosb * cosc + CACA * cosc;
        this.m12 = SASB;
        this.m20 = -CASB * cosc - SASB * sinc;
        this.m21 = CASB * sinc - SASB * cosc;
        this.m22 = cosb;
        this.updateAngleFromMatrix();
    }

    public final void getPoint3d(NyARDoublePoint3d i_in_point, NyARDoublePoint3d i_out_point) {
        double x = i_in_point.x;
        double y = i_in_point.y;
        double z = i_in_point.z;
        i_out_point.x = this.m00 * x + this.m01 * y + this.m02 * z;
        i_out_point.y = this.m10 * x + this.m11 * y + this.m12 * z;
        i_out_point.z = this.m20 * x + this.m21 * y + this.m22 * z;
    }

    public final void getPoint3dBatch(NyARDoublePoint3d[] i_in_point, NyARDoublePoint3d[] i_out_point, int i_number_of_vertex) {
        int i = i_number_of_vertex - 1;
        while (i >= 0) {
            NyARDoublePoint3d out_ptr = i_out_point[i];
            NyARDoublePoint3d in_ptr = i_in_point[i];
            double x = in_ptr.x;
            double y = in_ptr.y;
            double z = in_ptr.z;
            out_ptr.x = this.m00 * x + this.m01 * y + this.m02 * z;
            out_ptr.y = this.m10 * x + this.m11 * y + this.m12 * z;
            out_ptr.z = this.m20 * x + this.m21 * y + this.m22 * z;
            --i;
        }
    }

    private final void updateAngleFromMatrix() {
        double c;
        double a;
        double cosb = this.m22 > 1.0 ? 1.0 : (this.m22 < -1.0 ? -1.0 : this.m22);
        double b = Math.acos(cosb);
        double sinb = Math.sin(b);
        double rot02 = this.m02;
        double rot12 = this.m12;
        if (b >= 1.0E-6 || b <= -1.0E-6) {
            double cosa = rot02 / sinb;
            double sina = rot12 / sinb;
            if (cosa > 1.0) {
                cosa = 1.0;
                sina = 0.0;
            }
            if (cosa < -1.0) {
                cosa = -1.0;
                sina = 0.0;
            }
            if (sina > 1.0) {
                sina = 1.0;
                cosa = 0.0;
            }
            if (sina < -1.0) {
                sina = -1.0;
                cosa = 0.0;
            }
            a = Math.acos(cosa);
            if (sina < 0.0) {
                a = -a;
            }
            double tmp = rot02 * rot02 + rot12 * rot12;
            double sinc = (this.m21 * rot02 - this.m20 * rot12) / tmp;
            double cosc = -(rot02 * this.m20 + rot12 * this.m21) / tmp;
            if (cosc > 1.0) {
                cosc = 1.0;
                sinc = 0.0;
            }
            if (cosc < -1.0) {
                cosc = -1.0;
                sinc = 0.0;
            }
            if (sinc > 1.0) {
                sinc = 1.0;
                cosc = 0.0;
            }
            if (sinc < -1.0) {
                sinc = -1.0;
                cosc = 0.0;
            }
            c = Math.acos(cosc);
            if (sinc < 0.0) {
                c = -c;
            }
        } else {
            b = 0.0;
            a = 0.0;
            cosb = 1.0;
            double cosa = 1.0;
            sinb = 0.0;
            double sina = 0.0;
            double cosc = this.m00;
            double sinc = this.m01;
            if (cosc > 1.0) {
                cosc = 1.0;
                sinc = 0.0;
            }
            if (cosc < -1.0) {
                cosc = -1.0;
                sinc = 0.0;
            }
            if (sinc > 1.0) {
                sinc = 1.0;
                cosc = 0.0;
            }
            if (sinc < -1.0) {
                sinc = -1.0;
                cosc = 0.0;
            }
            c = Math.acos(cosc);
            if (sinc < 0.0) {
                c = -c;
            }
        }
        this._angle.x = a;
        this._angle.y = b;
        this._angle.z = c;
    }
}

