/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core2.rasterfilter.gs2bin;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.raster.NyARBinRaster;
import jp.nyatla.nyartoolkit.core.raster.NyARGrayscaleRaster;
import jp.nyatla.nyartoolkit.core.rasterfilter.INyARRasterFilter_GsToBin;
import jp.nyatla.nyartoolkit.core.types.NyARIntSize;

public class NyARRasterFilter_AreaAverage
implements INyARRasterFilter_GsToBin {
    private int _area = 8;

    public void doFilter(NyARGrayscaleRaster i_input, NyARBinRaster i_output) throws NyARException {
        int area;
        NyARIntSize size = i_output.getSize();
        int[] out_buf = (int[])i_output.getBufferReader().getBuffer();
        int[] in_buf = (int[])i_input.getBufferReader().getBuffer();
        assert (i_input.getSize().isEqualSize(i_output.getSize()));
        assert (size.h % 8 == 0 && size.w % 8 == 0);
        int y1 = area = this._area;
        int x1 = area;
        int y2 = size.h - area;
        int x2 = size.w - area;
        int y = y1;
        while (y < y2) {
            int nn = 0;
            int sum = 0;
            int yy = y - area;
            while (yy < y + area + 1) {
                int xx = x1 - area;
                while (xx < x1 + area) {
                    sum += in_buf[yy * size.w + xx];
                    ++nn;
                    ++xx;
                }
                ++yy;
            }
            boolean first = true;
            int x = area;
            while (x < x2) {
                if (!first) {
                    int yy2 = y - area;
                    while (yy2 < y + area) {
                        sum += in_buf[yy2 * size.w + x + area];
                        sum -= in_buf[yy2 * size.w + x - area];
                        ++yy2;
                    }
                }
                first = false;
                int th = sum / nn;
                int g = in_buf[y * size.w + x];
                out_buf[y * size.w + x] = th < g ? 1 : 0;
                ++x;
            }
            ++y;
        }
    }
}

