/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.ca.web;

import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import jp.nyx.common.db.Setting;
import jp.nyx.common.util.PkiUtility;
import jp.nyx.common.web.DefaultController;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.ModelAndView;

public class CaController
extends DefaultController {
    public static final String PARAM_KEY_OFFSET = "offset";
    public static final String PARAM_KEY_LIMIT = "limit";
    public static final String PARAM_KEY_ROWCOUNT = "rowcount";
    public static final String PARAM_KEY_PAGECOUNT = "pagecount";
    public static final String PARAM_KEY_REMOTEUSER = "remote_user";
    protected PkiUtility pkiUtil = new PkiUtility();
    private static final String ATTR_CADATASOURCE = "caDataSource";
    private boolean caDsInit = false;

    private void caInit(ModelAndView mv) throws Exception {
        ApplicationContext appCtx = this.getApplicationContext();
        Map<String, Setting> nyx = this.getNyx(mv);
        DataSource caDs = (DataSource)appCtx.getBean(ATTR_CADATASOURCE);
        Method m = caDs.getClass().getMethod("setDriverClassName", String.class);
        m.invoke((Object)caDs, nyx.get("ca_jdbc_driver").getValue());
        m = caDs.getClass().getMethod("setUrl", String.class);
        m.invoke((Object)caDs, nyx.get("ca_jdbc_url").getValue());
        m = caDs.getClass().getMethod("setUsername", String.class);
        m.invoke((Object)caDs, nyx.get("ca_jdbc_user").getValue());
        m = caDs.getClass().getMethod("setPassword", String.class);
        m.invoke((Object)caDs, nyx.get("ca_jdbc_pass").getValue());
        this.caDsInit = true;
    }

    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mv = super.handleRequestInternal(request, response);
        if (!this.caDsInit) {
            this.caInit(mv);
        }
        Map<String, Object> res = this.getRes(mv);
        res.put(PARAM_KEY_OFFSET, this.webUtil.numUtil.parseInt(request.getParameter(PARAM_KEY_OFFSET), 0));
        res.put(PARAM_KEY_LIMIT, this.webUtil.numUtil.parseInt(request.getParameter(PARAM_KEY_LIMIT), 20));
        res.put(PARAM_KEY_ROWCOUNT, this.webUtil.numUtil.parseInt(request.getParameter(PARAM_KEY_ROWCOUNT), 0));
        res.put(PARAM_KEY_PAGECOUNT, 0);
        res.put(PARAM_KEY_REMOTEUSER, request.getAttribute("nyxUserId"));
        return mv;
    }

    protected int getOffset(ModelAndView mv) {
        Map<String, Object> res = this.getRes(mv);
        return (Integer)res.get(PARAM_KEY_OFFSET);
    }

    protected int getLimit(ModelAndView mv) {
        Map<String, Object> res = this.getRes(mv);
        return (Integer)res.get(PARAM_KEY_LIMIT);
    }

    protected String getRemoteUser(ModelAndView mv) {
        Map<String, Object> res = this.getRes(mv);
        return (String)res.get(PARAM_KEY_REMOTEUSER);
    }

    protected int getRowcount(ModelAndView mv) {
        Map<String, Object> res = this.getRes(mv);
        return (Integer)res.get(PARAM_KEY_ROWCOUNT);
    }

    protected void setRowcount(ModelAndView mv, int rowcount) {
        Map<String, Object> res = this.getRes(mv);
        res.put(PARAM_KEY_ROWCOUNT, rowcount);
        int limit = (Integer)res.get(PARAM_KEY_LIMIT);
        int pc = rowcount / limit;
        pc = rowcount % limit > 0 ? pc + 1 : pc;
        res.put(PARAM_KEY_PAGECOUNT, pc);
    }
}

