/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.portal.web;

import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.nyx.NyxException;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.AccessFactory;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.PersonalAccess;
import jp.nyx.common.db.model.User;
import jp.nyx.common.util.DigestUtility;
import jp.nyx.common.web.DefaultController;
import jp.nyx.pkg.sso.db.SsoManager;
import jp.nyx.pkg.sso.db.model.PortalMenu;
import jp.nyx.pkg.sso.db.model.PortalNotice;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.ModelAndView;

public class PortalController
extends DefaultController {
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mv = super.handleRequestInternal(request, response);
        WebApplicationContext appCtx = super.getWebApplicationContext();
        SsoManager ssoManager = (SsoManager)appCtx.getBean("ssoManager");
        String uid = (String)request.getAttribute("nyxUserId");
        if ("passdo".equals(request.getParameter("mode"))) {
            Map<String, String> status = this.getStatus(mv);
            try {
                User user = ssoManager.loadUser(uid);
                String password = request.getParameter("password");
                String password2 = request.getParameter("password2");
                if (this.webUtil.textUtil.isEmpty(password)) {
                    status.put("status", "Failed");
                    status.put("message", "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                    return mv;
                }
                if (!this.webUtil.textUtil.isEquals(password, password2)) {
                    status.put("status", "Failed");
                    status.put("message", "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002");
                    return mv;
                }
                user.setPasswd(DigestUtility.md5((String)password));
                user.setUpdateUid(uid);
                User self = ssoManager.loadUser(uid);
                Access access = AccessFactory.createAccess(PersonalAccess.class);
                access.setSelf(self);
                access.setAdmin(this.isAdminUser(request));
                access.setPersonalAdmin(this.isPersonalAdminUser(request));
                ssoManager.saveUser(user, access);
                status.put("status", "Successed");
                status.put("message", "\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u5909\u66f4\u3055\u308c\u307e\u3057\u305f\u3002<br/>\u30dd\u30fc\u30bf\u30eb\u306e\u518d\u8aad\u8fbc\u3092\u884c\u306a\u3044\u307e\u3059\u3002<br/>\u518d\u30ed\u30b0\u30a4\u30f3\u306e\u30c0\u30a4\u30a2\u30ed\u30b0\u304c\u8868\u793a\u3055\u308c\u307e\u3059\u306e\u3067\u3001<br/>\u65b0\u3057\u3044\u30d1\u30b9\u30ef\u30fc\u30c9\u3067\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u304f\u3060\u3055\u3044\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u30d1\u30b9\u30ef\u30fc\u30c9\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u30d1\u30b9\u30ef\u30fc\u30c9\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
            return mv;
        }
        if ("version".equals(request.getParameter("mode"))) {
            return mv;
        }
        if ("logoff".equals(request.getParameter("mode"))) {
            HttpSession session = request.getSession(true);
            session.setAttribute("logoff", (Object)true);
            return mv;
        }
        if (ssoManager.isInit((ApplicationContext)appCtx)) {
            PortalMenu m;
            List<PortalMenu> menu = ssoManager.loadPortalMenu(uid, "visible");
            mv.getModel().put("menu", menu);
            mv.getModel().put("self", ssoManager.loadUser(uid));
            Map<String, Setting> nyx = this.getNyx(mv);
            String sp = nyx.get("base_app_url").getValue() + "/blank.html";
            if (menu.size() > 0 && !this.webUtil.textUtil.isEmpty((m = menu.get(0)).getSitePath())) {
                sp = m.getSitePath();
            }
            mv.getModel().put("startPath", sp);
            Timestamp tim = new Timestamp(this.webUtil.calUtil.getCalendar().getTimeInMillis());
            List<PortalNotice> notice = ssoManager.loadPortalNotice(uid, "one", tim, tim, "visible");
            int notice_size = notice.size();
            if (notice_size > 0) {
                PortalNotice n;
                int i;
                for (i = 0; i < notice_size; ++i) {
                    n = notice.get(i);
                    n.setDisplayMode("hidden");
                    n.setReceiveDate(tim);
                }
                ssoManager.savePortalNotice(notice, false);
                for (i = 0; i < notice_size; ++i) {
                    n = notice.get(i);
                    n.setMessage(this.webUtil.textUtil.encodeEntityRef(n.getMessage()));
                    n.setMessage(this.webUtil.textUtil.encodeBR(n.getMessage()));
                    n.setTitle(this.webUtil.textUtil.encodeEntityRef(n.getTitle()));
                }
                PortalNotice n2 = notice.get(notice_size - 1);
                if (n2 != null && !this.webUtil.textUtil.isEmpty(n2.getUrl())) {
                    mv.getModel().put("startPath", n2.getUrl());
                }
            }
            mv.getModel().put("notice", notice);
            mv.getModel().put("notice_size", notice_size);
        }
        return mv;
    }
}

