/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.nyx.common.db.BaseDao;
import jp.nyx.common.db.DefaultParameterizedRowMapper;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.Context;
import jp.nyx.common.db.model.DefaultModel;
import jp.nyx.common.db.model.Ext;
import jp.nyx.pkg.sso.db.SsoUserDao;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SsoContextDao
extends BaseDao {
    private SsoUserDao ssoUserDao;
    private ParameterizedRowMapper<Context> contextMapper;
    private NyxManager nyxManager;

    protected SsoContextDao(NyxManager nyxManager, SimpleJdbcTemplate simpleTemplate, NamedParameterJdbcTemplate namedTemplate, SsoUserDao ssoUserDao) {
        super(simpleTemplate, namedTemplate);
        this.nyxManager = nyxManager;
        this.ssoUserDao = ssoUserDao;
        this.contextMapper = new DefaultParameterizedRowMapper<Context>(){

            public Context mapRow(ResultSet rs, int rowNum) throws SQLException {
                Context ret = new Context();
                this.mapRow((DefaultModel)ret, rs, rowNum);
                ret.setContextCode(rs.getInt("context_code"));
                ret.setContextType(rs.getString("context_type"));
                ret.setContextName(rs.getString("context_name"));
                return ret;
            }
        };
    }

    protected NyxManager getNyxManager() {
        return this.nyxManager;
    }

    public Context loadContext(int contextCode) {
        List ext = this.simpleTemplate.query("select * from m_context_ext where context_code=?", this.extMapper, new Object[]{contextCode});
        Context ret = (Context)this.simpleTemplate.queryForObject("select * from m_context where context_code=?", this.contextMapper, new Object[]{contextCode});
        Map map = ret.getExt();
        for (Ext ex : ext) {
            map.put(ex.getFieldName(), ex);
        }
        List userIds = this.loadString("user_id", "m_context_user", "context_code", contextCode);
        Set user = ret.getUser();
        for (String i : userIds) {
            user.add(this.ssoUserDao.loadUser(i));
        }
        List ownerIds = this.loadString("user_id", "m_context_owner", "context_code", contextCode);
        Set owner = ret.getOwner();
        for (String i : ownerIds) {
            owner.add(this.ssoUserDao.loadUser(i));
        }
        return ret;
    }

    public List<Context> loadContext(int offset, int limit, ConditionList conditions) throws SQLException {
        List ids = this.loadInt("context_code", "m_context", conditions, offset, limit, "context_name");
        if (ids.size() <= 0) {
            return new ArrayList<Context>();
        }
        ArrayList<Context> ret = new ArrayList<Context>();
        for (Integer i : ids) {
            ret.add(this.loadContext(i));
        }
        return ret;
    }

    public void saveContext(Context context) throws SQLException {
        int r = this.namedTemplate.update("update m_context set context_type=:contextType ,context_name=:contextName where context_code=:contextCode", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)context));
        if (r > 0) {
            this.saveExt("m_context_ext", "context_code", context.getContextCode(), context.getExt());
            this.saveRef("m_context_owner", "user_id", "userId", "context_code", context.getContextCode(), context.getOwner());
            this.saveRef("m_context_user", "user_id", "userId", "context_code", context.getContextCode(), context.getUser());
            this.saveSsoDefault("m_context", "context_code", context.getContextCode(), (DefaultModel)context);
            return;
        }
        int seq = this.nextSequence("m_context_context_code_seq");
        context.setContextCode(seq);
        this.namedTemplate.update("insert into m_context(context_code, context_type, context_name) values(:contextCode, :contextType, :contextName)", (SqlParameterSource)new BeanPropertySqlParameterSource((Object)context));
        this.saveExt("m_context_ext", "context_code", context.getContextCode(), context.getExt());
        this.saveRef("m_context_owner", "user_id", "userId", "context_code", context.getContextCode(), context.getOwner());
        this.saveRef("m_context_user", "user_id", "userId", "context_code", context.getContextCode(), context.getUser());
        this.saveSsoDefault("m_context", "context_code", context.getContextCode(), (DefaultModel)context);
    }

    public void deleteContext(int context_code) {
        this.simpleTemplate.update("delete from m_context_ext where context_code=?", new Object[]{context_code});
        this.simpleTemplate.update("delete from m_context_owner where context_code=?", new Object[]{context_code});
        this.simpleTemplate.update("delete from m_context_user where context_code=?", new Object[]{context_code});
        this.simpleTemplate.update("delete from m_context where context_code=?", new Object[]{context_code});
    }
}

