/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.db;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.nyx.NyxException;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.Auth;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.Context;
import jp.nyx.common.db.model.PortalSetting;
import jp.nyx.common.db.model.Site;
import jp.nyx.common.db.model.User;
import jp.nyx.common.util.WebUtility;
import jp.nyx.pkg.sso.db.SsoDao;
import jp.nyx.pkg.sso.db.model.Log;
import jp.nyx.pkg.sso.db.model.PortalMenu;
import jp.nyx.pkg.sso.db.model.PortalNotice;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;

public class SsoManager {
    public final WebUtility webUtil = new WebUtility();
    private static final String ATTR_SSOTRANSACTION = "ssoTransactionManager";
    private NyxManager nyxManager;
    private SsoDao dao;
    private ApplicationContext appCtx = null;

    public void setSsoDao(SsoDao dao) {
        this.dao = dao;
    }

    public void setNyxManager(NyxManager nyxManager) {
        this.nyxManager = nyxManager;
    }

    private TransactionStatus begin() {
        DataSourceTransactionManager ssoTxManager = (DataSourceTransactionManager)this.appCtx.getBean(ATTR_SSOTRANSACTION);
        TransactionStatus tx = ssoTxManager.getTransaction((TransactionDefinition)new DefaultTransactionAttribute(0));
        if (!tx.isNewTransaction()) {
            ssoTxManager.rollback(tx);
        }
        return tx;
    }

    private void rollback(TransactionStatus tx) {
        DataSourceTransactionManager ssoTxManager = (DataSourceTransactionManager)this.appCtx.getBean(ATTR_SSOTRANSACTION);
        ssoTxManager.rollback(tx);
    }

    private void commit(TransactionStatus tx) {
        DataSourceTransactionManager ssoTxManager = (DataSourceTransactionManager)this.appCtx.getBean(ATTR_SSOTRANSACTION);
        ssoTxManager.commit(tx);
    }

    public boolean isInit() {
        return this.dao.isInit();
    }

    public boolean isInit(ApplicationContext appCtx) {
        this.appCtx = appCtx;
        return this.dao.isInit();
    }

    public void init(ApplicationContext appCtx) throws NyxException {
        ResourceBundle conf;
        this.appCtx = appCtx;
        if (this.isInit()) {
            return;
        }
        TransactionStatus tx = this.begin();
        try {
            conf = this.nyxManager.isPostgreSQL() ? PropertyResourceBundle.getBundle("jp.nyx.pkg.sso.db.sso_sql_pg") : PropertyResourceBundle.getBundle("jp.nyx.pkg.sso.db.sso_sql_derby");
        }
        catch (SQLException e) {
            throw new NyxException((Throwable)e);
        }
        String[] sql = conf.getString("sql").split(";");
        try {
            for (int i = 0; i < sql.length; ++i) {
                if (sql[i] == null || sql[i].trim().length() <= 0) continue;
                this.dao.update(sql[i].replaceAll("<semicolon>", ";"));
            }
            this.commit(tx);
        }
        catch (Exception e) {
            this.rollback(tx);
            NyxException ne = new NyxException((Throwable)e);
            throw ne;
        }
    }

    public int loadDataCount(String table, ConditionList conditions) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            int ret = this.dao.loadDataCount(table, conditions);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<String> loadString(String coloum, String table, String whereKey, int whereVal) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<String> ret = this.dao.loadString(coloum, table, whereKey, whereVal);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<Integer> loadInt(String coloum, String table, String whereKey, int whereVal) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<Integer> ret = this.dao.loadInt(coloum, table, whereKey, whereVal);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public int loadMaxInt(String coloum, String table) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            int ret = this.dao.loadMaxInt(coloum, table);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<User> loadUser(int offset, int limit) throws NyxException {
        return this.loadUser(offset, limit, null);
    }

    public List<User> loadUser(int offset, int limit, ConditionList conditions) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<User> ret = this.dao.ssoUserDao.loadUser(offset, limit, conditions);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<String> loadUserIds(ConditionList conditions) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<String> ret = this.dao.ssoUserDao.loadUserIds(conditions);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public User loadUser(String user_id) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            User ret = this.dao.ssoUserDao.loadUser(user_id);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public User loadUser(String user_id, Access access) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            User ret = this.dao.ssoUserDao.loadUser(user_id, access);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<Context> loadContext(int offset, int limit) throws NyxException {
        return this.loadContext(offset, limit, null);
    }

    public List<Context> loadContext(int offset, int limit, ConditionList conditions) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<Context> ret = this.dao.ssoContextDao.loadContext(offset, limit, conditions);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public Context loadContext(int context_code) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            Context ret = this.dao.ssoContextDao.loadContext(context_code);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<Site> loadSite(int offset, int limit) throws NyxException {
        return this.loadSite(offset, limit, null);
    }

    public List<Site> loadSite(int offset, int limit, ConditionList conditions) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<Site> ret = this.dao.ssoSiteDao.loadSite(offset, limit, conditions);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public Site loadSite(int site_id) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            Site ret = this.dao.ssoSiteDao.loadSite(site_id);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<Auth> loadAuth(int offset, int limit) throws NyxException {
        return this.loadAuth(offset, limit, null);
    }

    public List<Auth> loadAuth(int offset, int limit, ConditionList conditions) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<Auth> ret = this.dao.ssoAuthDao.loadAuth(offset, limit, conditions);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public Auth loadAuth(int auth_id) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            Auth ret = this.dao.ssoAuthDao.loadAuth(auth_id);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<PortalMenu> loadPortalMenu(String userId) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<PortalMenu> ret = this.dao.ssoPortalMenuDao.loadPortalMenu(userId);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<PortalMenu> loadPortalMenu(String userId, String displayMode) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<PortalMenu> ret = this.dao.ssoPortalMenuDao.loadPortalMenu(userId, displayMode);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<PortalSetting> loadPortalSetting(int offset, int limit) throws NyxException {
        return this.loadPortalSetting(offset, limit, null);
    }

    public List<PortalSetting> loadPortalSetting(int offset, int limit, ConditionList conditions) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<PortalSetting> ret = this.dao.ssoPortalSettingDao.loadPortalSetting(offset, limit, conditions);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public PortalSetting loadPortalSetting(String name) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            PortalSetting ret = this.dao.ssoPortalSettingDao.loadPortalSetting(name);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<PortalNotice> loadPortalNotice(int offset, int limit, ConditionList conditions) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<PortalNotice> ret = this.dao.ssoPortalNoticeDao.loadPortalNotice(offset, limit, conditions);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<Integer> loadPortalNoticeSeq(ConditionList conditions) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<Integer> ret = this.dao.ssoPortalNoticeDao.loadPortalNoticeSeq(conditions);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public PortalNotice loadPortalNotice(int seq) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            PortalNotice ret = this.dao.ssoPortalNoticeDao.loadPortalNotice(seq);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<PortalNotice> loadPortalNotice(String user_id, String display_type, Timestamp display_start, Timestamp display_end, String display_mode) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<PortalNotice> ret = this.dao.ssoPortalNoticeDao.loadPortalNotice(user_id, display_type, display_start, display_end, display_mode);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<Log> loadLog(int offset, int limit) throws NyxException {
        return this.loadLog(offset, limit, null);
    }

    public List<Log> loadLog(int offset, int limit, ConditionList conditions) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<Log> ret = this.dao.ssoLogDao.loadLog(offset, limit, conditions);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public Log loadLog(int seq) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            Log ret = this.dao.ssoLogDao.loadLog(seq);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<Map<String, Object>> loadLogGroup(String coloum, String cntName, String order, int offset, int limit, ConditionList conditions) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<Map<String, Object>> ret = this.dao.ssoLogDao.loadLogGroup(coloum, cntName, order, offset, limit, conditions);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void saveUser(User user, Access access) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoUserDao.saveUser(user, access);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void saveContext(Context context) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoContextDao.saveContext(context);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void saveSite(Site site) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoSiteDao.saveSite(site);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void saveAuth(Auth auth) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoAuthDao.saveAuth(auth);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void savePortalMenu(PortalMenu menu) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoPortalMenuDao.savePortalMenu(menu);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void savePortalMenu(List<PortalMenu> menu) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            for (PortalMenu m : menu) {
                this.dao.ssoPortalMenuDao.savePortalMenu(m);
            }
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void savePortalSetting(PortalSetting setting) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoPortalSettingDao.savePortalSetting(setting);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void savePortalNotice(PortalNotice notice, boolean forceAdd) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoPortalNoticeDao.savePortalNotice(notice, forceAdd);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void savePortalNotice(List<PortalNotice> notice, boolean forceAdd) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            for (PortalNotice m : notice) {
                this.dao.ssoPortalNoticeDao.savePortalNotice(m, forceAdd);
            }
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void saveLog(File logFile) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(logFile));
            Pattern pat = Pattern.compile("\\[(\\p{Graph}+)\\s?\\]\\s([\\d]{4}/[\\d]{2}/[\\d]{2}-[\\d]{2}:[\\d]{2}:[\\d]{2})\\s:\\s([^:]+):([\\d]+)ms\\sType=(\\p{Graph}+)\\sUse=(\\p{Graph}+)\\sUser=(\\p{Graph}+)\\sClient=(\\p{Graph}+)\\sTrigger=\\[(\\p{Alnum}+)\\](\\p{Graph}+)\\sValidSite=(\\p{Graph}+)\\sCause=(\\p{ASCII}+)\\sSession=(\\p{ASCII}+)");
            while ((line = br.readLine()) != null) {
                Log log = new Log();
                Matcher m = pat.matcher(line);
                if (!m.find()) continue;
                log.setLogLevel(m.group(1));
                log.setLogDateString(m.group(2));
                log.setAct(m.group(3));
                log.setActMs(this.webUtil.numUtil.parseInt(m.group(4)));
                log.setAuthType(m.group(5));
                log.setAuthUse(m.group(6));
                log.setAuthUserId(m.group(7));
                log.setClientIp(m.group(8));
                log.setTriggerMethod(m.group(9));
                log.setTriggerUrl(m.group(10));
                log.setValidUrl(m.group(11));
                log.setCause(m.group(12));
                log.setSession(m.group(13));
                this.dao.ssoLogDao.saveLog(log);
            }
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void deleteUser(String user_id, Access access) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoUserDao.deleteUser(user_id, access);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void deleteContext(int context_code) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoContextDao.deleteContext(context_code);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void deleteSite(int site_id) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoSiteDao.deleteSite(site_id);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void deleteAuth(int auth_id) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoAuthDao.deleteAuth(auth_id);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void deletePortalMenu(String user_id) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoPortalMenuDao.deletePortalMenu(user_id);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void deletePortalNotice(Integer seq) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoPortalNoticeDao.deletePortalNotice(seq);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void deletePortalSetting(String name) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoPortalSettingDao.deletePortalSetting(name);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void deleteLog(int seq) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoLogDao.deleteLog(seq);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void deleteLog(Map<String, Setting> nyx) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            Calendar cal = this.webUtil.calUtil.getCalendar();
            cal.add(6, -1 * this.webUtil.numUtil.parseInt(nyx.get("kernel_log_max_day").getValue(), 365));
            this.dao.update("delete from t_log where log_date<'" + this.webUtil.calUtil.formatCalendar(cal, "yyyy/MM/dd") + "'");
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void deleteLog(ConditionList conditions) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.ssoLogDao.deleteLog(conditions);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }
}

