/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.web;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.db.AccessFactory;
import jp.nyx.common.db.model.Condition;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.PersonalAccess;
import jp.nyx.common.db.model.PortalSetting;
import jp.nyx.pkg.sso.db.SsoManager;
import jp.nyx.pkg.sso.web.SsoController;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.ModelAndView;

public class PortalSettingController
extends SsoController {
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView mv = super.handleRequestInternal(request, response);
        SsoManager ssoManager = super.getSsoManager();
        ssoManager.init((ApplicationContext)super.getWebApplicationContext());
        String name_search = request.getParameter("name_search");
        ConditionList cond = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
        if (!this.webUtil.textUtil.isEmpty(name_search)) {
            cond.add((Object)new Condition("name", (Object)("%" + name_search + "%"), "like"));
        }
        this.setRowcount(mv, ssoManager.loadDataCount("m_portal_setting", cond));
        List<PortalSetting> settings = ssoManager.loadPortalSetting(this.getOffset(mv), this.getLimit(mv), cond);
        mv.getModel().put("settings", settings);
        if ("add".equals(request.getParameter("mode"))) {
            PortalSetting setting = new PortalSetting();
            mv.getModel().put("setting", setting);
        } else if ("adddo".equals(request.getParameter("mode"))) {
            Map<String, String> status = this.getStatus(mv);
            try {
                PortalSetting setting = new PortalSetting();
                setting.setRegistUid(this.getRemoteUser(mv));
                setting.setUpdateUid(this.getRemoteUser(mv));
                if (!this.save(setting, request, status)) {
                    return mv;
                }
                ssoManager.savePortalSetting(setting);
                status.put("status", "Successed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u65b0\u898f\u767b\u9332\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("edit".equals(request.getParameter("mode"))) {
            PortalSetting setting = ssoManager.loadPortalSetting(request.getParameter("name"));
            mv.getModel().put("setting", setting);
        } else if ("editdo".equals(request.getParameter("mode"))) {
            Map<String, String> status = this.getStatus(mv);
            try {
                PortalSetting setting = ssoManager.loadPortalSetting(request.getParameter("name"));
                if (!this.save(setting, request, status)) {
                    return mv;
                }
                setting.setUpdateUid(this.getRemoteUser(mv));
                ssoManager.savePortalSetting(setting);
                status.put("status", "Successed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u66f4\u65b0\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else if ("deldo".equals(request.getParameter("mode"))) {
            Map<String, String> status = this.getStatus(mv);
            try {
                ssoManager.deletePortalSetting(request.getParameter("name"));
                status.put("status", "Successed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        }
        return mv;
    }

    private boolean save(PortalSetting setting, HttpServletRequest request, Map<String, String> status) throws NoSuchAlgorithmException, MessagingException, IOException {
        Calendar cal;
        String name = request.getParameter("name");
        String value = request.getParameter("value");
        if (this.webUtil.textUtil.isEmpty(name)) {
            status.put("status", "Failed");
            status.put("message", "\u8a2d\u5b9a\u540d\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        if (this.webUtil.textUtil.isEmpty(value)) {
            status.put("status", "Failed");
            status.put("message", "\u8a2d\u5b9a\u5024\u304c\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            return false;
        }
        setting.setName(name);
        setting.setValue(value);
        String verify_startdate = request.getParameter("verify_startdate");
        String verify_enddate = request.getParameter("verify_enddate");
        if (!this.webUtil.textUtil.isEmpty(verify_startdate)) {
            try {
                cal = this.webUtil.calUtil.parseCalendar(verify_startdate, "yyyy/MM/dd");
                setting.setVerifyStartdate(new Timestamp(cal.getTimeInMillis()));
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u958b\u59cb\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            setting.setVerifyStartdate(null);
        }
        if (!this.webUtil.textUtil.isEmpty(verify_enddate)) {
            try {
                cal = this.webUtil.calUtil.parseCalendar(verify_enddate, "yyyy/MM/dd");
                setting.setVerifyEnddate(new Timestamp(cal.getTimeInMillis()));
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u5229\u7528\u7d42\u4e86\u65e5\u304c\u6b63\u3057\u304f\u5165\u529b\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return false;
            }
        } else {
            setting.setVerifyEnddate(null);
        }
        setting.setEnable("true".equals(request.getParameter("enable")));
        return true;
    }
}

