/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.db.model;

import java.util.Set;
import jp.nyx.common.db.Access;
import jp.nyx.common.db.model.AccessContext;
import jp.nyx.common.db.model.AccessUser;
import jp.nyx.common.db.model.ContextLink;
import jp.nyx.common.db.model.User;

public class PersonalAccess
implements Access {
    private boolean mask = true;
    private boolean admin = false;
    private boolean personalAdmin = false;
    private User self = null;

    @Override
    public boolean isAdmin() {
        return this.admin;
    }

    @Override
    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    @Override
    public boolean isMask() {
        return this.mask;
    }

    @Override
    public void setMask(boolean mask) {
        this.mask = mask;
    }

    @Override
    public boolean isPersonalAdmin() {
        return this.personalAdmin;
    }

    @Override
    public void setPersonalAdmin(boolean personalAdmin) {
        this.personalAdmin = personalAdmin;
    }

    @Override
    public User getSelf() {
        return this.self;
    }

    @Override
    public void setSelf(User self) {
        this.self = self;
    }

    @Override
    public boolean canAccess(User target) {
        if (this.self == null) {
            throw new NullPointerException("self user is null.");
        }
        if (this.self.equals(target) || this.personalAdmin || !this.mask) {
            return true;
        }
        Set<AccessUser> tau = target.getAccessUser();
        Set<AccessContext> tac = target.getAccessContext();
        for (AccessUser tu : tau) {
            if (!this.self.getUserId().equals(tu.getVerifyUserId())) continue;
            return true;
        }
        for (AccessContext tc : tac) {
            Set<ContextLink> cl = this.self.getContextLink();
            for (ContextLink c : cl) {
                if (c.getContextCode() != tc.getVerifyContextCode()) continue;
                return true;
            }
        }
        return false;
    }
}

