/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.log;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class NyxXmlFormatter
extends Formatter {
    public static final DateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");

    @Override
    public String format(LogRecord recode) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(recode.getMillis());
        StringBuffer buf = new StringBuffer();
        String msg = recode.getMessage();
        Throwable throwable = recode.getThrown();
        buf.append("<log level=\"");
        buf.append(recode.getLevel().toString());
        buf.append("\" class=\"");
        buf.append(recode.getSourceClassName());
        if (msg != null) {
            buf.append("\" msg=\"");
            buf.append(msg);
        }
        buf.append("\" method=\"");
        buf.append(recode.getSourceMethodName());
        buf.append("\" date=\"");
        buf.append(format.format(cal.getTime()));
        buf.append("\" thread=\"");
        buf.append(recode.getThreadID());
        if (throwable == null) {
            buf.append("\"/>\n");
        } else {
            buf.append("\">\n\t<throw>");
            this.outThrowable(buf, throwable);
            buf.append("</throw>");
            buf.append("\n</log>\n");
        }
        return buf.toString();
    }

    protected void outThrowable(StringBuffer sb, Throwable th) {
        sb.append(th.getClass().getName());
        sb.append(": ");
        sb.append(th.getMessage());
        sb.append("\n");
        StackTraceElement[] elem = th.getStackTrace();
        for (int i = 0; i < elem.length; ++i) {
            sb.append("\tat ");
            sb.append(elem[i].getClassName());
            sb.append('.');
            sb.append(elem[i].getMethodName());
            sb.append('(');
            sb.append(elem[i].getFileName());
            sb.append(':');
            sb.append(elem[i].getLineNumber());
            sb.append(")\n");
        }
        Throwable cause = th.getCause();
        if (cause == null) {
            return;
        }
        sb.append("Caused by: ");
        this.outThrowable(sb, cause);
    }
}

