/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.rpc.client;

import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcSunHttpTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;

public class NyxXmlClient {
    public static final String NYX_XML_HEADER = "NyxAuthGate";
    private int connectionTimeout = 30000;
    private int retryTimeout = 30000;

    public Object xmlrpc(HttpServletRequest request, String nyxHeader, String method, Object[] param) throws JspException {
        try {
            Pattern pattern = Pattern.compile("([^=]+)=([^,]+)");
            Matcher matcher = pattern.matcher(nyxHeader);
            String xmlrpc = "http://localhost/portal/xmlrpc";
            while (matcher.find()) {
                String k = matcher.group(1);
                String v = matcher.group(2);
                if (!"xmlrpc".equals(k)) continue;
                xmlrpc = v;
            }
            XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
            config.setServerURL(new URL(xmlrpc));
            config.setEnabledForExtensions(true);
            config.setConnectionTimeout(this.connectionTimeout);
            config.setReplyTimeout(this.retryTimeout);
            XmlRpcClient client = new XmlRpcClient();
            client.setTransportFactory((XmlRpcTransportFactory)new XmlRpcSunHttpTransportFactory(client));
            client.setConfig((XmlRpcClientConfig)config);
            return client.execute(method, param);
        }
        catch (Exception e) {
            JspException je = new JspException(e.getMessage());
            je.initCause((Throwable)e);
            throw je;
        }
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getRetryTimeout() {
        return this.retryTimeout;
    }

    public void setRetryTimeout(int retryTimeout) {
        this.retryTimeout = retryTimeout;
    }
}

