/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.util.spec;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import jp.nyx.NyxException;
import jp.nyx.common.util.spec.PkgClassUtil;

public abstract class SignedObject {
    protected abstract void init(Serializable var1, PrivateKey var2, X509Certificate var3, Signature var4) throws NyxException;

    public abstract Serializable getSource() throws NyxException;

    public abstract boolean verify() throws NyxException;

    public abstract void serializ(OutputStream var1) throws NyxException;

    public abstract void parse(InputStream var1) throws NyxException;

    public abstract X509Certificate getX509Certificate() throws NyxException;

    public static SignedObject newSignedObject(ObjectType objectType, Serializable source, PrivateKey signingKey, X509Certificate x509Certificate, Signature sign) throws NyxException {
        SignedObject sigObj = objectType.newInstance();
        sigObj.init(source, signingKey, x509Certificate, sign);
        return sigObj;
    }

    public static enum ObjectType {
        SIMPLE("jp.nyx.common.pkg.spec.SimpleSignedObject"),
        XML("jp.nyx.common.pkg.spec.XmlSignedObject");

        private String clazz;

        private ObjectType(String clazz) {
            this.clazz = clazz;
        }

        SignedObject newInstance() throws NyxException {
            try {
                return (SignedObject)PkgClassUtil.newInstance(this.clazz);
            }
            catch (Exception e) {
                throw new NyxException(e);
            }
        }
    }
}

