/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.swc.db;

import java.util.List;
import java.util.Map;
import jp.nyx.NyxException;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.util.WebUtility;
import jp.nyx.pkg.swc.db.SwcDao;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;

public class SwcManager {
    public final WebUtility webUtil = new WebUtility();
    public static final String BEAN_TRANSACTION = "swcTransactionManager";
    public static final String BEAN_MANAGER = "swcManager";
    public static final String BEAN_DATASOURCE = "swcDataSource";
    private SwcDao dao;
    private ApplicationContext appCtx = null;

    public void setSwcDao(SwcDao dao) {
        this.dao = dao;
    }

    public void init(ApplicationContext appCtx) {
        this.appCtx = appCtx;
    }

    public TransactionStatus begin() {
        DataSourceTransactionManager swcTxManager = (DataSourceTransactionManager)this.appCtx.getBean(BEAN_TRANSACTION);
        TransactionStatus tx = swcTxManager.getTransaction((TransactionDefinition)new DefaultTransactionAttribute(3));
        if (!tx.isNewTransaction()) {
            swcTxManager.rollback(tx);
            System.out.println("#begin() to rollback");
        }
        return tx;
    }

    public void rollback(TransactionStatus tx) {
        if (tx.isCompleted()) {
            return;
        }
        DataSourceTransactionManager swcTxManager = (DataSourceTransactionManager)this.appCtx.getBean(BEAN_TRANSACTION);
        swcTxManager.rollback(tx);
    }

    public void commit(TransactionStatus tx) {
        DataSourceTransactionManager swcTxManager = (DataSourceTransactionManager)this.appCtx.getBean(BEAN_TRANSACTION);
        swcTxManager.commit(tx);
    }

    public boolean isInit(String checkSql) {
        return this.dao.isInit(checkSql);
    }

    public void init(String initSqls, String checkSql) throws NyxException {
        if (this.isInit(checkSql)) {
            return;
        }
        TransactionStatus tx = this.begin();
        String[] sql = initSqls.split(";");
        try {
            for (int i = 0; i < sql.length; ++i) {
                if (sql[i] == null || sql[i].trim().length() <= 0) continue;
                this.dao.update(sql[i].replaceAll("[\r\n\t]", " "));
            }
            this.commit(tx);
        }
        catch (Exception e) {
            this.rollback(tx);
            NyxException ne = new NyxException((Throwable)e);
            throw ne;
        }
    }

    public List<Map<String, Object>> loadList(String macroSql, ConditionList conditions, int offset, int limit, String orderColoum) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<Map<String, Object>> ret = this.dao.loadList(macroSql, conditions, offset, limit, orderColoum);
            this.commit(tx);
            return ret;
        }
        catch (Exception e) {
            this.rollback(tx);
            NyxException ne = new NyxException((Throwable)e);
            throw ne;
        }
    }

    public Map<String, Object> loadMap(String macroSql, ConditionList conditions, int offset, int limit, String orderColoum) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            Map<String, Object> ret = this.dao.loadMap(macroSql, conditions, offset, limit, orderColoum);
            this.commit(tx);
            return ret;
        }
        catch (Exception e) {
            this.rollback(tx);
            NyxException ne = new NyxException((Throwable)e);
            throw ne;
        }
    }

    public List<Map<String, Object>> loadList(String macroSql, Object ... params) {
        return this.dao.loadList(macroSql, params);
    }

    public Map<String, Object> loadMap(String macroSql, Object ... params) {
        return this.dao.loadMap(macroSql, params);
    }

    public int update(String macroSql, Object ... params) {
        return this.dao.update(macroSql, params);
    }

    public ApplicationContext getAppCtx() {
        return this.appCtx;
    }
}

