/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetStringParser;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1SetParser;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.BEROctetStringGenerator;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfoParser;
import org.bouncycastle.asn1.cms.SignedDataParser;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSContentInfoParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.x509.NoSuchStoreException;
import org.bouncycastle.x509.X509Store;

public class CMSSignedDataParser
extends CMSContentInfoParser {
    private static CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    private SignedDataParser _signedData;
    private CMSTypedStream _signedContent;
    private Map _digests;
    private CertStore _certStore;
    private SignerInformationStore _signerInfoStore;
    private X509Store _attributeStore;
    private ASN1Set _certSet;
    private ASN1Set _crlSet;
    private boolean _isCertCrlParsed;
    private X509Store _certificateStore;
    private X509Store _crlStore;

    public CMSSignedDataParser(byte[] byArray) throws CMSException {
        this(new ByteArrayInputStream(byArray));
    }

    public CMSSignedDataParser(CMSTypedStream cMSTypedStream, byte[] byArray) throws CMSException {
        this(cMSTypedStream, new ByteArrayInputStream(byArray));
    }

    public CMSSignedDataParser(InputStream inputStream) throws CMSException {
        this(null, inputStream);
    }

    public CMSSignedDataParser(CMSTypedStream cMSTypedStream, InputStream inputStream) throws CMSException {
        super(inputStream);
        try {
            Object object;
            AlgorithmIdentifier algorithmIdentifier;
            DEREncodable dEREncodable;
            this._signedContent = cMSTypedStream;
            this._signedData = SignedDataParser.getInstance((Object)this._contentInfo.getContent(16));
            this._digests = new HashMap();
            ASN1SetParser aSN1SetParser = this._signedData.getDigestAlgorithms();
            while ((dEREncodable = aSN1SetParser.readObject()) != null) {
                algorithmIdentifier = AlgorithmIdentifier.getInstance((Object)dEREncodable.getDERObject());
                try {
                    object = CMSSignedHelper.INSTANCE.getDigestAlgName(algorithmIdentifier.getObjectId().toString());
                    MessageDigest messageDigest = MessageDigest.getInstance((String)object);
                    this._digests.put(object, messageDigest);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            }
            if (this._signedContent == null) {
                algorithmIdentifier = this._signedData.getEncapContentInfo();
                object = (ASN1OctetStringParser)algorithmIdentifier.getContent(4);
                if (object != null) {
                    this._signedContent = new CMSTypedStream(algorithmIdentifier.getContentType().getId(), object.getOctetStream());
                }
            } else {
                algorithmIdentifier = (ASN1OctetStringParser)this._signedData.getEncapContentInfo().getContent(4);
                if (algorithmIdentifier != null) {
                    object = algorithmIdentifier.getOctetStream();
                    while (((InputStream)object).read() >= 0) {
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new CMSException("io exception: " + iOException.getMessage(), iOException);
        }
        if (this._digests.isEmpty()) {
            throw new CMSException("no digests could be created for message.");
        }
    }

    public int getVersion() {
        return this._signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() throws CMSException {
        if (this._signerInfoStore == null) {
            this.populateCertCrlSets();
            ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
            HashMap hashMap = new HashMap();
            for (Object object : this._digests.keySet()) {
                hashMap.put(object, ((MessageDigest)this._digests.get(object)).digest());
            }
            try {
                DEREncodable dEREncodable;
                Object object;
                object = this._signedData.getSignerInfos();
                while ((dEREncodable = object.readObject()) != null) {
                    SignerInfo signerInfo = SignerInfo.getInstance((Object)dEREncodable.getDERObject());
                    String string = CMSSignedHelper.INSTANCE.getDigestAlgName(signerInfo.getDigestAlgorithm().getObjectId().getId());
                    byte[] byArray = (byte[])hashMap.get(string);
                    arrayList.add(new SignerInformation(signerInfo, new DERObjectIdentifier(this._signedContent.getContentType()), null, byArray));
                }
            }
            catch (IOException iOException) {
                throw new CMSException("io exception: " + iOException.getMessage(), iOException);
            }
            this._signerInfoStore = new SignerInformationStore(arrayList);
        }
        return this._signerInfoStore;
    }

    public X509Store getAttributeCertificates(String string, String string2) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        if (this._attributeStore == null) {
            this.populateCertCrlSets();
            this._attributeStore = HELPER.createAttributeStore(string, string2, this._certSet);
        }
        return this._attributeStore;
    }

    public X509Store getCertificates(String string, String string2) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        if (this._certificateStore == null) {
            this.populateCertCrlSets();
            this._certificateStore = HELPER.createCertificateStore(string, string2, this._certSet);
        }
        return this._certificateStore;
    }

    public X509Store getCRLs(String string, String string2) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        if (this._crlStore == null) {
            this.populateCertCrlSets();
            this._crlStore = HELPER.createCRLsStore(string, string2, this._crlSet);
        }
        return this._crlStore;
    }

    public CertStore getCertificatesAndCRLs(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        if (this._certStore == null) {
            this.populateCertCrlSets();
            this._certStore = HELPER.createCertStore(string, string2, this._certSet, this._crlSet);
        }
        return this._certStore;
    }

    private void populateCertCrlSets() throws CMSException {
        if (this._isCertCrlParsed) {
            return;
        }
        this._isCertCrlParsed = true;
        try {
            ASN1SetParser aSN1SetParser;
            ASN1SetParser aSN1SetParser2 = this._signedData.getCertificates();
            if (aSN1SetParser2 != null) {
                this._certSet = ASN1Set.getInstance((Object)aSN1SetParser2.getDERObject());
            }
            if ((aSN1SetParser = this._signedData.getCrls()) != null) {
                this._crlSet = ASN1Set.getInstance((Object)aSN1SetParser.getDERObject());
            }
        }
        catch (IOException iOException) {
            throw new CMSException("problem parsing cert/crl sets", iOException);
        }
    }

    public CMSTypedStream getSignedContent() {
        if (this._signedContent != null) {
            InputStream inputStream = this._signedContent.getContentStream();
            Iterator iterator = this._digests.values().iterator();
            while (iterator.hasNext()) {
                inputStream = new DigestInputStream(inputStream, (MessageDigest)iterator.next());
            }
            return new CMSTypedStream(this._signedContent.getContentType(), inputStream);
        }
        return null;
    }

    public static OutputStream replaceSigners(InputStream inputStream, SignerInformationStore signerInformationStore, OutputStream outputStream) throws CMSException, IOException {
        Object object;
        Object object2;
        Object object3;
        ASN1SetParser aSN1SetParser;
        AlgorithmIdentifier algorithmIdentifier;
        SignerInformation signerInformation2;
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(inputStream, CMSUtils.getMaximumMemory());
        ContentInfoParser contentInfoParser = new ContentInfoParser((ASN1SequenceParser)aSN1StreamParser.readObject());
        SignedDataParser signedDataParser = SignedDataParser.getInstance((Object)contentInfoParser.getContent(16));
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject((DEREncodable)CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject((DEREncodable)signedDataParser.getVersion());
        signedDataParser.getDigestAlgorithms().getDERObject();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (SignerInformation signerInformation2 : signerInformationStore.getSigners()) {
            algorithmIdentifier = CMSSignedDataParser.makeAlgId(signerInformation2.getDigestAlgOID(), signerInformation2.getDigestAlgParams());
            aSN1EncodableVector.add((DEREncodable)algorithmIdentifier);
        }
        bERSequenceGenerator2.getRawOutputStream().write(new DERSet((DEREncodableVector)aSN1EncodableVector).getEncoded());
        ContentInfoParser contentInfoParser2 = signedDataParser.getEncapContentInfo();
        signerInformation2 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        signerInformation2.addObject((DEREncodable)contentInfoParser2.getContentType());
        algorithmIdentifier = (ASN1OctetStringParser)contentInfoParser2.getContent(4);
        if (algorithmIdentifier != null) {
            int n;
            aSN1SetParser = new BEROctetStringGenerator(signerInformation2.getRawOutputStream(), 0, true);
            object3 = new byte[4096];
            object2 = new byte[4096];
            object = algorithmIdentifier.getOctetStream();
            OutputStream outputStream2 = aSN1SetParser.getOctetOutputStream((byte[])object2);
            while ((n = ((InputStream)object).read((byte[])object3, 0, ((byte[])object3).length)) >= 0) {
                outputStream2.write((byte[])object3, 0, n);
            }
            outputStream2.close();
        }
        signerInformation2.close();
        aSN1SetParser = signedDataParser.getCertificates();
        if (aSN1SetParser instanceof BERSetParser) {
            bERSequenceGenerator2.getRawOutputStream().write(new BERTaggedObject(false, 0, (DEREncodable)aSN1SetParser.getDERObject()).getEncoded());
        } else if (aSN1SetParser != null) {
            bERSequenceGenerator2.getRawOutputStream().write(new DERTaggedObject(false, 0, (DEREncodable)aSN1SetParser.getDERObject()).getEncoded());
        }
        aSN1SetParser = signedDataParser.getCrls();
        if (aSN1SetParser instanceof BERSetParser) {
            bERSequenceGenerator2.getRawOutputStream().write(new BERTaggedObject(false, 1, (DEREncodable)aSN1SetParser.getDERObject()).getEncoded());
        } else if (aSN1SetParser != null) {
            bERSequenceGenerator2.getRawOutputStream().write(new DERTaggedObject(false, 1, (DEREncodable)aSN1SetParser.getDERObject()).getEncoded());
        }
        object3 = new ASN1EncodableVector();
        object2 = signerInformationStore.getSigners().iterator();
        while (object2.hasNext()) {
            object = (SignerInformation)object2.next();
            object3.add((DEREncodable)((SignerInformation)object).toSignerInfo());
        }
        bERSequenceGenerator2.getRawOutputStream().write(new DERSet((DEREncodableVector)object3).getEncoded());
        bERSequenceGenerator2.close();
        bERSequenceGenerator.close();
        return outputStream;
    }

    public static OutputStream replaceCertificatesAndCRLs(InputStream inputStream, CertStore certStore, OutputStream outputStream) throws CMSException, IOException {
        Object object;
        Object object2;
        ASN1SetParser aSN1SetParser;
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(inputStream, CMSUtils.getMaximumMemory());
        ContentInfoParser contentInfoParser = new ContentInfoParser((ASN1SequenceParser)aSN1StreamParser.readObject());
        SignedDataParser signedDataParser = SignedDataParser.getInstance((Object)contentInfoParser.getContent(16));
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject((DEREncodable)CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject((DEREncodable)signedDataParser.getVersion());
        bERSequenceGenerator2.getRawOutputStream().write(signedDataParser.getDigestAlgorithms().getDERObject().getEncoded());
        ContentInfoParser contentInfoParser2 = signedDataParser.getEncapContentInfo();
        BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject((DEREncodable)contentInfoParser2.getContentType());
        ASN1OctetStringParser aSN1OctetStringParser = (ASN1OctetStringParser)contentInfoParser2.getContent(4);
        if (aSN1OctetStringParser != null) {
            int n;
            aSN1SetParser = new BEROctetStringGenerator(bERSequenceGenerator3.getRawOutputStream(), 0, true);
            object2 = new byte[4096];
            object = new byte[4096];
            InputStream inputStream2 = aSN1OctetStringParser.getOctetStream();
            OutputStream outputStream2 = aSN1SetParser.getOctetOutputStream(object);
            while ((n = inputStream2.read((byte[])object2, 0, ((byte[])object2).length)) >= 0) {
                outputStream2.write((byte[])object2, 0, n);
            }
            outputStream2.close();
        }
        bERSequenceGenerator3.close();
        aSN1SetParser = signedDataParser.getCertificates();
        if (aSN1SetParser != null) {
            aSN1SetParser.getDERObject();
        }
        if ((aSN1SetParser = signedDataParser.getCrls()) != null) {
            aSN1SetParser.getDERObject();
        }
        try {
            object2 = CMSUtils.createBerSetFromList(CMSUtils.getCertificatesFromStore(certStore));
        }
        catch (CertStoreException certStoreException) {
            throw new CMSException("error getting certs from certStore", certStoreException);
        }
        if (object2.size() > 0) {
            bERSequenceGenerator2.getRawOutputStream().write(new DERTaggedObject(false, 0, (DEREncodable)object2).getEncoded());
        }
        try {
            object = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(certStore));
        }
        catch (CertStoreException certStoreException) {
            throw new CMSException("error getting crls from certStore", certStoreException);
        }
        if (object.size() > 0) {
            bERSequenceGenerator2.getRawOutputStream().write(new DERTaggedObject(false, 1, (DEREncodable)object).getEncoded());
        }
        bERSequenceGenerator2.getRawOutputStream().write(signedDataParser.getSignerInfos().getDERObject().getEncoded());
        bERSequenceGenerator2.close();
        bERSequenceGenerator.close();
        return outputStream;
    }

    private static DERObject makeObj(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        return aSN1InputStream.readObject();
    }

    private static AlgorithmIdentifier makeAlgId(String string, byte[] byArray) throws IOException {
        if (byArray != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)CMSSignedDataParser.makeObj(byArray));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)new DERNull());
    }
}

