/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.nyx.NyxException;
import jp.nyx.NyxLicense;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.SettingMap;
import jp.nyx.common.util.PkiUtility;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.postgresql.Driver;
import org.springframework.core.SpringVersion;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class NyxDao
extends JdbcDaoSupport {
    private SimpleJdbcTemplate simpleTemplate;

    protected void initTemplateConfig() {
        super.initTemplateConfig();
        this.simpleTemplate = new SimpleJdbcTemplate((JdbcOperations)this.getJdbcTemplate());
    }

    public int update(String sql) throws SQLException {
        if (NyxException.logger.isDebugEnabled()) {
            NyxException.logger.debug((Object)sql);
        }
        return this.simpleTemplate.update(sql, new Object[0]);
    }

    public boolean isInit() {
        try {
            this.simpleTemplate.queryForList("select * from nyx_setting where 1=0", new Object[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Map<String, Setting> loadSetting() throws SQLException {
        List res = this.simpleTemplate.query("select * from nyx_setting order by parent,name", (ParameterizedRowMapper)new ParameterizedRowMapper<Setting>(){
            private EmbeddedDriver derby = new EmbeddedDriver();
            private Driver pgsql = new Driver();
            private String derby_version = "v" + this.derby.getMajorVersion() + "." + this.derby.getMinorVersion();
            private String pgsql_version = "v" + this.pgsql.getMajorVersion() + "." + this.pgsql.getMinorVersion();
            private String spring_version = SpringVersion.getVersion();

            public Setting mapRow(ResultSet rs, int rowNum) throws SQLException {
                String v = rs.getString("value");
                v = v == null ? "" : v;
                v = v.replace("${spring_version}", this.spring_version);
                v = v.replace("${derby_version}", this.derby_version);
                v = v.replace("${pgsql_version}", this.pgsql_version);
                v = v.replace("${crypt_version}", PkiUtility.getProviderVersion());
                v = v.replace("${license_limit}", NyxLicense.getLicenseLimit());
                v = v.replace("${kernel_title}", "Nyx Kernel");
                v = v.replace("${kernel_version}", "0.5.6");
                v = v.replace("${kernel_copy}", "Copyright (C) 2005-2008 Nyx Project. All right reserved.");
                v = v.replace("${kernel_owner}", "Y.Hamanaka at 2005-th");
                v = v.replace("${kernel_extjs}", "Ext 2.0 by extjs.com");
                return new Setting(rs.getString("name"), rs.getString("parent"), rs.getString("mode"), rs.getString("modify"), v, rs.getString("display"));
            }
        }, new Object[0]);
        SettingMap<String, Setting> ret = new SettingMap<String, Setting>();
        int n = res.size();
        for (int i = 0; i < n; ++i) {
            Setting c = (Setting)res.get(i);
            ret.put(c.getName(), c);
        }
        return ret;
    }

    public void saveSetting(Map<String, Setting> setting) {
        Iterator<String> ki = setting.keySet().iterator();
        JdbcTemplate t = this.getJdbcTemplate();
        while (ki.hasNext()) {
            String sql;
            String k = ki.next();
            Setting v = setting.get(k);
            if (!"rw".equals(v.getMode())) continue;
            int r = t.update("update nyx_setting set value=? where name=?", new Object[]{v.getValue(), v.getName()}, new int[]{12, 12});
            if (NyxException.logger.isDebugEnabled()) {
                sql = new StringBuffer("update nyx_setting set value='").append(v.getValue()).append("'").append(" where name='").append(v.getName()).append("'").toString();
                NyxException.logger.debug((Object)sql);
            }
            if (r > 0) continue;
            t.update("insert into nyx_setting(name, parent, mode, modify, value, display) values(?, ?, ?, ?, ?)", new Object[]{v.getName(), v.getParent(), v.getMode(), v.getModify(), v.getValue(), v.getDisplay()}, new int[]{12, 12, 12, 12, 12, 12});
            if (!NyxException.logger.isDebugEnabled()) continue;
            sql = new StringBuffer("insert into nyx_setting(name, parent, mode, modify, value, display) values(").append("'").append(v.getName()).append("'").append(",'").append(v.getParent()).append("'").append(",'").append(v.getMode()).append("'").append(",'").append(v.getModify()).append("'").append(",'").append(v.getValue()).append("'").append(",'").append(v.getDisplay()).append("'").toString();
            NyxException.logger.debug((Object)sql);
        }
    }
}

