/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import jp.nyx.NyxException;
import jp.nyx.common.util.ClassUtility;
import jp.nyx.common.util.Extension;
import jp.nyx.common.util.spec.Csr;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.PasswordFinder;
import org.bouncycastle.x509.X509V2CRLGenerator;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class PkiUtility {
    private static String providerVersion;
    private static String provider;
    private String kpAlgorithm = "RSA";
    private int kpSize = 2048;
    private String kpRandAlg = "SHA1PRNG";
    private String msgDigestAlg = "SHA-1";
    private String signAlg = "SHA1withRSA";
    private BASE64Encoder base64enc = new BASE64Encoder();
    private BASE64Decoder base64dec = new BASE64Decoder();

    public KeyPair generateKeyPair() throws NyxException {
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(this.getKpAlgorithm());
            SecureRandom random = SecureRandom.getInstance(this.getKpRandAlg());
            random.setSeed(System.currentTimeMillis());
            kpg.initialize(this.getKpSize(), random);
            return kpg.generateKeyPair();
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public X509Certificate loadX509Certificate(InputStream x509cert) throws NyxException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (X509Certificate)cf.generateCertificate(x509cert);
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public X509Certificate loadX509Certificate(Reader x509cert) throws NyxException {
        try {
            PEMReader pr = new PEMReader(x509cert);
            X509Certificate cert = (X509Certificate)pr.readObject();
            pr.close();
            return cert;
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public void saveX509Certificate(X509Certificate x509Certificate, Writer out) throws NyxException {
        try {
            PEMWriter pw = new PEMWriter(out);
            pw.writeObject((Object)x509Certificate);
            pw.flush();
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public PrivateKey loadPrivateKey(Reader privateKey, final String passwd) throws NyxException {
        PasswordFinder pf = new PasswordFinder(){

            public char[] getPassword() {
                return passwd.toCharArray();
            }
        };
        if (passwd == null) {
            pf = null;
        }
        try {
            PEMReader pr = new PEMReader(privateKey, pf);
            KeyPair pk = (KeyPair)pr.readObject();
            pr.close();
            return pk.getPrivate();
        }
        catch (Exception e) {
            try {
                PEMReader pr = new PEMReader(privateKey, pf);
                PrivateKey key = (PrivateKey)pr.readObject();
                pr.close();
                return key;
            }
            catch (Exception ze) {
                throw new NyxException(ze);
            }
        }
    }

    public PrivateKey loadPrivateKey(Reader privateKey) throws NyxException {
        return this.loadPrivateKey(privateKey, null);
    }

    public void savePrivateKey(PrivateKey privateKey, Writer out) throws NyxException {
        try {
            PEMWriter pw = new PEMWriter(out);
            pw.writeObject((Object)privateKey);
            pw.flush();
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public void savePrivateKey(PrivateKey privateKey, String keyPass, Writer out) throws NyxException {
        try {
            PEMWriter pw = new PEMWriter(out);
            pw.writeObject((Object)privateKey, "DESEDE", keyPass.toCharArray(), SecureRandom.getInstance(this.getKpRandAlg()));
            pw.flush();
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public Csr savePKCS10CertReq(PublicKey publicKey, PrivateKey privateKey, String subjectDN, Writer out) throws NyxException {
        try {
            PKCS10CertificationRequest pkcs10 = new PKCS10CertificationRequest(this.getSignAlg(), new X500Principal(subjectDN), publicKey, null, privateKey);
            if (out != null) {
                PEMWriter pw = new PEMWriter(out);
                pw.writeObject((Object)pkcs10);
                pw.flush();
            }
            return new Csr(pkcs10);
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public Csr loadPKCS10CertReq(Reader pkcs10) throws NyxException {
        try {
            PEMReader pr = new PEMReader(pkcs10);
            PKCS10CertificationRequest p10 = (PKCS10CertificationRequest)pr.readObject();
            pr.close();
            p10.verify();
            return new Csr(p10);
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public X509Certificate generateSelfSignX509Certificate(GenCertType certGentype, PublicKey publicKey, PrivateKey privateKey, Calendar before, Calendar after, String subjectDN) throws NyxException {
        return this.generateX509Certificate(certGentype, subjectDN, publicKey, privateKey, BigInteger.ONE, after, before, subjectDN, publicKey, BigInteger.ONE);
    }

    public X509Certificate generateX509Certificate(GenCertType certGentype, Csr pkcs10, Calendar notAfter, Calendar notBefore, BigInteger subjectSN, PrivateKey issuerPrivateKey, X509Certificate issuerCert) throws NyxException {
        try {
            X509Certificate ret = this.generateX509Certificate(certGentype, issuerCert.getSubjectX500Principal().getName(), issuerCert.getPublicKey(), issuerPrivateKey, issuerCert.getSerialNumber(), notAfter, notBefore, pkcs10.getSubject(), pkcs10.getPublicKey(), subjectSN);
            return ret;
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public X509Certificate generateX509Certificate(GenCertType certGentype, String issuerDN, PublicKey issuerPublicKey, PrivateKey issuerPrivateKey, BigInteger issuerSN, Calendar notAfter, Calendar notBefore, String subjectDN, PublicKey subjectPublicKey, BigInteger subjectSN) throws NyxException {
        try {
            X509V3CertificateGenerator xcg = new X509V3CertificateGenerator();
            Date notAfterDate = notAfter.getTime();
            Date notBeforeDate = notBefore.getTime();
            int pc = Extension.getCertExtensionCount();
            for (int i = 0; i < pc; ++i) {
                Extension cx = (Extension)Extension.getCertExtension(i).newInstance();
                cx.setCertGentype(certGentype);
                cx.setIssuerDN(issuerDN);
                cx.setIssuerPrivateKey(issuerPrivateKey);
                cx.setIssuerPublicKey(issuerPublicKey);
                cx.setIssuerSN(issuerSN);
                cx.setNotAfter(notAfterDate);
                cx.setNotBefore(notBeforeDate);
                cx.setSubjectDN(subjectDN);
                cx.setSubjectPublicKey(subjectPublicKey);
                cx.setSubjectSN(subjectSN);
                xcg.addExtension(cx.getOID(), cx.getCritical(), cx.generateExtension());
            }
            xcg.setIssuerDN(new X500Principal(issuerDN));
            xcg.setNotAfter(notAfterDate);
            xcg.setNotBefore(notBeforeDate);
            xcg.setPublicKey(subjectPublicKey);
            xcg.setSerialNumber(subjectSN);
            xcg.setSignatureAlgorithm(this.getSignAlg());
            xcg.setSubjectDN(new X500Principal(subjectDN));
            X509Certificate ret = xcg.generate(issuerPrivateKey, SecureRandom.getInstance(this.getKpRandAlg()));
            return ret;
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public void savePKCS12(PrivateKey key, String keyPasswd, X509Certificate cert, OutputStream out) throws NyxException {
        try {
            char[] pass = keyPasswd.toCharArray();
            KeyStore ks = KeyStore.getInstance("BCPKCS12");
            ks.load(null, pass);
            ks.setKeyEntry("p12", key, pass, new Certificate[]{cert});
            ks.store(out, pass);
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public X509CRL loadX509CRL(InputStream x509crl) throws NyxException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (X509CRL)cf.generateCRL(x509crl);
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public void saveX509CRL(X509CRL x509crl, OutputStream out) throws NyxException {
        try {
            out.write(x509crl.getEncoded());
            out.flush();
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public X500Principal generateDN(String C, String ST, String L, String O, String OU, String CN) {
        StringBuffer ret = new StringBuffer();
        if (C != null && !"".equals(C)) {
            ret.append("C=").append(C);
        }
        if (ST != null && !"".equals(ST)) {
            if (ret.length() > 0) {
                ret.append(",");
            }
            ret.append("ST=").append(ST);
        }
        if (L != null && !"".equals(L)) {
            if (ret.length() > 0) {
                ret.append(",");
            }
            ret.append("L=").append(L);
        }
        if (O != null && !"".equals(O)) {
            if (ret.length() > 0) {
                ret.append(",");
            }
            ret.append("O=").append(O);
        }
        if (OU != null && !"".equals(OU)) {
            if (ret.length() > 0) {
                ret.append(",");
            }
            ret.append("OU=").append(OU);
        }
        if (CN != null && !"".equals(CN)) {
            if (ret.length() > 0) {
                ret.append(",");
            }
            ret.append("CN=").append(CN);
        }
        if (ret.length() <= 0) {
            return null;
        }
        return new X500Principal(ret.toString());
    }

    public String getNameValue(X500Principal principal, String key) {
        String[] part;
        if (principal == null || key == null) {
            return null;
        }
        String name = principal.getName();
        for (String p : part = name.split(",")) {
            String[] s = p.split("=");
            if (!key.equals(s[0])) continue;
            return s[1];
        }
        return null;
    }

    public boolean checkPoricy(X500Principal principal, String pC, String pST, String pL, String pO, String pOU, String pCN, String mC, String mST, String mL, String mO, String mOU, String mCN, int lC, int lST, int lL, int lO, int lOU, int lCN) {
        String C = this.getNameValue(principal, "C");
        String ST = this.getNameValue(principal, "ST");
        String L = this.getNameValue(principal, "L");
        String O = this.getNameValue(principal, "O");
        String OU = this.getNameValue(principal, "OU");
        String CN = this.getNameValue(principal, "CN");
        if ("match".equals(pC) && (C == null || C.equals(mC))) {
            return false;
        }
        if ("match".equals(pST) && (ST == null || ST.equals(mST))) {
            return false;
        }
        if ("match".equals(pL) && (L == null || L.equals(mL))) {
            return false;
        }
        if ("match".equals(pO) && (O == null || O.equals(mO))) {
            return false;
        }
        if ("match".equals(pOU) && (OU == null || OU.equals(mOU))) {
            return false;
        }
        if ("match".equals(pCN) && (CN == null || CN.equals(mCN))) {
            return false;
        }
        if ("supplied".equals(pC) && (C == null || "".equals(C)) && (C == null || lC > 0 && C.length() > lC)) {
            return false;
        }
        if ("supplied".equals(pST) && (ST == null || "".equals(ST)) && (ST == null || lST > 0 && ST.length() > lST)) {
            return false;
        }
        if ("supplied".equals(pL) && (L == null || "".equals(L)) && (L == null || lL > 0 && L.length() > lL)) {
            return false;
        }
        if ("supplied".equals(pO) && (O == null || "".equals(O)) && (O == null || lO > 0 && O.length() > lO)) {
            return false;
        }
        if ("supplied".equals(pOU) && (OU == null || "".equals(OU)) && (OU == null || lOU > 0 && OU.length() > lOU)) {
            return false;
        }
        return !"supplied".equals(pCN) || CN != null && !"".equals(CN) || CN != null && (lCN <= 0 || CN.length() <= lCN);
    }

    public void revokeX509Certificate(X509CrlGen gen, X509Certificate cert, Calendar revocationDate, CRLReasonCode code, PrivateKey issuerPrivateKey) throws NyxException {
        try {
            gen.xcg.addCRLEntry(cert.getSerialNumber(), revocationDate.getTime(), code.getCode());
            gen.crl = gen.xcg.generate(issuerPrivateKey, SecureRandom.getInstance(this.getKpRandAlg()));
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public void margeX509CrlGen(X509CrlGen gen, X509CRL crlSource, PrivateKey issuerPrivateKey) throws NyxException {
        try {
            Set<? extends X509CRLEntry> certList = crlSource.getRevokedCertificates();
            if (certList == null) {
                return;
            }
            for (X509CRLEntry x509CRLEntry : certList) {
                if (gen.crl.getRevokedCertificate(x509CRLEntry.getSerialNumber()) != null) continue;
                byte[] reason = x509CRLEntry.getExtensionValue("2.5.29.21");
                byte[] invalidityDate = x509CRLEntry.getExtensionValue("2.5.29.24");
                if (invalidityDate == null || invalidityDate.length < 1) {
                    gen.xcg.addCRLEntry(x509CRLEntry.getSerialNumber(), x509CRLEntry.getRevocationDate(), (int)reason[4]);
                    continue;
                }
                gen.xcg.addCRLEntry(x509CRLEntry.getSerialNumber(), x509CRLEntry.getRevocationDate(), (int)reason[4], DERGeneralizedTime.getInstance((Object)invalidityDate).getDate());
            }
            gen.crl = gen.xcg.generate(issuerPrivateKey, SecureRandom.getInstance(this.getKpRandAlg()));
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public X509CrlGen generateX509CrlGen(PrivateKey issuerPrivateKey, X509Certificate issuerCert, Date nextUpdate, BigInteger crlNumber) throws NyxException {
        try {
            X509CrlGen gen = new X509CrlGen(new X509V2CRLGenerator());
            gen.crl = this.generateX509CRL(issuerPrivateKey, issuerCert, gen.xcg, nextUpdate, crlNumber);
            return gen;
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    private X509CRL generateX509CRL(PrivateKey issuerPrivateKey, X509Certificate issuerCert, X509V2CRLGenerator xcg, Date nextUpdate, BigInteger crlNumber) throws NyxException {
        try {
            xcg.setIssuerDN(issuerCert.getIssuerX500Principal());
            xcg.setNextUpdate(nextUpdate);
            Calendar now = Calendar.getInstance();
            xcg.setThisUpdate(now.getTime());
            xcg.setSignatureAlgorithm(this.getSignAlg());
            int pc = Extension.getCrlExtensionCount();
            for (int i = 0; i < pc; ++i) {
                Extension cx = (Extension)Extension.getCrlExtension(i).newInstance();
                cx.setIssuerDN(issuerCert.getSubjectX500Principal().getName());
                cx.setIssuerPrivateKey(issuerPrivateKey);
                cx.setIssuerPublicKey(issuerCert.getPublicKey());
                cx.setIssuerSN(issuerCert.getSerialNumber());
                cx.setNotAfter(issuerCert.getNotAfter());
                cx.setNotBefore(issuerCert.getNotBefore());
                cx.setCrlNumber(crlNumber);
                xcg.addExtension(cx.getOID(), cx.getCritical(), cx.generateExtension());
            }
            return xcg.generate(issuerPrivateKey, SecureRandom.getInstance(this.getKpRandAlg()));
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    public String base64encode(byte[] b) {
        return this.base64enc.encodeBuffer(b);
    }

    public byte[] base64decode(String s) throws IOException {
        return this.base64dec.decodeBuffer(s);
    }

    public String getKpAlgorithm() {
        return this.kpAlgorithm;
    }

    public void setKpAlgorithm(String kpAlgorithm) {
        this.kpAlgorithm = kpAlgorithm;
    }

    public String getKpRandAlg() {
        return this.kpRandAlg;
    }

    public void setKpRandAlg(String kpRandAlg) {
        this.kpRandAlg = kpRandAlg;
    }

    public int getKpSize() {
        return this.kpSize;
    }

    public void setKpSize(int kpSize) {
        this.kpSize = kpSize;
    }

    public String getMsgDigestAlg() {
        return this.msgDigestAlg;
    }

    public void setMsgDigestAlg(String msgDigestAlg) {
        this.msgDigestAlg = msgDigestAlg;
    }

    public static String getProvider() {
        return provider;
    }

    public static void setProvider(String p) {
        provider = p;
    }

    public String getSignAlg() {
        return this.signAlg;
    }

    public void setSignAlg(String signAlg) {
        this.signAlg = signAlg;
    }

    public static String getProviderVersion() {
        return providerVersion;
    }

    public static void setProviderVersion(String providerVersion) {
        PkiUtility.providerVersion = providerVersion;
    }

    static {
        provider = "org.bouncycastle.jce.provider.BouncyCastleProvider";
        try {
            Provider prv = (Provider)ClassUtility.newInstance(provider);
            Security.addProvider(prv);
            providerVersion = prv.getName() + "v" + prv.getVersion();
        }
        catch (Exception e) {
            NyxException.logger.fatal((Object)"\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u30d7\u30ed\u30d0\u30a4\u30c0\u306e\u767b\u9332\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
        }
    }

    public static enum CRLReasonCode {
        UNSPECIFIED(0, "\u6307\u5b9a\u306a\u3057\u3002"),
        KEY_COMPROMISE(1, "\u8a3c\u660e\u66f8\u5229\u7528\u8005\u306e\u79d8\u5bc6\u9375\u304c\u6f0f\u6d29\u3057\u305f\u3002"),
        CA_COMPROMISE(2, "CA \u306e\u4fe1\u983c\u6027\u304c\u5931\u308f\u308c\u305f\u3002"),
        AFFILIATION_CHANGED(3, "\u8a3c\u660e\u66f8\u306e\u8a18\u8f09\u5185\u5bb9\u304c\u5909\u66f4\u3057\u305f\u3002"),
        SUPERSEDED(4, "\u8a3c\u660e\u66f8\u304c\u7834\u68c4\u3055\u308c\u305f\u3002"),
        CESSATION_OF_OPERATION(5, "\u8a3c\u660e\u66f8\u306e\u5fc5\u8981\u6027\u304c\u306a\u304f\u306a\u3063\u305f\u3002"),
        CERTIFICATE_HOLD(6, "\u8a3c\u660e\u66f8\u4fdd\u7559\u3002"),
        REMOVE_FROM_CRL(8, "CRL \u304b\u3089\u306e\u524a\u9664\u3002");

        private int code;
        private String reason;

        private CRLReasonCode(int code, String reason) {
            this.code = code;
            this.reason = reason;
        }

        public String toString() {
            return this.reason + "(" + this.code + ")";
        }

        public int getCode() {
            return this.code;
        }

        public String getReason() {
            return this.reason;
        }

        public static CRLReasonCode getCRLReasonCode(int code) {
            for (CRLReasonCode c : CRLReasonCode.values()) {
                if (c.getCode() != code) continue;
                return c;
            }
            return null;
        }
    }

    public static enum GenCertType {
        CA(1, "RootCA\u8a3c\u660e\u66f8\u5f62\u5f0f"),
        SUBCA(2, "SubCA\u8a3c\u660e\u66f8\u5f62\u5f0f"),
        SERVER(3, "Server\u8a3c\u660e\u66f8\u5f62\u5f0f"),
        CLIENT(4, "Client\u8a3c\u660e\u66f8\u5f62\u5f0f");

        private int code;
        private String reason;

        private GenCertType(int code, String reason) {
            this.code = code;
            this.reason = reason;
        }

        public String toString() {
            return this.reason + "(" + this.code + ")";
        }

        public int getCode() {
            return this.code;
        }
    }

    public class X509CrlGen {
        protected X509V2CRLGenerator xcg;
        protected X509CRL crl = null;

        protected X509CrlGen(X509V2CRLGenerator xcg) {
            this.xcg = xcg;
        }

        public X509CRL getCrl() {
            return this.crl;
        }
    }
}

