/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.util.spec;

import jp.nyx.NyxException;
import jp.nyx.common.util.Extension;
import jp.nyx.common.util.PkiUtility;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.x509.BasicConstraints;

public class BasicConstraintsExtension
extends Extension {
    @Override
    public DEREncodable generateExtension() throws NyxException {
        try {
            PkiUtility.GenCertType certGentype = this.getCertGentype();
            if (certGentype == PkiUtility.GenCertType.CA || certGentype == PkiUtility.GenCertType.SUBCA) {
                return new BasicConstraints(10);
            }
            return new BasicConstraints(false);
        }
        catch (Exception e) {
            throw new NyxException(e);
        }
    }

    @Override
    public String getOID() {
        return "2.5.29.19";
    }

    @Override
    public boolean getCritical() {
        PkiUtility.GenCertType certGentype = this.getCertGentype();
        return certGentype == PkiUtility.GenCertType.CA || certGentype == PkiUtility.GenCertType.SUBCA;
    }
}

