/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.app.old;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import jp.nyx.common.util.CalendarUtility;
import jp.nyx.common.util.TextUtility;
import jp.nyx.pkg.app.old.SwitchContentsWeb;

public class NoticeWeb
extends SwitchContentsWeb {
    private DataSource authDb;
    private DataSource noticeDb;
    private DataSource adrDb;
    private String remoteUser;
    private Map<String, String> conf = null;

    public void init(ServletContext context, HttpServletRequest request, String authDsName, String noticeDsName, String adrDsName) throws NamingException, IOException, SQLException {
        super.init(context);
        this.authDb = super.lookup(authDsName);
        this.noticeDb = super.lookup(noticeDsName);
        this.adrDb = super.lookup(adrDsName);
        this.remoteUser = SwitchContentsWeb.loadRemoteUser(request);
        Connection authCon = this.authBegin();
        this.conf = this.loadPotalSetting(authCon);
        Connection con = this.authBegin();
        boolean cf = false;
        if (!this.conf.containsKey("PORTAL_URL")) {
            this.conf.put("PORTAL_URL", this.getPotalURL(request));
            cf = true;
        }
        if (cf) {
            this.savePotalSetting(con, this.conf);
            this.commit(con);
        } else {
            this.rollback();
        }
        authCon = this.authBegin();
        this.rollback(authCon);
    }

    @Override
    public boolean isInit() {
        return this.authDb != null && this.noticeDb != null && this.adrDb != null;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public Connection authBegin() throws SQLException {
        Connection con = this.getConnection(this.authDb);
        con.setAutoCommit(false);
        return con;
    }

    public Connection adrBegin() throws SQLException {
        Connection con = this.getConnection(this.adrDb);
        con.setAutoCommit(false);
        return con;
    }

    public Connection noticeBegin() throws SQLException {
        Connection con = this.getConnection(this.noticeDb);
        con.setAutoCommit(false);
        return con;
    }

    public String getConfData(String name) throws SQLException {
        return this.conf.get(name);
    }

    public boolean isMyData(String seq, Connection con) throws SQLException {
        String ru = this.getRemoteUser();
        PreparedStatement st = this.createStatement(con, "select seq from m_portal_notice where seq=? and user_id=?");
        st.setString(1, seq);
        st.setString(2, ru);
        ResultSet rs = st.executeQuery();
        boolean ret = rs.next();
        this.closeStatement(st);
        return ret;
    }

    public String loadMemberEMail(String member_id, Connection adrCon) throws SQLException {
        PreparedStatement st = this.createStatement(adrCon, "select email from t_memberinfo where member_id=?");
        st.setString(1, member_id);
        ResultSet rs = st.executeQuery();
        if (!rs.next()) {
            return null;
        }
        String email = rs.getString("email");
        this.closeStatement(st);
        return email;
    }

    public String sendNotice(String title, String url, String display_start, String display_end, String message, String[] cds, String[] uids, boolean isSendmail, Connection authCon, Connection adrCon) throws SQLException, ParseException {
        int i;
        CalendarUtility calUtil = this.getCalUtil();
        TextUtility textUtil = this.getTextUtil();
        Calendar start = textUtil.isEmpty(display_start) ? null : calUtil.parseCalendar(display_start, "yyyy/MM/dd");
        Calendar end = textUtil.isEmpty(display_end) ? null : calUtil.parseCalendar(display_end, "yyyy/MM/dd");
        String cdSql = "select user_id from m_context_user where context_code=? and enable='t'";
        String insSql = "insert into m_portal_notice(seq, user_id, from_user_id, display_type, display_start, display_end, display_mode, notice_date, url, title, message ) values(nextval('m_portal_notice_seq'), ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement insSt = this.createStatement(authCon, insSql);
        int index = 1;
        Calendar c = calUtil.getCalendar();
        calUtil.chopDay(c);
        if (start != null) {
            calUtil.chopDay(start);
        }
        if (end != null) {
            calUtil.chopDay(end);
        }
        if (start != null && start.before(c)) {
            return "\u901a\u77e5\u671f\u9593\u304c\u4e0d\u6b63\u3067\u3059\u3002\\n\u958b\u59cb\u65e5\u304c\u73fe\u5728\u65e5\u3088\u308a\u524d\u3067\u3059\u3002";
        }
        if (end != null && end.before(c)) {
            return "\u901a\u77e5\u671f\u9593\u304c\u4e0d\u6b63\u3067\u3059\u3002\\n\u7d42\u4e86\u65e5\u304c\u73fe\u5728\u65e5\u3088\u308a\u524d\u3067\u3059\u3002";
        }
        if (start != null && end != null && end.before(start)) {
            return "\u901a\u77e5\u671f\u9593\u304c\u4e0d\u6b63\u3067\u3059\u3002\\n\u7d42\u4e86\u65e5\u304c\u958b\u59cb\u65e5\u3088\u308a\u524d\u3067\u3059\u3002";
        }
        Timestamp ts = new Timestamp(calUtil.getCalendar().getTimeInMillis());
        Timestamp startTs = start == null ? null : new Timestamp(start.getTimeInMillis());
        Timestamp endTs = end == null ? null : new Timestamp(end.getTimeInMillis());
        insSt.setString(++index, this.getRemoteUser());
        insSt.setString(++index, "one");
        insSt.setTimestamp(++index, startTs);
        insSt.setTimestamp(++index, endTs);
        insSt.setString(++index, "visible");
        insSt.setTimestamp(++index, ts);
        insSt.setString(++index, url);
        insSt.setString(++index, title);
        String mailBody = message = textUtil.replace(message, "\r", "");
        message = textUtil.replace(message, "\n", "\\\\n");
        insSt.setString(++index, message);
        HashSet<String> toSet = new HashSet<String>();
        PreparedStatement cdSt = this.createStatement(authCon, cdSql);
        for (i = 0; cds != null && i < cds.length; ++i) {
            cdSt.setString(1, cds[i]);
            ResultSet rs = cdSt.executeQuery();
            while (rs.next()) {
                String uid = rs.getString("user_id");
                if (uid == null) continue;
                insSt.setString(1, uid);
                insSt.executeUpdate();
                toSet.add(uid);
            }
        }
        for (i = 0; uids != null && i < uids.length; ++i) {
            if (uids[i] == null) continue;
            insSt.setString(1, uids[i]);
            toSet.add(uids[i]);
            insSt.executeUpdate();
        }
        if (isSendmail) {
            try {
                String[] to = toSet.toArray(new String[0]);
                this.sendNoticeMail(title, url, mailBody, to, authCon, adrCon);
            }
            catch (Exception e) {
                return "\u30e1\u30fc\u30eb\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\\n\u9001\u4fe1\u5143\u53c8\u306f\u9001\u4fe1\u5148\u30e6\u30fc\u30b6\u30fc\u306e\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304c\u6b63\u3057\u304f\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002\\n\u793e\u54e1\u60c5\u5831\u4e00\u89a7\u306b\u3066\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u3092\u78ba\u8a8d\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            }
        }
        this.closeStatement(insSt);
        this.closeStatement(cdSt);
        return null;
    }

    protected void sendNoticeMail(String title, String url, String message, String[] to_member_id, Connection authCon, Connection adrCon) throws SQLException, UnsupportedEncodingException, AddressException, MessagingException {
        if (to_member_id == null || to_member_id.length <= 0) {
            throw new AddressException("to_member_id is null or empty.");
        }
        String[] to = new String[to_member_id.length];
        TextUtility textUtil = this.getTextUtil();
        for (int i = 0; i < to.length; ++i) {
            if (textUtil.isEmpty(to_member_id[i])) {
                throw new AddressException("to_member_id's collection " + i + " is null or empty.");
            }
            to[i] = this.loadMemberEMail(to_member_id[i], adrCon);
            if (!textUtil.isEmpty(to[i])) continue;
            throw new AddressException("member_id='" + to_member_id[i] + "' email not found.");
        }
        String from = this.loadMemberEMail(this.getRemoteUser(), adrCon);
        super.sendmail(this.conf.get("SMTPSV_IP"), this.conf.get("SMTPSV_PORT"), from, to, "[SWC-Portal-Notice] " + title, this.loadUserName(this.getRemoteUser(), authCon) + "\u3055\u3093\u3088\u308a\u901a\u77e5\u304c\u3042\u308a\u307e\u3059\u3002\n" + "===============================================================\n" + "[ " + url + " ]\n" + "---------------------------------------------------------------\n" + message + "\n\n" + "===============================================================\n" + "Secure-Switch Portal : " + this.conf.get("PORTAL_URL") + "\n");
    }
}

