/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.web;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.web.BaseSettingController;
import jp.nyx.common.web.xml.NyxXmlRpcHandlerMapping;
import jp.nyx.pkg.sso.db.SsoManager;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.webserver.XmlRpcServlet;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class NyxXmlRpcServlet
extends XmlRpcServlet {
    private NyxXmlRpcHandlerMapping mapping = null;

    public void init(ServletConfig config) throws ServletException {
        try {
            super.init(config);
            System.out.println("============================================================");
            System.out.println("[ Nyx Auth Agent RPC Server\u3000version 0.5.6 ]");
            System.out.println("  Powered by Nyx Kernel ver 0.5.6");
            System.out.println("  Copyright (C) 2005-2008 Nyx Project. All right reserved.");
            System.out.println("============================================================");
        }
        catch (Exception e) {
            ServletException se = new ServletException((Throwable)e);
            se.initCause((Throwable)e);
            throw se;
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        NyxManager n = (NyxManager)request.getAttribute("nyxManager");
        if (n != null) {
            this.mapping.setNyxManager(n);
            WebApplicationContext appCtx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
            SsoManager ssoManager = (SsoManager)appCtx.getBean("ssoManager");
            try {
                if (!ssoManager.isInit((ApplicationContext)appCtx)) {
                    BaseSettingController.ssoInit(appCtx, n.loadSetting());
                }
            }
            catch (Exception e) {
                ServletException se = new ServletException((Throwable)e);
                se.initCause((Throwable)e);
                throw se;
            }
        }
        super.doPost(request, response);
    }

    protected XmlRpcHandlerMapping newXmlRpcHandlerMapping() throws XmlRpcException {
        this.mapping = new NyxXmlRpcHandlerMapping(this.getServletContext());
        return this.mapping;
    }
}

