/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.ca.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.db.AccessFactory;
import jp.nyx.common.db.model.Condition;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.PersonalAccess;
import jp.nyx.pkg.ca.db.CaManager;
import jp.nyx.pkg.ca.db.Cert;
import jp.nyx.pkg.ca.web.CaController;
import org.apache.commons.fileupload.FileItem;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.ModelAndView;

public class CaCertController
extends CaController {
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<String, String> status;
        ModelAndView mv = super.handleRequestInternal(request, response);
        WebApplicationContext appCtx = super.getWebApplicationContext();
        CaManager caManager = (CaManager)appCtx.getBean("caManager");
        caManager.init((ApplicationContext)appCtx);
        Map req = this.webUtil.uploadFile(request, 524288L);
        if ("gencsr".equals(req.get("mode"))) {
            Map<String, String> status2 = this.getStatus(mv);
            try {
                ConditionList cond = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
                String serialno = (String)req.get("serialno");
                String issuer_name = (String)req.get("issuer_name");
                cond.add((Object)new Condition("serialno", (Object)serialno));
                cond.add((Object)new Condition("issuer_name", (Object)issuer_name));
                cond.add((Object)new Condition("key_entry", (Object)"t"));
                List<Cert> certs = caManager.loadCert(0, 100, cond);
                mv.getModel().put("certs", certs);
                if (certs == null || certs.size() <= 0) {
                    status2.put("status", "Failed");
                    status2.put("message", "\u767a\u884c\u4f9d\u983c\u66f8\u3092\u4f5c\u6210\u3067\u304d\u308b\u8a3c\u660e\u66f8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                    return mv;
                }
                Cert c = certs.get(0);
                StringWriter w = new StringWriter();
                X509Certificate xc = c.getCertObj();
                X500Principal p = xc.getSubjectX500Principal();
                this.pkiUtil.savePKCS10CertReq(xc.getPublicKey(), c.getPrivatekeyObj(), p.getName(), (Writer)w);
                String cn = this.pkiUtil.getNameValue(p, "CN");
                cn = this.webUtil.textUtil.replace(cn, "[ /]", "");
                status2.put("status", "Successed");
                Map<String, Object> res = this.getRes(mv);
                res.put("csr", w.getBuffer().toString());
                response.setHeader("Content-disposition", "attachment; filename=" + cn + ".p10");
                response.setContentType("application/octet-stream");
                return mv;
            }
            catch (Exception e) {
                status2.put("status", "Failed");
                status2.put("message", "\u767a\u884c\u4f9d\u983c\u66f8\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u767a\u884c\u4f9d\u983c\u66f8\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
                return mv;
            }
        }
        if ("dlcert".equals(req.get("mode"))) {
            status = this.getStatus(mv);
            try {
                ConditionList cond = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
                String serialno = (String)req.get("serialno");
                String issuer_name = (String)req.get("issuer_name");
                cond.add((Object)new Condition("serialno", (Object)serialno));
                cond.add((Object)new Condition("issuer_name", (Object)issuer_name));
                cond.add((Object)new Condition("key_entry", (Object)"t"));
                List<Cert> certs = caManager.loadCert(0, 100, cond);
                if (certs == null || certs.size() <= 0) {
                    status.put("status", "Failed");
                    status.put("message", "\u8a3c\u660e\u66f8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                    return mv;
                }
                Cert c = certs.get(0);
                StringWriter w = new StringWriter();
                X509Certificate xc = c.getCertObj();
                X500Principal p = xc.getSubjectX500Principal();
                this.pkiUtil.saveX509Certificate(xc, (Writer)w);
                String cn = this.pkiUtil.getNameValue(p, "CN");
                cn = this.webUtil.textUtil.replace(cn, "[ /]", "");
                status.put("status", "Successed");
                Map<String, Object> res = this.getRes(mv);
                res.put("crt", w.getBuffer().toString());
                response.setHeader("Content-disposition", "attachment; filename=" + cn + ".crt");
                response.setContentType("application/octet-stream");
                return mv;
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u8a3c\u660e\u66f8\u306e\u8aad\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u8a3c\u660e\u66f8\u306e\u8aad\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
        } else {
            if ("dlpkey".equals(req.get("mode"))) {
                Map<String, String> status3 = this.getStatus(mv);
                try {
                    ConditionList cond = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
                    String serialno = (String)req.get("serialno");
                    String issuer_name = (String)req.get("issuer_name");
                    cond.add((Object)new Condition("serialno", (Object)serialno));
                    cond.add((Object)new Condition("issuer_name", (Object)issuer_name));
                    cond.add((Object)new Condition("key_entry", (Object)"t"));
                    List<Cert> certs = caManager.loadCert(0, 100, cond);
                    if (certs == null || certs.size() <= 0) {
                        status3.put("status", "Failed");
                        status3.put("message", "\u79d8\u5bc6\u9375\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                        return mv;
                    }
                    Cert c = certs.get(0);
                    StringWriter w = new StringWriter();
                    X500Principal p = c.getCertObj().getSubjectX500Principal();
                    this.pkiUtil.savePrivateKey(c.getPrivatekeyObj(), (Writer)w);
                    String cn = this.pkiUtil.getNameValue(p, "CN");
                    cn = this.webUtil.textUtil.replace(cn, "[ /]", "");
                    status3.put("status", "Successed");
                    Map<String, Object> res = this.getRes(mv);
                    res.put("key", w.getBuffer().toString());
                    response.setHeader("Content-disposition", "attachment; filename=" + cn + ".key");
                    response.setContentType("application/octet-stream");
                }
                catch (Exception e) {
                    status3.put("status", "Failed");
                    status3.put("message", "\u79d8\u5bc6\u9375\u306e\u8aad\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    NyxException.logger.error((Object)"\u79d8\u5bc6\u9375\u306e\u8aad\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
                }
                return mv;
            }
            if ("import".equals(req.get("mode"))) {
                return mv;
            }
            if ("importdo".equals(req.get("mode"))) {
                status = this.getStatus(mv);
                try {
                    Cert cert = new Cert();
                    FileItem fiCert = (FileItem)req.get("cert");
                    if (fiCert == null || this.webUtil.textUtil.isEmpty(fiCert.getString())) {
                        status.put("status", "Failed");
                        status.put("message", "CA\u8a3c\u660e\u66f8\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                        return mv;
                    }
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    this.webUtil.uploadFilePipe(fiCert, (OutputStream)bout);
                    X509Certificate c = this.pkiUtil.loadX509Certificate((InputStream)new ByteArrayInputStream(bout.toByteArray()));
                    cert.setCertObj(c);
                    FileItem fiPri = (FileItem)req.get("privatekey");
                    if (fiPri != null && !this.webUtil.textUtil.isEmpty(fiPri.getString())) {
                        ByteArrayOutputStream bout2 = new ByteArrayOutputStream();
                        this.webUtil.uploadFilePipe(fiPri, (OutputStream)bout2);
                        PrivateKey pk = this.pkiUtil.loadPrivateKey((Reader)new InputStreamReader(new ByteArrayInputStream(bout2.toByteArray())), (String)req.get("keypass"));
                        if (pk == null) {
                            status.put("status", "Failed");
                            status.put("message", "\u79d8\u5bc6\u9375\u4fdd\u8b77\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u6b63\u3057\u304f\u3042\u308a\u307e\u305b\u3093\u3002");
                        }
                        cert.setPrivatekeyObj(pk);
                        cert.setKeyEntry("t");
                    }
                    cert.setAlias((String)req.get("alias"));
                    if (!"Failed".equals(status.get("status"))) {
                        caManager.saveCert(cert);
                        Map<String, Object> res = this.getRes(mv);
                        res.put("mode", "importdo");
                        status.put("status", "Successed");
                        status.put("message", "CA\u8a3c\u660e\u66f8\u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
                    }
                }
                catch (Exception e) {
                    status.put("status", "Failed");
                    status.put("message", "CA\u8a3c\u660e\u66f8\u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    NyxException.logger.error((Object)"CA\u8a3c\u660e\u66f8\u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
                }
            }
        }
        ConditionList cond = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
        List<Cert> certs = caManager.loadCert(0, 100, cond);
        mv.getModel().put("certs", certs);
        return mv;
    }
}

