/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.spec;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.pkg.sso.spec.AccessValidaterUtility;
import org.openid4java.OpenIDException;
import org.openid4java.association.AssociationException;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.InMemoryConsumerAssociationStore;
import org.openid4java.consumer.InMemoryNonceVerifier;
import org.openid4java.consumer.NonceVerifier;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.message.sreg.SRegRequest;
import org.openid4java.message.sreg.SRegResponse;

public class OpenIDConsumerUtility {
    private AccessValidaterUtility authUtil;
    private ConsumerManager manager;
    private ServletContext context;

    public OpenIDConsumerUtility(AccessValidaterUtility authUtil, ServletContext context) throws ConsumerException {
        this.authUtil = authUtil;
        this.context = context;
        this.manager = new ConsumerManager();
        this.manager.setAssociations((ConsumerAssociationStore)new InMemoryConsumerAssociationStore());
        this.manager.setNonceVerifier((NonceVerifier)new InMemoryNonceVerifier(5000));
    }

    public void handsake(HttpServletRequest req, HttpServletResponse res, AccessValidaterUtility.AuthValue authValue) throws ServletException, IOException, OpenIDException {
        if ("true".equals(req.getParameter("is_return"))) {
            this.processReturn(req, res, authValue);
        } else {
            this.authRequest(authValue, req, res);
        }
    }

    private void processReturn(HttpServletRequest req, HttpServletResponse res, AccessValidaterUtility.AuthValue authValue) throws ServletException, IOException, MessageException, DiscoveryException, AssociationException {
        Identifier identifier = this.verifyResponse(req);
        if (identifier == null) {
            this.authUtil.sendAuthenticate(req, res, authValue.getFailerSite());
        }
    }

    public void authRequest(AccessValidaterUtility.AuthValue authValue, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException, OpenIDException {
        StringBuilder returnToUrl = new StringBuilder(authValue.getTriggerSite().toString());
        if (returnToUrl.indexOf("?") >= 0) {
            returnToUrl.append("&is_return=true");
        } else {
            returnToUrl.append("?is_return=true");
        }
        List discoveries = this.manager.discover(authValue.getUserId());
        DiscoveryInformation discovered = this.manager.associate(discoveries);
        req.getSession().setAttribute("openid-disc", (Object)discovered);
        AuthRequest authReq = this.manager.authenticate(discovered, returnToUrl.toString());
        FetchRequest fetch = FetchRequest.createFetchRequest();
        SRegRequest sregReq = SRegRequest.createFetchRequest();
        if ("1".equals(req.getParameter("nickname"))) {
            sregReq.addAttribute("nickname", false);
        }
        if ("1".equals(req.getParameter("email"))) {
            fetch.addAttribute("email", "http://schema.openid.net/contact/email", false);
            sregReq.addAttribute("email", false);
        }
        if ("1".equals(req.getParameter("fullname"))) {
            fetch.addAttribute("fullname", "http://schema.openid.net/contact/fullname", false);
            sregReq.addAttribute("fullname", false);
        }
        if ("1".equals(req.getParameter("dob"))) {
            fetch.addAttribute("dob", "http://schema.openid.net/contact/dob", true);
            sregReq.addAttribute("dob", false);
        }
        if ("1".equals(req.getParameter("gender"))) {
            fetch.addAttribute("gender", "http://schema.openid.net/contact/gender", false);
            sregReq.addAttribute("gender", false);
        }
        if ("1".equals(req.getParameter("postcode"))) {
            fetch.addAttribute("postcode", "http://schema.openid.net/contact/postcode", false);
            sregReq.addAttribute("postcode", false);
        }
        if ("1".equals(req.getParameter("country"))) {
            fetch.addAttribute("country", "http://schema.openid.net/contact/country", false);
            sregReq.addAttribute("country", false);
        }
        if ("1".equals(req.getParameter("language"))) {
            fetch.addAttribute("language", "http://schema.openid.net/contact/language", false);
            sregReq.addAttribute("language", false);
        }
        if ("1".equals(req.getParameter("timezone"))) {
            fetch.addAttribute("timezone", "http://schema.openid.net/contact/timezone", false);
            sregReq.addAttribute("timezone", false);
        }
        if (!sregReq.getAttributes().isEmpty()) {
            authReq.addExtension((MessageExtension)sregReq);
        }
        if (!discovered.isVersion2()) {
            res.sendRedirect(authReq.getDestinationUrl(true));
        } else {
            PrintWriter out = res.getWriter();
            out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
            out.println("<body onload=\"document.f.submit();\">");
            out.println("<form name=\"f\" action=\"" + authReq.getOPEndpoint() + "\" method=\"post\" accept-charset=\"utf-8\">");
            Map param = req.getParameterMap();
            for (Object k : param.keySet()) {
                out.println("<input type=\"hidden\" name=\"" + k + "\" value=\"" + param.get(k) + "\"/>");
            }
            out.println("<button type=\"submit\">Continue...</button>");
            out.println("</form>");
            out.println("</body>");
            out.println("</html>");
        }
    }

    public Identifier verifyResponse(HttpServletRequest httpReq) throws MessageException, DiscoveryException, AssociationException {
        VerificationResult verification;
        Identifier verified;
        ParameterList response = new ParameterList(httpReq.getParameterMap());
        DiscoveryInformation discovered = (DiscoveryInformation)httpReq.getSession().getAttribute("openid-disc");
        StringBuffer receivingURL = httpReq.getRequestURL();
        String queryString = httpReq.getQueryString();
        if (queryString != null && queryString.length() > 0) {
            receivingURL.append("?").append(httpReq.getQueryString());
        }
        if ((verified = (verification = this.manager.verify(receivingURL.toString(), response, discovered)).getVerifiedId()) != null) {
            MessageExtension ext;
            AuthSuccess authSuccess = (AuthSuccess)verification.getAuthResponse();
            if (authSuccess.hasExtension("http://openid.net/sreg/1.0") && (ext = authSuccess.getExtension("http://openid.net/sreg/1.0")) instanceof SRegResponse) {
                SRegResponse sregResp = (SRegResponse)ext;
                for (String name : sregResp.getAttributeNames()) {
                    String value = sregResp.getParameterValue(name);
                    httpReq.setAttribute(name, (Object)value);
                }
            }
            if (authSuccess.hasExtension("http://openid.net/srv/ax/1.0-draft4")) {
                FetchResponse fetchResp = (FetchResponse)authSuccess.getExtension("http://openid.net/srv/ax/1.0-draft4");
                List aliases = fetchResp.getAttributeAliases();
                for (String alias : aliases) {
                    List values = fetchResp.getAttributeValues(alias);
                    if (values.size() <= 0) continue;
                    httpReq.setAttribute(alias, values.get(0));
                }
            }
            return verified;
        }
        return null;
    }
}

