/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.sso.web;

import java.io.File;
import java.io.FilenameFilter;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.nyx.NyxException;
import jp.nyx.common.db.AccessFactory;
import jp.nyx.common.db.model.Condition;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.PersonalAccess;
import jp.nyx.pkg.sso.db.SsoManager;
import jp.nyx.pkg.sso.db.model.Log;
import jp.nyx.pkg.sso.web.SsoController;
import org.springframework.context.ApplicationContext;
import org.springframework.web.servlet.ModelAndView;

public class LogController
extends SsoController {
    @Override
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map<String, String> status;
        Calendar cal;
        ModelAndView mv = super.handleRequestInternal(request, response);
        Map<String, Object> res = this.getRes(mv);
        res.put("limit", this.webUtil.numUtil.parseInt(request.getParameter("limit"), 100));
        SsoManager ssoManager = super.getSsoManager();
        ssoManager.init((ApplicationContext)super.getWebApplicationContext());
        String group = request.getParameter("group");
        String log_date_start_search = request.getParameter("log_date_start_search");
        String log_date_end_search = request.getParameter("log_date_end_search");
        String log_level_search = request.getParameter("log_level_search");
        String act_search = request.getParameter("act_search");
        String auth_type_search = request.getParameter("auth_type_search");
        String auth_use_search = request.getParameter("auth_use_search");
        String auth_user_id_search = request.getParameter("auth_user_id_search");
        String client_ip_search = request.getParameter("client_ip_search");
        String trigger_method_search = request.getParameter("trigger_method_search");
        String trigger_url_search = request.getParameter("trigger_url_search");
        String valid_url_search = request.getParameter("valid_url_search");
        String cause_search = request.getParameter("cause_search");
        String session_search = request.getParameter("session_search");
        ConditionList cond = new ConditionList(AccessFactory.createAccess(PersonalAccess.class));
        if (this.webUtil.calUtil.canParseCalendar(log_date_start_search, "yyyy/MM/dd")) {
            cal = this.webUtil.calUtil.parseCalendar(log_date_start_search, "yyyy/MM/dd");
            this.webUtil.calUtil.chopDay(cal);
            cond.add((Object)new Condition("log_date", (Object)new Timestamp(cal.getTimeInMillis()), ">="));
            res.put("log_date_start_search", log_date_start_search);
        } else {
            cal = this.webUtil.calUtil.getCalendar();
            this.webUtil.calUtil.chopDay(cal);
            cal.add(6, -2);
            cond.add((Object)new Condition("log_date", (Object)new Timestamp(cal.getTimeInMillis()), ">="));
            res.put("log_date_start_search", this.webUtil.calUtil.formatCalendar(cal, "yyyy/MM/dd"));
        }
        if (this.webUtil.calUtil.canParseCalendar(log_date_end_search, "yyyy/MM/dd")) {
            cal = this.webUtil.calUtil.parseCalendar(log_date_end_search, "yyyy/MM/dd");
            cal.add(6, 1);
            this.webUtil.calUtil.chopDay(cal);
            cond.add((Object)new Condition("log_date", (Object)new Timestamp(cal.getTimeInMillis()), "<"));
            res.put("log_date_end_search", log_date_end_search);
        }
        if (!this.webUtil.textUtil.isEmpty(log_level_search)) {
            cond.add((Object)new Condition("log_level", (Object)log_level_search));
            res.put("log_level_search", log_level_search);
        }
        if (!this.webUtil.textUtil.isEmpty(act_search)) {
            cond.add((Object)new Condition("act", (Object)act_search, "~"));
            res.put("act_search", act_search);
        }
        if (!this.webUtil.textUtil.isEmpty(auth_type_search)) {
            cond.add((Object)new Condition("auth_type", (Object)auth_type_search));
            res.put("auth_type_search", auth_type_search);
        }
        if (!this.webUtil.textUtil.isEmpty(auth_use_search)) {
            cond.add((Object)new Condition("auth_use", (Object)auth_use_search));
            res.put("auth_use_search", auth_use_search);
        }
        if (!this.webUtil.textUtil.isEmpty(auth_user_id_search)) {
            cond.add((Object)new Condition("auth_user_id", (Object)auth_user_id_search, "~"));
            res.put("auth_user_id_search", auth_user_id_search);
        }
        if (!this.webUtil.textUtil.isEmpty(client_ip_search)) {
            cond.add((Object)new Condition("client_ip", (Object)client_ip_search, "~"));
            res.put("client_ip_search", client_ip_search);
        }
        if (!this.webUtil.textUtil.isEmpty(trigger_method_search)) {
            cond.add((Object)new Condition("trigger_method", (Object)trigger_method_search));
            res.put("trigger_method_search", trigger_method_search);
        }
        if (!this.webUtil.textUtil.isEmpty(trigger_url_search)) {
            cond.add((Object)new Condition("trigger_url", (Object)trigger_url_search, "~"));
            res.put("trigger_url_search", trigger_url_search);
        }
        if (!this.webUtil.textUtil.isEmpty(valid_url_search)) {
            cond.add((Object)new Condition("valid_url", (Object)valid_url_search, "~"));
            res.put("valid_url_search", valid_url_search);
        }
        if (!this.webUtil.textUtil.isEmpty(cause_search)) {
            cond.add((Object)new Condition("cause", (Object)cause_search, "~"));
            res.put("cause_search", cause_search);
        }
        if (!this.webUtil.textUtil.isEmpty(session_search)) {
            cond.add((Object)new Condition("session", (Object)session_search, "~"));
            res.put("session_search", session_search);
        }
        if ("deldo".equals(request.getParameter("mode"))) {
            status = this.getStatus(mv);
            try {
                String[] seq = request.getParameterValues("seq");
                for (int i = 0; seq != null && i < seq.length; ++i) {
                    ssoManager.deleteLog(this.webUtil.numUtil.parseInt(seq[i]));
                }
                status.put("status", "Successed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
            return mv;
        }
        if ("searchdeldo".equals(request.getParameter("mode"))) {
            status = this.getStatus(mv);
            try {
                ssoManager.deleteLog(cond);
                status.put("status", "Successed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
            return mv;
        }
        if ("importdo".equals(request.getParameter("mode"))) {
            status = this.getStatus(mv);
            try {
                File[] logFiles;
                File logDir = new File("logs");
                for (File f : logFiles = logDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File f, String fn) {
                        if (fn == null) {
                            return false;
                        }
                        return fn.matches("nyx.kernel.log.[0-9]{4}-[0-9]{2}-[0-9]{2}-[0-9]{2}");
                    }
                })) {
                    if (!f.canWrite()) continue;
                    ssoManager.saveLog(f);
                    f.delete();
                }
                status.put("status", "Successed");
                status.put("message", "\u30a4\u30f3\u30dd\u30fc\u30c8\u51e6\u7406\u304c\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002");
            }
            catch (Exception e) {
                status.put("status", "Failed");
                status.put("message", "\u30a4\u30f3\u30dd\u30fc\u30c8\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                NyxException.logger.error((Object)"\u30a4\u30f3\u30dd\u30fc\u30c8\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)e);
            }
            return mv;
        }
        if (!this.webUtil.textUtil.isEmpty(group)) {
            group = "log_date".equals(group) ? "log_date::date" : group;
            String order = "log_date::date".equals(group) ? "log_date::date desc" : "cnt desc";
            List<Map<String, Object>> recode = ssoManager.loadLogGroup(group, "cnt", order, this.getOffset(mv), this.getLimit(mv), cond);
            mv.getModel().put("recode", recode);
        }
        ssoManager.deleteLog(this.getNyx(mv));
        this.setRowcount(mv, ssoManager.loadDataCount("t_log", cond));
        List<Log> logs = ssoManager.loadLog(this.getOffset(mv), this.getLimit(mv), cond);
        mv.getModel().put("logs", logs);
        return mv;
    }
}

