/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.web;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.Setting;
import jp.nyx.common.util.WebUtility;
import jp.nyx.common.web.xml.NyxXmlRpcHandlerMapping;
import jp.nyx.pkg.sso.db.SsoManager;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.webserver.XmlRpcServlet;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class NyxXmlRpcServlet
extends XmlRpcServlet {
    private NyxXmlRpcHandlerMapping mapping = null;
    private WebUtility webUtil = new WebUtility();
    private Map<String, Setting> nyx = null;
    private NyxManager nyxManager = null;
    private WebApplicationContext appCtx = null;

    public void init(ServletConfig config) throws ServletException {
        try {
            System.out.println("============================================================");
            System.out.println("[ Nyx Auth Agent RPC Server\u3000version 0.5.9.e ]");
            System.out.println("  Powered by Nyx Kernel ver 0.5.9.e");
            System.out.println("  Copyright (C) 2005-2008 Nyx Project. All right reserved.");
            System.out.println("============================================================");
            this.appCtx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)config.getServletContext());
            this.nyxManager = (NyxManager)this.appCtx.getBean("nyxManager");
            this.nyx = this.nyxManager.loadSetting();
            DataSource ssoDs = (DataSource)this.appCtx.getBean("ssoDataSource");
            Method m = ssoDs.getClass().getMethod("setDriverClassName", String.class);
            m.invoke((Object)ssoDs, this.nyx.get("sso_jdbc_driver").getValue());
            m = ssoDs.getClass().getMethod("setUrl", String.class);
            m.invoke((Object)ssoDs, this.nyx.get("sso_jdbc_url").getValue());
            m = ssoDs.getClass().getMethod("setUsername", String.class);
            m.invoke((Object)ssoDs, this.nyx.get("sso_jdbc_user").getValue());
            m = ssoDs.getClass().getMethod("setPassword", String.class);
            m.invoke((Object)ssoDs, this.nyx.get("sso_jdbc_pass").getValue());
            SsoManager ssoManager = (SsoManager)this.appCtx.getBean("ssoManager");
            if (!ssoManager.isInit((ApplicationContext)this.appCtx)) {
                ssoManager.init((ApplicationContext)this.appCtx);
            }
            super.init(config);
        }
        catch (Exception e) {
            ServletException se = new ServletException((Throwable)e);
            se.initCause((Throwable)e);
            throw se;
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.nyx != null) {
            String[] ips = this.webUtil.textUtil.nvl(this.nyx.get("kernel_xmlrpc_access").getValue()).split(",");
            boolean ipauth = false;
            for (String ip : ips) {
                if (this.webUtil.textUtil.isEmpty(ip) || !ip.equals(request.getRemoteAddr())) continue;
                ipauth = true;
            }
            if (!ipauth) {
                this.webUtil.redirectError(request, response, 403, "It is connection client IP that has not been permitted.", null);
                return;
            }
        }
        super.doPost(request, response);
    }

    protected XmlRpcHandlerMapping newXmlRpcHandlerMapping() throws XmlRpcException {
        this.mapping = new NyxXmlRpcHandlerMapping(this.getServletContext());
        this.mapping.setNyxManager(this.nyxManager);
        return this.mapping;
    }
}

