/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.web.xml;

import javax.sql.DataSource;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.util.DigestUtility;
import jp.nyx.common.web.xml.NxyXmlRpcHandler;
import jp.nyx.pkg.sso.spec.AccessValidaterUtility;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;

public class SsoXmlRpcCheckUserHandler
implements NxyXmlRpcHandler {
    private AccessValidaterUtility util;
    private NyxManager nyxManager;
    private DataSource ssoDs = null;

    public SsoXmlRpcCheckUserHandler(DataSource ssoDs) {
        this.ssoDs = ssoDs;
    }

    public Object execute(XmlRpcRequest req) throws XmlRpcException {
        if (req.getParameterCount() < 2) {
            throw new XmlRpcException("The RPC is IllegalArgument. Param count is not 2.");
        }
        String userId = (String)req.getParameter(0);
        String passwd = (String)req.getParameter(1);
        try {
            boolean ret = this.util.checkUser(this.ssoDs, userId, DigestUtility.md5((String)passwd));
            if (ret) {
                return true;
            }
            return this.util.checkUser(this.ssoDs, userId, DigestUtility.sha1((String)passwd));
        }
        catch (Exception e) {
            XmlRpcException xe = new XmlRpcException(e.getMessage());
            xe.initCause((Throwable)e);
            throw xe;
        }
    }

    @Override
    public NyxManager getNyxManager() {
        return this.nyxManager;
    }

    @Override
    public void setNyxManager(NyxManager nyxManager) {
        this.nyxManager = nyxManager;
        this.util = new AccessValidaterUtility(this.nyxManager);
    }

    @Override
    public String getMethodName() {
        return "Sso.checkUser";
    }
}

