/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.common.web.xml;

import java.util.List;
import jp.nyx.NyxException;
import jp.nyx.common.db.NyxManager;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.db.model.User;
import jp.nyx.common.util.WebUtility;
import jp.nyx.common.web.xml.NxyXmlRpcHandler;
import jp.nyx.pkg.sso.db.SsoManager;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;

public class SsoXmlRpcGetUsersHandler
implements NxyXmlRpcHandler {
    private NyxManager nyxManager;
    private SsoManager ssoManager = null;
    private WebUtility webUtil = new WebUtility();

    public SsoXmlRpcGetUsersHandler(SsoManager ssoManager) {
        this.ssoManager = ssoManager;
    }

    public Object execute(XmlRpcRequest req) throws XmlRpcException {
        if (req.getParameterCount() < 2) {
            throw new XmlRpcException("The RPC is IllegalArgument. Param count is not 2.");
        }
        ConditionList conditions = (ConditionList)req.getParameter(0);
        int offset = this.webUtil.numUtil.parseInt(req.getParameter(1).toString());
        int limit = this.webUtil.numUtil.parseInt(req.getParameter(2).toString());
        if (conditions == null) {
            throw new XmlRpcException("The RPC is IllegalArgument. ConditionList is null.");
        }
        if (offset < 0) {
            throw new XmlRpcException("The RPC is IllegalArgument. offset < 0");
        }
        if (limit < 1) {
            throw new XmlRpcException("The RPC is IllegalArgument. limit < 1");
        }
        try {
            List<User> users = this.ssoManager.loadUser(offset, limit, conditions);
            return users;
        }
        catch (NyxException e) {
            XmlRpcException xe = new XmlRpcException(e.getMessage());
            xe.initCause((Throwable)e);
            throw xe;
        }
    }

    @Override
    public NyxManager getNyxManager() {
        return this.nyxManager;
    }

    @Override
    public void setNyxManager(NyxManager nyxManager) {
        this.nyxManager = nyxManager;
    }

    @Override
    public String getMethodName() {
        return "Sso.getUsers";
    }
}

