/*
 * Decompiled with CFR 0.152.
 */
package jp.nyx.pkg.ca.db;

import java.math.BigInteger;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import jp.nyx.NyxException;
import jp.nyx.common.db.Setting;
import jp.nyx.common.db.model.ConditionList;
import jp.nyx.common.util.PkiUtility;
import jp.nyx.common.util.WebUtility;
import jp.nyx.pkg.ca.db.CaDao;
import jp.nyx.pkg.ca.db.Cert;
import jp.nyx.pkg.ca.db.NewCert;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;

public class CaManager {
    public final WebUtility webUtil = new WebUtility();
    private static final String ATTR_CATRANSACTION = "caTransactionManager";
    private CaDao dao;
    private ApplicationContext appCtx = null;
    private PkiUtility pkiUtil = new PkiUtility();
    private SecureRandom random = SecureRandom.getInstance("SHA1PRNG");

    public void setCaDao(CaDao dao) throws SQLException {
        this.dao = dao;
    }

    private TransactionStatus begin() {
        DataSourceTransactionManager caTxManager = (DataSourceTransactionManager)this.appCtx.getBean(ATTR_CATRANSACTION);
        TransactionStatus tx = caTxManager.getTransaction((TransactionDefinition)new DefaultTransactionAttribute(0));
        if (!tx.isNewTransaction()) {
            caTxManager.rollback(tx);
        }
        return tx;
    }

    private void rollback(TransactionStatus tx) {
        DataSourceTransactionManager caTxManager = (DataSourceTransactionManager)this.appCtx.getBean(ATTR_CATRANSACTION);
        caTxManager.rollback(tx);
    }

    private void commit(TransactionStatus tx) {
        DataSourceTransactionManager caTxManager = (DataSourceTransactionManager)this.appCtx.getBean(ATTR_CATRANSACTION);
        caTxManager.commit(tx);
    }

    public void init(ApplicationContext appCtx) throws NyxException {
        ResourceBundle conf;
        this.appCtx = appCtx;
        if (this.dao.isInit()) {
            return;
        }
        TransactionStatus tx = this.begin();
        try {
            conf = this.dao.isPostgreSQL() ? PropertyResourceBundle.getBundle("jp.nyx.pkg.ca.db.ca_sql_pg") : PropertyResourceBundle.getBundle("jp.nyx.pkg.ca.db.ca_sql_derby");
        }
        catch (SQLException e) {
            throw new NyxException((Throwable)e);
        }
        String[] sql = conf.getString("sql").split(";");
        try {
            for (int i = 0; i < sql.length; ++i) {
                if (sql[i] == null || sql[i].trim().length() <= 0) continue;
                this.dao.update(sql[i].replaceAll("<semicolon>", ";"));
            }
            this.commit(tx);
        }
        catch (Exception e) {
            this.rollback(tx);
            NyxException ne = new NyxException((Throwable)e);
            throw ne;
        }
    }

    public void initCA(ApplicationContext appCtx, Map<String, Setting> nyx) throws NyxException {
        if (this.dao.isInitCa()) {
            return;
        }
        TransactionStatus tx = this.begin();
        try {
            Calendar end;
            KeyPair kp = this.pkiUtil.generateKeyPair();
            String subjectDN = "";
            String C = nyx.get("ca_init_c").getValue();
            String ST = nyx.get("ca_init_st").getValue();
            String L = nyx.get("ca_init_l").getValue();
            String O = nyx.get("ca_init_o").getValue();
            String OU = nyx.get("ca_init_ou").getValue();
            String CN = nyx.get("ca_init_cn").getValue();
            X500Principal principal = this.pkiUtil.generateDN(C, ST, L, O, OU, CN);
            String pC = nyx.get("ca_policy_poricy_C").getValue();
            String pST = nyx.get("ca_policy_poricy_St").getValue();
            String pL = nyx.get("ca_policy_poricy_L").getValue();
            String pO = nyx.get("ca_policy_poricy_O").getValue();
            String pOU = nyx.get("ca_policy_poricy_Ou").getValue();
            String pCN = nyx.get("ca_policy_poricy_Cn").getValue();
            String mC = nyx.get("ca_policy_default_C").getValue();
            String mST = nyx.get("ca_policy_default_St").getValue();
            String mL = nyx.get("ca_policy_default_L").getValue();
            String mO = nyx.get("ca_policy_default_O").getValue();
            String mOU = nyx.get("ca_policy_default_Ou").getValue();
            String mCN = nyx.get("ca_policy_default_Cn").getValue();
            int lC = this.webUtil.numUtil.parseInt(nyx.get("ca_policy_default_C_max").getValue(), -1);
            int lST = this.webUtil.numUtil.parseInt(nyx.get("ca_policy_default_St_max").getValue(), -1);
            int lL = this.webUtil.numUtil.parseInt(nyx.get("ca_policy_default_L_max").getValue(), -1);
            int lO = this.webUtil.numUtil.parseInt(nyx.get("ca_policy_default_O_max").getValue(), -1);
            int lOU = this.webUtil.numUtil.parseInt(nyx.get("ca_policy_default_Ou_max").getValue(), -1);
            int lCN = this.webUtil.numUtil.parseInt(nyx.get("ca_policy_default_Cn_max").getValue(), -1);
            boolean check = this.pkiUtil.checkPoricy(principal, pC, pST, pL, pO, pOU, pCN, mC, mST, mL, mO, mOU, mCN, lC, lST, lL, lO, lOU, lCN);
            subjectDN = principal.getName();
            if (!check) {
                this.rollback(tx);
                throw new NyxException("Unmatch CA poricy.(" + subjectDN + ")");
            }
            Calendar start = this.webUtil.textUtil.isEmpty(nyx.get("ca_init_z_start").getValue()) ? this.webUtil.calUtil.getCalendar() : this.webUtil.calUtil.parseCalendar(nyx.get("ca_init_z_start").getValue(), "yyyy/MM/dd");
            if (this.webUtil.textUtil.isEmpty(nyx.get("ca_init_z_end").getValue())) {
                end = this.webUtil.calUtil.getCalendar();
                end.add(1, 1);
            } else {
                end = this.webUtil.calUtil.parseCalendar(nyx.get("ca_init_z_end").getValue(), "yyyy/MM/dd");
            }
            String alias = nyx.get("ca_init_alias").getValue();
            X509Certificate cert = this.pkiUtil.generateSelfSignX509Certificate(PkiUtility.GenCertType.CA, kp.getPublic(), kp.getPrivate(), start, end, subjectDN);
            Cert certObj = new Cert();
            certObj.setAlias(alias);
            certObj.setCertObj(cert);
            certObj.setPrivatekeyObj(kp.getPrivate());
            this.dao.saveCert(certObj);
            this.commit(tx);
        }
        catch (Exception e) {
            this.rollback(tx);
            NyxException ne = new NyxException((Throwable)e);
            throw ne;
        }
    }

    public PkiUtility getUtil() {
        return this.dao.getUtil();
    }

    public List<Cert> loadCert(int offset, int limit, ConditionList conditions) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<Cert> ret = this.dao.loadCert(offset, limit, conditions);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void saveCert(Cert cert) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.saveCert(cert);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public List<NewCert> loadNewCert(int offset, int limit, ConditionList conditions) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            List<NewCert> ret = this.dao.loadNewCert(offset, limit, conditions);
            this.rollback(tx);
            return ret;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public SSLSocketFactory generateSSLSocketFactory(ConditionList conditions) throws NyxException {
        List<Cert> certs = this.loadCert(0, 1000, conditions);
        final ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        for (Cert cert : certs) {
            if (cert.getCertObj() == null) continue;
            list.add(cert.getCertObj());
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return list.toArray(new X509Certificate[0]);
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(new KeyManager[0], trustAllCerts, this.random);
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new NyxException((Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new NyxException((Throwable)e);
        }
    }

    public NewCert saveNewCert(String alias, String C, String ST, String L, String O, String OU, String CN, Calendar start, Calendar end, PkiUtility.GenCertType type, X509Certificate issuerCert, PrivateKey issuerKey, Map<String, Setting> nyx) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            X500Principal principal = this.pkiUtil.generateDN(C, ST, L, O, OU, CN);
            String pC = nyx.get("ca_policy_poricy_C").getValue();
            String pST = nyx.get("ca_policy_poricy_St").getValue();
            String pL = nyx.get("ca_policy_poricy_L").getValue();
            String pO = nyx.get("ca_policy_poricy_O").getValue();
            String pOU = nyx.get("ca_policy_poricy_Ou").getValue();
            String pCN = nyx.get("ca_policy_poricy_Cn").getValue();
            String mC = nyx.get("ca_policy_default_C").getValue();
            String mST = nyx.get("ca_policy_default_St").getValue();
            String mL = nyx.get("ca_policy_default_L").getValue();
            String mO = nyx.get("ca_policy_default_O").getValue();
            String mOU = nyx.get("ca_policy_default_Ou").getValue();
            String mCN = nyx.get("ca_policy_default_Cn").getValue();
            int lC = this.webUtil.numUtil.parseInt(nyx.get("ca_policy_default_C_max").getValue(), -1);
            int lST = this.webUtil.numUtil.parseInt(nyx.get("ca_policy_default_St_max").getValue(), -1);
            int lL = this.webUtil.numUtil.parseInt(nyx.get("ca_policy_default_L_max").getValue(), -1);
            int lO = this.webUtil.numUtil.parseInt(nyx.get("ca_policy_default_O_max").getValue(), -1);
            int lOU = this.webUtil.numUtil.parseInt(nyx.get("ca_policy_default_Ou_max").getValue(), -1);
            int lCN = this.webUtil.numUtil.parseInt(nyx.get("ca_policy_default_Cn_max").getValue(), -1);
            boolean check = this.pkiUtil.checkPoricy(principal, pC, pST, pL, pO, pOU, pCN, mC, mST, mL, mO, mOU, mCN, lC, lST, lL, lO, lOU, lCN);
            String subjectDN = principal.getName();
            if (!check) {
                throw new NyxException("Unmatch CA poricy.(" + subjectDN + ")");
            }
            if (start == null) {
                start = this.webUtil.calUtil.getCalendar();
            }
            if (end == null) {
                end = this.webUtil.calUtil.getCalendar();
                end.add(1, 1);
            }
            KeyPair kp = this.pkiUtil.generateKeyPair();
            X509Certificate cert = this.pkiUtil.generateX509Certificate(type, issuerCert.getSubjectX500Principal().toString(), issuerCert.getPublicKey(), issuerKey, issuerCert.getSerialNumber(), end, start, subjectDN, kp.getPublic(), new BigInteger("" + this.dao.nextSequence("ca_newcert_seq")));
            NewCert newCert = new NewCert();
            newCert.setCertObj(cert);
            newCert.setPrivatekeyObj(kp.getPrivate());
            newCert.setAlias(alias == null ? CN : alias);
            this.dao.saveNewCert(newCert);
            this.commit(tx);
            return newCert;
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }

    public void saveNewCert(NewCert newCert) throws NyxException {
        TransactionStatus tx = this.begin();
        try {
            this.dao.saveNewCert(newCert);
            this.commit(tx);
        }
        catch (Exception e) {
            NyxException ne = new NyxException((Throwable)e);
            this.rollback(tx);
            throw ne;
        }
    }
}

